/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.BitPatternInputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.CustomEditorInputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.EnumerationInputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.InputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.RangeInputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.RelativeDateInputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.RelativeTimeInputRestriction;
import ericsson.ere.datatype.DataType;
import ericsson.ere.xml.ElementIterator;
import ericsson.vareditor.variable.RangeObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public enum InputRestrictionType {
    RANGE{

        @Override
        public InputRestriction<?> createInputRestriction(Object valueObject, DataType dt) {
            RangeObject ro = (RangeObject)valueObject;
            return new RangeInputRestriction(ro, dt);
        }

        @Override
        protected InputRestriction<?> createInputRestriction(Element editComponentRoot, DataType dataType) {
            RangeInputRestriction ret = null;
            NodeList rangeList = editComponentRoot.getElementsByTagName("Range");
            if (rangeList.getLength() > 0) {
                ret = new RangeInputRestriction(rangeList, dataType);
            }
            return ret;
        }
    }
    ,
    ENUMERATION{

        @Override
        public InputRestriction<?> createInputRestriction(Object valueObject, DataType dt) {
            Object[] valueArray = (Object[])valueObject;
            return new EnumerationInputRestriction(valueArray, dt);
        }

        @Override
        protected InputRestriction<?> createInputRestriction(Element editComponentRoot, DataType dataType) {
            EnumerationInputRestriction ret = null;
            NodeList enumList = editComponentRoot.getElementsByTagName("Enum");
            if (enumList.getLength() > 0) {
                ret = new EnumerationInputRestriction(enumList, dataType);
            }
            return ret;
        }
    }
    ,
    BIT_PATTERN{

        @Override
        public InputRestriction<?> createInputRestriction(Object valueObject, DataType dt) {
            return new BitPatternInputRestriction();
        }

        @Override
        protected InputRestriction<?> createInputRestriction(Element editComponentRoot, DataType dataType) {
            BitPatternInputRestriction ret = null;
            NodeList bitPatternList = editComponentRoot.getElementsByTagName("BitPattern");
            if (bitPatternList.getLength() > 0) {
                ret = new BitPatternInputRestriction();
            }
            return ret;
        }
    }
    ,
    RELATIVE_DATE{

        @Override
        public InputRestriction<?> createInputRestriction(Object valueObject, DataType dt) {
            return new RelativeDateInputRestriction();
        }

        @Override
        protected InputRestriction<?> createInputRestriction(Element editComponentRoot, DataType dataType) {
            RelativeDateInputRestriction ret = null;
            if (editComponentRoot.getAttribute(InputRestrictionType.ATTR_TYPE).equals("RelativeDate")) {
                ret = new RelativeDateInputRestriction();
            }
            return ret;
        }
    }
    ,
    RELATIVE_TIME{

        @Override
        public InputRestriction<?> createInputRestriction(Object valueObject, DataType dt) {
            return new RelativeTimeInputRestriction();
        }

        @Override
        protected InputRestriction<?> createInputRestriction(Element editComponentRoot, DataType dataType) {
            RelativeTimeInputRestriction ret = null;
            if (editComponentRoot.getAttribute(InputRestrictionType.ATTR_TYPE).equals("RelativeTime")) {
                ret = new RelativeTimeInputRestriction();
            }
            return ret;
        }
    }
    ,
    NO_DATA{

        @Override
        public InputRestriction<?> createInputRestriction(Object valueObject, DataType dt) {
            return new CustomEditorInputRestriction(String.valueOf(valueObject));
        }

        @Override
        protected InputRestriction<?> createInputRestriction(Element editComponentRoot, DataType dataType) {
            CustomEditorInputRestriction ret = null;
            if (editComponentRoot.hasAttribute(InputRestrictionType.ATTR_CLASS)) {
                String className = editComponentRoot.getAttribute(InputRestrictionType.ATTR_CLASS);
                ret = new CustomEditorInputRestriction(className);
            }
            return ret;
        }
    };

    private static final String ATTR_TYPE = "Type";
    private static final String ATTR_CLASS = "class";

    public abstract InputRestriction<?> createInputRestriction(Object var1, DataType var2);

    protected abstract InputRestriction<?> createInputRestriction(Element var1, DataType var2);

    public static InputRestriction<?> createInputRestriction(NodeList childNodes, DataType dataType) {
        Element editComponentRoot = null;
        for (Element child : new ElementIterator(childNodes)) {
            String tagName = child.getTagName();
            if (!"EditComponent".equals(tagName) && !"InputRestriction".equals(tagName)) continue;
            editComponentRoot = child;
            break;
        }
        InputRestriction<?> ret = null;
        if (editComponentRoot != null) {
            InputRestrictionType type;
            InputRestrictionType[] types;
            InputRestrictionType[] inputRestrictionTypeArray = types = InputRestrictionType.values();
            int n = inputRestrictionTypeArray.length;
            for (int i = 0; i < n && (ret = (type = inputRestrictionTypeArray[i]).createInputRestriction(editComponentRoot, dataType)) == null; ++i) {
            }
        }
        return ret;
    }
}

