/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.plugins;

import com.ericsson.ere.gui.editors.serviceeditor.NameRepositories;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.PluginsTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.AbstractPluginTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.AbstractPluginTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.BaseConditionDefinitionNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.FieldStructureBaseConditionDefinitionNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.GenericConditionDefinitionNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.ModifierNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.NodesNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.ServiceDefinitionTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.TariffstructuresNode;
import ericsson.ere.xml.ElementIterator;
import javax.swing.tree.TreePath;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PluginsTreeBuilder {
    private static final String TARIFFSTRUCTURE_PATH_IN_COND = "TariffStructures/TariffStructure";
    private static final String TARIFFSTRUCTURE_PATH_IN_DEF = "Settings/TariffStructures/TariffStructure";
    private static final String NODE_PATH_IN_COND = "Nodes/Node";
    private static final String NODE_PATH_IN_DEF = "Settings/Nodes/Node";
    private static final String BASECONDITION_PATH_IN_COND = "BaseConditions/Condition";
    private static final String BASECONDITION_PATH_IN_DEF = "Settings/BaseConditions/Condition";
    private static final String HIERARCHICALBASECONDITION_PATH_IN_COND = "HierarchicalBaseConditions/Condition";
    private static final String HIERARCHICALBASECONDITION_PATH_IN_DEF = "Settings/HierarchicalBaseConditions/Condition";
    private static final String GENERICCONDITION_PATH_IN_COND = "GenericConditions/Condition";
    private static final String GENERICCONDITION_PATH_IN_DEF = "Settings/GenericConditions/Condition";
    private static final String MODIFIER_PATH_IN_COND = "Modifiers/Modifier";
    private static final String MODIFIER_PATH_IN_DEF = "Settings/Modifiers/Modifier";
    private XPath myXpath = XPathFactory.newInstance().newXPath();
    private Element definitionElement;
    private Element pluginElement;

    public PluginsTreeBuilder(Element definition, Element condition) {
        this.definitionElement = definition;
        this.pluginElement = condition;
    }

    public PluginsTreeModel build(NameRepositories nameRepositories) {
        AbstractPluginTM top = this.createTop();
        PluginsTreeModel model = new PluginsTreeModel(top, nameRepositories);
        BaseConditionDefinitionNode baseConditionDefinitionNode = new BaseConditionDefinitionNode(nameRepositories.getBaseConditionNameRepository());
        FieldStructureBaseConditionDefinitionNode fieldStructureBaseConditionDefinitionNode = new FieldStructureBaseConditionDefinitionNode(nameRepositories.getFieldStructureBaseConditionNameRepository());
        GenericConditionDefinitionNode genericConditionDefinitionNode = new GenericConditionDefinitionNode(nameRepositories.getConditionNameRepository());
        TariffstructuresNode tariffstructuresNode = new TariffstructuresNode(nameRepositories.getStructureNameRepository());
        ModifierNode modifierNode = new ModifierNode(nameRepositories.getModifierNameRepository());
        NodesNode nodesNode = new NodesNode(nameRepositories.getNodeNameRepository());
        TreePath topPath = new TreePath(top);
        model.addNodeAsChild(topPath, tariffstructuresNode);
        model.addNodeAsChild(topPath, nodesNode);
        model.addNodeAsChild(topPath, baseConditionDefinitionNode);
        model.addNodeAsChild(topPath, fieldStructureBaseConditionDefinitionNode);
        model.addNodeAsChild(topPath, genericConditionDefinitionNode);
        model.addNodeAsChild(topPath, modifierNode);
        this.createTariffstructureDefinitions(model, tariffstructuresNode);
        this.createNodesDefinitions(model, nodesNode);
        this.createBaseConditionDefinitions(model, baseConditionDefinitionNode);
        this.createFieldStructureBaseConditionDefinitions(model, fieldStructureBaseConditionDefinitionNode);
        this.createGenericConditionDefinitions(model, genericConditionDefinitionNode);
        this.createModifierDefinitions(model, modifierNode);
        return model;
    }

    private AbstractPluginTM createTop() {
        return new ServiceDefinitionTM(this.definitionElement);
    }

    private void createBaseConditionDefinitions(PluginsTreeModel model, BaseConditionDefinitionNode node) {
        NodeList baseConditions = this.findPlugins(BASECONDITION_PATH_IN_COND, BASECONDITION_PATH_IN_DEF);
        this.createTMDefinitions(model, node, baseConditions);
    }

    private void createFieldStructureBaseConditionDefinitions(PluginsTreeModel model, FieldStructureBaseConditionDefinitionNode node) {
        NodeList fieldStructureBaseConditions = this.findPlugins(HIERARCHICALBASECONDITION_PATH_IN_COND, HIERARCHICALBASECONDITION_PATH_IN_DEF);
        this.createTMDefinitions(model, node, fieldStructureBaseConditions);
    }

    private void createGenericConditionDefinitions(PluginsTreeModel model, GenericConditionDefinitionNode node) {
        NodeList genericConditions = this.findPlugins(GENERICCONDITION_PATH_IN_COND, GENERICCONDITION_PATH_IN_DEF);
        this.createTMDefinitions(model, node, genericConditions);
    }

    private void createTariffstructureDefinitions(PluginsTreeModel model, TariffstructuresNode node) {
        NodeList tariffStructures = this.findPlugins(TARIFFSTRUCTURE_PATH_IN_COND, TARIFFSTRUCTURE_PATH_IN_DEF);
        this.createTMDefinitions(model, node, tariffStructures);
    }

    private void createNodesDefinitions(PluginsTreeModel model, NodesNode node) {
        NodeList nodes = this.findPlugins(NODE_PATH_IN_COND, NODE_PATH_IN_DEF);
        this.createTMDefinitions(model, node, nodes);
    }

    private void createModifierDefinitions(PluginsTreeModel model, ModifierNode node) {
        NodeList modifiers = this.findPlugins(MODIFIER_PATH_IN_COND, MODIFIER_PATH_IN_DEF);
        this.createTMDefinitions(model, node, modifiers);
    }

    private void createTMDefinitions(PluginsTreeModel model, AbstractPluginTreeNode parentNode, NodeList elements) {
        TreePath parentPath = new TreePath(parentNode.getPath());
        ElementIterator iterator = new ElementIterator(elements);
        for (Element element : iterator) {
            AbstractPluginTM tmNode = parentNode.createChildNode(element);
            model.addNodeAsChild(parentPath, tmNode);
        }
    }

    private NodeList findPlugins(String settingsExpr, String definitionExpr) {
        NodeList plugins;
        try {
            plugins = this.pluginElement != null ? (NodeList)this.myXpath.evaluate(settingsExpr, this.pluginElement, XPathConstants.NODESET) : (NodeList)this.myXpath.evaluate(definitionExpr, this.definitionElement, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new AssertionError((Object)e);
        }
        return plugins;
    }
}

