/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.settingseditor;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.StatusPanel;
import ericsson.ere.gui.log.LogConfig;
import ericsson.ere.gui.log.LogHandler;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.documents.NumbersOnlyDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class SettingsHandler
implements ActionListener {
    public static final String LOGGER_SETTINGS_NAME = "Log Settings";
    public static final String[] SETTINGS_IDETIFIER_ARRAY = new String[]{"Settings", "General", "ERE Navigator", "Log Settings", "Selection Tree Editor"};
    private static final String[] PERIOD_SORTING_TITLES = new String[]{"Name sorting", "Date sorting"};
    private static final String[] ON_OFF_BUTTON_TITLES = new String[]{"On", "Off"};
    private JPanel[] mySettingsPanels = new JPanel[SETTINGS_IDETIFIER_ARRAY.length];
    private ButtonGroup mySoundOnOffGroup = new ButtonGroup();
    private ButtonGroup myMemOnOffGroup = new ButtonGroup();
    private ButtonGroup myPeriodSortingGroup = new ButtonGroup();
    private ButtonGroup myRatingPeriodOnOffGroup = new ButtonGroup();
    private ButtonGroup myUseLocalClipboardOnOffGroup = new ButtonGroup();
    private ButtonGroup myUseOptimizedStepTraceGroup = new ButtonGroup();
    private ButtonGroup myConfirmSelectionTreeDragAndDropGroup = new ButtonGroup();
    private boolean mySoundOn;
    private boolean myMemOn;
    private int myPeriodSorting;
    private boolean myCurrentRatingPeriodOn;
    private boolean myUseLocalClipboard;
    private boolean myUseOptimizedStepTrace;
    private boolean myConfirmSelectionTreeDragAndDrop;
    private JTextField myTxtFilename;
    private JPanel myLogSettingPanel;
    private JButton mySelectLogFile;
    private JCheckBox myUseLogFile;
    private JTextField myTxtMaxEntries;
    private JRadioButton myFileTypePlain;
    private JRadioButton myFileTypeXML;
    private JComboBox myLogSeverity;

    public SettingsHandler() {
        this.readConfig();
        this.mySettingsPanels[0] = new JPanel();
        this.mySettingsPanels[1] = this.createGeneralPanel();
        this.mySettingsPanels[2] = this.createTreeEditorPanel();
        this.mySettingsPanels[3] = this.createLoggerSettingsPanel();
        this.mySettingsPanels[4] = this.createSelectionTreeEditorPanel();
    }

    public JPanel getSettingsPanel(int panelIdentifier) {
        if (panelIdentifier < this.mySettingsPanels.length) {
            return this.mySettingsPanels[panelIdentifier];
        }
        return new JPanel();
    }

    public JPanel[] getSettingsPanels() {
        return this.mySettingsPanels;
    }

    public static String[] getSettingsArray() {
        return SETTINGS_IDETIFIER_ARRAY;
    }

    private JPanel createGeneralPanel() {
        JPanel generalPanel = new JPanel(new GridBagLayout());
        String soundSelection = this.mySoundOn ? ON_OFF_BUTTON_TITLES[0] : ON_OFF_BUTTON_TITLES[1];
        JPanel soundPanel = this.createBorderedButtonGroup("Sound", ON_OFF_BUTTON_TITLES, soundSelection, this.mySoundOnOffGroup);
        soundPanel.setName("SettingsWindow.JPanel.Sound");
        generalPanel.add((Component)soundPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 11, 2, new Insets(4, 4, 0, 4), 0, 0));
        String memorySelection = this.myMemOn ? ON_OFF_BUTTON_TITLES[0] : ON_OFF_BUTTON_TITLES[1];
        JPanel memoryPanel = this.createBorderedButtonGroup("Show Memory Usage", ON_OFF_BUTTON_TITLES, memorySelection, this.myMemOnOffGroup);
        memoryPanel.setName("SettingsWindow.JPanel.Memory");
        generalPanel.add((Component)memoryPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 11, 2, new Insets(4, 4, 0, 4), 0, 0));
        generalPanel.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        return generalPanel;
    }

    private JPanel createTreeEditorPanel() {
        JPanel treeEditorPanel = new JPanel(new GridBagLayout());
        String sortingSelection = this.myPeriodSorting == 0 ? PERIOD_SORTING_TITLES[0] : PERIOD_SORTING_TITLES[1];
        JPanel sortingPanel = this.createBorderedButtonGroup("Period sorting", PERIOD_SORTING_TITLES, sortingSelection, this.myPeriodSortingGroup);
        treeEditorPanel.add((Component)sortingPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 11, 2, new Insets(4, 4, 0, 4), 0, 0));
        String highlightSelection = this.myCurrentRatingPeriodOn ? ON_OFF_BUTTON_TITLES[0] : ON_OFF_BUTTON_TITLES[1];
        JPanel currentRatingPeriodPanel = this.createBorderedButtonGroup("Highlight current rating period", ON_OFF_BUTTON_TITLES, highlightSelection, this.myRatingPeriodOnOffGroup);
        treeEditorPanel.add((Component)currentRatingPeriodPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 11, 2, new Insets(4, 4, 0, 4), 0, 0));
        treeEditorPanel.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        return treeEditorPanel;
    }

    private JPanel createSelectionTreeEditorPanel() {
        JPanel newPanel = new JPanel(new GridBagLayout());
        String useLocalClipboardSelection = this.myUseLocalClipboard ? ON_OFF_BUTTON_TITLES[0] : ON_OFF_BUTTON_TITLES[1];
        JPanel localClipboardPanel = this.createBorderedButtonGroup("Use local clipboard", ON_OFF_BUTTON_TITLES, useLocalClipboardSelection, this.myUseLocalClipboardOnOffGroup);
        newPanel.add((Component)localClipboardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 11, 2, new Insets(4, 4, 0, 4), 0, 0));
        String useOptimizedStepTrace = this.myUseOptimizedStepTrace ? ON_OFF_BUTTON_TITLES[0] : ON_OFF_BUTTON_TITLES[1];
        JPanel optimizeStepTracePanel = this.createBorderedButtonGroup("Show only executed branches in step trace", ON_OFF_BUTTON_TITLES, useOptimizedStepTrace, this.myUseOptimizedStepTraceGroup);
        newPanel.add((Component)optimizeStepTracePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 11, 2, new Insets(4, 4, 0, 4), 0, 0));
        String confirmSelectionTreeDragAndDropSelection = this.myConfirmSelectionTreeDragAndDrop ? ON_OFF_BUTTON_TITLES[0] : ON_OFF_BUTTON_TITLES[1];
        JPanel dragAndDropPanel = this.createBorderedButtonGroup("Confirm Drag&Drop on move", ON_OFF_BUTTON_TITLES, confirmSelectionTreeDragAndDropSelection, this.myConfirmSelectionTreeDragAndDropGroup);
        newPanel.add((Component)dragAndDropPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.1, 11, 2, new Insets(4, 4, 0, 4), 0, 0));
        newPanel.add((Component)new JPanel(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        return newPanel;
    }

    private JPanel createBorderedButtonGroup(String borderTitle, String[] buttonTitles, String selected, ButtonGroup buttonGroup) {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(new TitledBorder(borderTitle));
        for (int buttonPos = 0; buttonPos < buttonTitles.length; ++buttonPos) {
            JRadioButton button = new JRadioButton(buttonTitles[buttonPos]);
            buttonGroup.add(button);
            buttonPanel.add((Component)button, new GridBagConstraints(0, buttonPos, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            button.setSelected(buttonTitles[buttonPos].equals(selected));
        }
        return buttonPanel;
    }

    private JPanel createLoggerSettingsPanel() {
        this.myLogSettingPanel = new JPanel(new GridBagLayout());
        this.myTxtMaxEntries = new JTextField();
        this.myTxtMaxEntries.setDocument(new NumbersOnlyDocument(0L, 300L));
        this.myTxtMaxEntries.setColumns(10);
        this.myTxtMaxEntries.setHorizontalAlignment(2);
        this.myTxtMaxEntries.setName("SettingWindow.JTextField.MaxEntries");
        JLabel jlblMaxLimit = new JLabel("Max entries:");
        jlblMaxLimit.setPreferredSize(new Dimension(90, 21));
        JPanel logPanel = new JPanel(new GridBagLayout());
        logPanel.setBorder(new TitledBorder("Log"));
        logPanel.add((Component)jlblMaxLimit, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 12, 12, 0), 0, 0));
        logPanel.add((Component)this.myTxtMaxEntries, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 12, 6, 12), 0, 0));
        Level[] levels = new Level[]{Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
        this.myLogSeverity = new JComboBox<Level>(levels);
        this.myLogSeverity.setName("SettingWindow.JComboBox.LogLevelCombo");
        JLabel logSeverityLabel = new JLabel("Minimum log level:");
        logPanel.add((Component)logSeverityLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 12, 0), 0, 0));
        logPanel.add((Component)this.myLogSeverity, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 12, 12, 12), 0, 0));
        this.myLogSettingPanel.add((Component)logPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 11, 2, new Insets(4, 4, 0, 4), 0, 0));
        JPanel jpnlLogFile = new JPanel(new GridBagLayout());
        jpnlLogFile.setBorder(new TitledBorder("Log File"));
        this.myUseLogFile = new JCheckBox("Use Persistent Log File");
        this.myUseLogFile.setName("SettingWindow.JCheckBox.LogFile");
        this.myUseLogFile.addActionListener(this);
        JLabel jlblFilename = new JLabel("Filename:");
        jlblFilename.setPreferredSize(new Dimension(78, 21));
        this.myTxtFilename = new JTextField(15);
        this.myTxtFilename.setName("SettingWindow.JTextField.Filename");
        this.myTxtFilename.setEditable(false);
        this.mySelectLogFile = new JButton("...");
        this.mySelectLogFile.setName("SettingWindow.JButton.FileBrowseButton");
        this.mySelectLogFile.setPreferredSize(new Dimension(19, 19));
        this.mySelectLogFile.setMaximumSize(new Dimension(19, 19));
        this.mySelectLogFile.addActionListener(this);
        this.myFileTypeXML = new JRadioButton("XML");
        this.myFileTypeXML.setName("SettingWindow.JRadioButton.FileTypeXML");
        this.myFileTypePlain = new JRadioButton("Plain");
        this.myFileTypePlain.setName("SettingWindow.JRadioButton.FileTypePlain");
        ButtonGroup btngrpFileOutputType = new ButtonGroup();
        btngrpFileOutputType.add(this.myFileTypeXML);
        btngrpFileOutputType.add(this.myFileTypePlain);
        JLabel jlblOutput = new JLabel("Output:");
        jpnlLogFile.add((Component)this.myUseLogFile, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(12, 0, 0, 12), 0, 0));
        jpnlLogFile.add((Component)jlblFilename, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(11, 12, 0, 12), 0, 0));
        jpnlLogFile.add((Component)this.myTxtFilename, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(11, 4, 0, 0), 0, 0));
        jpnlLogFile.add((Component)this.mySelectLogFile, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 12), 0, 0));
        jpnlLogFile.add((Component)jlblOutput, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(11, 12, 0, 12), 0, 0));
        jpnlLogFile.add((Component)this.myFileTypeXML, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(11, 0, 0, 12), 0, 0));
        jpnlLogFile.add((Component)this.myFileTypePlain, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 0, 12, 12), 0, 0));
        this.myLogSettingPanel.add((Component)jpnlLogFile, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 11, 2, new Insets(4, 4, 0, 4), 0, 0));
        this.myLogSettingPanel.add((Component)new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.readLogConfig();
        return this.myLogSettingPanel;
    }

    private void readConfig() {
        RmaDefs rmaDefs = RmaDefs.getInstance();
        this.mySoundOn = rmaDefs.getSoundSetting();
        this.myMemOn = rmaDefs.shouldMemoryStatusBeVisible();
        this.updateMemoryStatus();
        this.myPeriodSorting = rmaDefs.getPeriodSortingSetting();
        this.myCurrentRatingPeriodOn = rmaDefs.getHighlightCurrentRatingPeriodSetting();
        this.myUseLocalClipboard = rmaDefs.getUseLocalClipboardSetting();
        this.myUseOptimizedStepTrace = rmaDefs.getUseOptimizedStepTrace();
        this.myConfirmSelectionTreeDragAndDrop = rmaDefs.getConfirmSelectionTreeDragAndDropSetting();
    }

    public void saveConfig() {
        RmaDefs rmaDefs = RmaDefs.getInstance();
        this.mySoundOn = this.mySoundOnOffGroup.getElements().nextElement().isSelected();
        rmaDefs.setSoundSetting(this.mySoundOn);
        this.myMemOn = this.myMemOnOffGroup.getElements().nextElement().isSelected();
        rmaDefs.setMemorySetting(this.myMemOn);
        this.myPeriodSorting = this.myPeriodSortingGroup.getElements().nextElement().isSelected() ? 0 : 1;
        rmaDefs.setPeriodSortingSetting(this.myPeriodSorting);
        this.myCurrentRatingPeriodOn = this.myRatingPeriodOnOffGroup.getElements().nextElement().isSelected();
        rmaDefs.setHighlightCurrentRatingPeriodSetting(this.myCurrentRatingPeriodOn);
        this.myUseLocalClipboard = this.myUseLocalClipboardOnOffGroup.getElements().nextElement().isSelected();
        rmaDefs.setLocalUseClipboardSetting(this.myUseLocalClipboard);
        this.myUseOptimizedStepTrace = this.myUseOptimizedStepTraceGroup.getElements().nextElement().isSelected();
        rmaDefs.setUseOptimizedStepTrace(this.myUseOptimizedStepTrace);
        this.myConfirmSelectionTreeDragAndDrop = this.myConfirmSelectionTreeDragAndDropGroup.getElements().nextElement().isSelected();
        rmaDefs.setConfirmSelectionTreeDragAndDropSetting(this.myConfirmSelectionTreeDragAndDrop);
        this.updateMemoryStatus();
        this.updateLogConfig();
        rmaDefs.commitChanges();
    }

    private void updateMemoryStatus() {
        if (RmaDefs.getInstance().shouldMemoryStatusBeVisible()) {
            StatusPanel.getInstance().showMemoryStatus();
        } else {
            StatusPanel.getInstance().hideMemoryStatus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mySelectLogFile) {
            this.showFileDialog();
        } else if (e.getSource() == this.myUseLogFile) {
            boolean selected = this.myUseLogFile.isSelected();
            this.mySelectLogFile.setEnabled(selected);
            this.myTxtFilename.setEnabled(selected);
            this.myFileTypeXML.setEnabled(selected);
            this.myFileTypePlain.setEnabled(selected);
        }
    }

    private void showFileDialog() {
        JFileChooser fileChooser = GuiServiceCenter.getInstance().getFileChooser();
        fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
        fileChooser.setDialogTitle("Select");
        if (!StringUtil.isEmptyString(this.myTxtFilename.getText())) {
            fileChooser.setSelectedFile(new File(this.myTxtFilename.getText()));
        }
        if (fileChooser.showOpenDialog(this.myLogSettingPanel) == 0) {
            this.myTxtFilename.setText(fileChooser.getSelectedFile().getPath());
        }
    }

    private void updateLogConfig() {
        Properties prop = RmaDefs.getInstance().properties;
        try {
            int maxEntries = Integer.parseInt(this.myTxtMaxEntries.getText());
            if (maxEntries >= 0) {
                prop.setProperty(RmaDefs.PROP_LOG_MAX_ENTRIES, "" + maxEntries);
                RmaDefs.loggerRatingManager.config("Max entries in log window: " + maxEntries);
            }
        }
        catch (NumberFormatException maxEntries) {
            // empty catch block
        }
        String fileFormat = this.myFileTypeXML.isSelected() ? "XML" : "Plain";
        String fileText = this.myTxtFilename.getText();
        boolean usePersistentFile = StringUtil.isEmptyString(fileText) ? false : this.myUseLogFile.isSelected();
        prop.setProperty(RmaDefs.PROP_LOG_FILENAME, fileText);
        prop.setProperty(RmaDefs.PROP_LOG_USE_FILE, "" + usePersistentFile);
        prop.setProperty(RmaDefs.PROP_LOG_FILE_FORMAT, fileFormat);
        String logLevel = this.myLogSeverity.getSelectedItem().toString();
        prop.setProperty(RmaDefs.PROP_LOG_LEVEL, logLevel);
        RmaDefs.loggerRatingManager.config("Log level threshold: " + logLevel);
        RmaDefs.loggerRatingManager.config("Logging to persistent file: " + usePersistentFile);
        if (usePersistentFile) {
            RmaDefs.loggerRatingManager.config("Log filename: " + fileText);
            RmaDefs.loggerRatingManager.config("Log file format: " + fileFormat);
        }
        LogHandler handler = LogConfig.getInstance().getHandler();
        Level level = (Level)this.myLogSeverity.getSelectedItem();
        handler.setLevel(level);
        handler.reRegisterLevel(level);
    }

    private void readLogConfig() {
        Properties prop = RmaDefs.getInstance().properties;
        String logFile = prop.getProperty(RmaDefs.PROP_LOG_FILENAME, "");
        this.myTxtFilename.setText(logFile);
        boolean useLogFile = Boolean.parseBoolean(prop.getProperty(RmaDefs.PROP_LOG_USE_FILE)) && !StringUtil.isEmptyString(logFile);
        this.myUseLogFile.setSelected(useLogFile);
        this.mySelectLogFile.setEnabled(useLogFile);
        this.myTxtFilename.setEnabled(useLogFile);
        this.myFileTypeXML.setEnabled(useLogFile);
        this.myFileTypePlain.setEnabled(useLogFile);
        this.myTxtMaxEntries.setText(prop.getProperty(RmaDefs.PROP_LOG_MAX_ENTRIES, "300"));
        String fileFormat = prop.getProperty(RmaDefs.PROP_LOG_FILE_FORMAT, "Plain");
        if (fileFormat.equalsIgnoreCase("XML")) {
            this.myFileTypeXML.setSelected(true);
        } else {
            this.myFileTypePlain.setSelected(true);
        }
        String logLevel = prop.getProperty(RmaDefs.PROP_LOG_LEVEL, LogConfig.DEFAULT_LEVEL.toString());
        this.myLogSeverity.setSelectedItem(Level.parse(logLevel));
    }
}

