/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.gui.multiupdate.MultiDataUpdateFindCriteria;
import com.ericsson.ere.gui.multiupdate.presenter.MultiDataUpdateFindPresenter;
import com.ericsson.ere.gui.multiupdate.view.MultiDataUpdateFindView;
import com.ericsson.ere.swing.EventSource;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.AdvancedSearchPanel;
import ericsson.ere.gui.util.FileFilterImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class MultiDataUpdateFindPanel
extends JPanel
implements MultiDataUpdateFindView {
    private AdvancedSearchPanel myFindPanel;
    private EventSource myFindEvent = new EventSource();
    private JRadioButton myShowAllBtn;
    private JRadioButton myFilterBtn;
    private JRadioButton myBrowseForFileBtn;
    private JTextField myFilterField;
    private JTextField myFileField;
    private JComboBox myFilterFieldType;
    private JButton myBrowseButton;
    private File mySelectedFile = null;
    private JComboBox myShowAllType;
    private JCheckBox myAlsoImportContent;

    public MultiDataUpdateFindPanel() {
        super(new GridBagLayout());
        this.setBorder(new TitledBorder(" Find selection tree elements: "));
        this.myShowAllType = new JComboBox<MultiDataUpdateFindCriteria>(MultiDataUpdateFindCriteria.values());
        this.myShowAllType.setName("MultiDataUpdateFindPanel.JComboBox.ShowAllCombo");
        this.myFilterField = new JTextField();
        this.myFilterField.setName("MultiDataUpdateFindPanel.JTextField.FilterField");
        this.myFilterField.setPreferredSize(new Dimension(80, 25));
        this.myFilterFieldType = new JComboBox<MultiDataUpdateFindCriteria>(MultiDataUpdateFindCriteria.values());
        this.myFilterFieldType.setName("MultiDataUpdateFindPanel.JComboBox.FilterComboBox");
        this.myFileField = new JTextField();
        this.myFileField.setName("MultiDataUpdateFindPanel.JTextField.FileField");
        this.myFileField.setPreferredSize(new Dimension(80, 26));
        this.myBrowseButton = new JButton("Browse");
        this.myBrowseButton.setName("MultiDataUpdateFindPanel.JButton.BrowseBtn");
        this.myBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileFilter(new FileFilterImpl("csv", "Comma Separated Values Files"));
                fileChooser.setAcceptAllFileFilterUsed(false);
                fileChooser.setDialogTitle("Select file to import");
                int i = fileChooser.showOpenDialog(MultiDataUpdateFindPanel.this);
                if (i == 0) {
                    MultiDataUpdateFindPanel.this.mySelectedFile = fileChooser.getSelectedFile();
                    MultiDataUpdateFindPanel.this.myFileField.setText(MultiDataUpdateFindPanel.this.mySelectedFile.getAbsolutePath());
                }
            }
        });
        this.myBrowseButton.setPreferredSize(new Dimension(85, 25));
        this.myAlsoImportContent = new JCheckBox("Import data found in file");
        this.myAlsoImportContent.setName("MultiDataUpdateFindPanel.JCheckBox.AlsoImportCheckBox");
        this.defineRadioButtons();
        this.enableShowAll();
        JButton findButton = this.myFindEvent.createButton("Show", RmaDefs.getImageIcon("find.png"));
        findButton.setName("MultiDataUpdateFindPanel.JButton.Show");
        this.add((Component)this.myShowAllBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 5, 5), 0, 0));
        this.add((Component)this.myShowAllType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 5, 3), 0, 0));
        this.add((Component)this.myFilterBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.myFilterField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 5, 3), 0, 0));
        this.add((Component)this.myFilterFieldType, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.myBrowseForFileBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.myFileField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 3, 3), 0, 0));
        this.add((Component)this.myBrowseButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 3, 5), 0, 0));
        this.add((Component)this.myAlsoImportContent, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)findButton, new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
    }

    private void defineRadioButtons() {
        this.myShowAllBtn = new JRadioButton("By");
        this.myShowAllBtn.setName("MultiDataUpdateFindPanel.JRadioButton.ByBtn");
        this.myShowAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDataUpdateFindPanel.this.enableShowAll();
            }
        });
        this.myFilterBtn = new JRadioButton("By expression");
        this.myFilterBtn.setName("MultiDataUpdateFindPanel.JRadioButton.FilterBtn");
        this.myFilterBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDataUpdateFindPanel.this.enableSelectByFilter();
            }
        });
        this.myBrowseForFileBtn = new JRadioButton("By file");
        this.myBrowseForFileBtn.setName("MultiDataUpdateFindPanel.JRadioButton.BrowseBtn");
        this.myBrowseForFileBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDataUpdateFindPanel.this.enableSelectByFile();
            }
        });
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.myShowAllBtn);
        btnGroup.add(this.myFilterBtn);
        btnGroup.add(this.myBrowseForFileBtn);
    }

    private void enableShowAll(boolean enable) {
        this.myShowAllType.setEnabled(enable);
    }

    private void enableFilter(boolean enable) {
        this.myFilterField.setEnabled(enable);
        this.myFilterField.requestFocus();
        this.myFilterFieldType.setEnabled(enable);
    }

    private void enableBrowseFile(boolean enable) {
        this.myFileField.setEnabled(enable);
        this.myBrowseButton.setEnabled(enable);
        this.myAlsoImportContent.setEnabled(enable);
    }

    JPanel getFilterPanel() {
        return this.myFindPanel;
    }

    @Override
    public EventSource extractElements() {
        return this.myFindEvent;
    }

    @Override
    public String getCriteriaString() {
        return this.myFilterField.getText();
    }

    @Override
    public File getCriterionBaseFileIfSelected() {
        return this.myBrowseForFileBtn.isSelected() ? this.mySelectedFile : null;
    }

    @Override
    public boolean isImportDataFromFileSelected() {
        return this.myAlsoImportContent.isSelected();
    }

    @Override
    public void clearFilter() {
        this.myFilterField.setText("");
        this.myFileField.setText("");
        this.mySelectedFile = null;
        this.myAlsoImportContent.setSelected(false);
        this.enableShowAll();
    }

    private void enableShowAll() {
        this.myShowAllBtn.setSelected(true);
        this.enableShowAll(true);
        this.enableBrowseFile(false);
        this.enableFilter(false);
    }

    private void enableSelectByFilter() {
        this.enableShowAll(false);
        this.enableFilter(true);
        this.enableBrowseFile(false);
    }

    private void enableSelectByFile() {
        this.enableShowAll(false);
        this.enableFilter(false);
        this.enableBrowseFile(true);
    }

    @Override
    public MultiDataUpdateFindPresenter.MDUFindFilterType getSelectedFilterType() {
        MultiDataUpdateFindPresenter.MDUFindFilterType type;
        if (this.myShowAllBtn.isSelected()) {
            type = this.myShowAllType.getSelectedItem() == MultiDataUpdateFindCriteria.PATH_BASED ? MultiDataUpdateFindPresenter.MDUFindFilterType.ALL_BASED_ON_PATH : MultiDataUpdateFindPresenter.MDUFindFilterType.ALL_BASED_ON_TAG;
        } else if (this.myFilterBtn.isSelected()) {
            type = this.myFilterFieldType.getSelectedItem() == MultiDataUpdateFindCriteria.PATH_BASED ? MultiDataUpdateFindPresenter.MDUFindFilterType.SPECIFIC_PATHS : MultiDataUpdateFindPresenter.MDUFindFilterType.SPECIFIC_TAGS;
        } else if (this.myBrowseForFileBtn.isSelected()) {
            type = MultiDataUpdateFindPresenter.MDUFindFilterType.BASED_ON_FILE;
        } else {
            throw new IllegalArgumentException("No filter type selected while searching, Multi Data Update tool in illegal state.");
        }
        return type;
    }
}

