/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.gui.multiupdate.MultiDataUpdateTable;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateTableModel;
import com.ericsson.ere.gui.multiupdate.view.MultiDataUpdateModificationView;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.swing.EventSource;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.FileFilterImpl;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.progress.ProgressIndicator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.undo.UndoManager;

public class MultiDataUpdateModificationPanel
extends JPanel
implements MultiDataUpdateModificationView,
TableModelListener {
    private JTabbedPane myTabs;
    private EventSource myImportEvent = new EventSource();
    private EventSource myExportEvent = new EventSource();
    private EventSource mySaveEvent = new EventSource();
    private EventSource mySaveAsEvent = new EventSource();
    private EventSource myDiscardEvent = new EventSource();
    private ActionListener myCopyPasteListener = null;
    private JButton mySaveButton;
    private JButton mySaveAsButton;
    private Map<String, MultiDataUpdateTableModel> myUsedModels;
    private Map<String, JTable> myUsedEditTables;
    private JButton myDiscardButton;
    private static Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final String RESULT_AREA_START_STRING = "No results.";
    private static final String IMPORT_DIALOG_TITLE = "Select file to import";
    private static final String EXPORT_DIALOG_TITLE = "Select file to export";
    private JButton myImportButton;
    private JButton myExportButton;
    private UndoManager myUndoManager;

    public MultiDataUpdateModificationPanel() {
        this.setLayout(new GridBagLayout());
        this.init();
    }

    private void init() {
        this.myUndoManager = new UndoManager();
        this.myUsedModels = new HashMap<String, MultiDataUpdateTableModel>();
        this.myUsedEditTables = new HashMap<String, JTable>();
        this.myTabs = new JTabbedPane();
        this.myTabs.setName("MultiDataUpdateModificationPanel.JTabbedPane.Result");
        this.addEmptyTab(RESULT_AREA_START_STRING);
        this.specifyButtons();
        this.add((Component)this.myTabs, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.7, 11, 1, EMPTY_INSETS, 0, 0));
    }

    private void specifyButtons() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        this.myImportButton = this.myImportEvent.createButton("Import", RmaDefs.getImageIcon("import1_16.png"), "Import configuration from file.");
        this.myImportButton.setName("MultiDataUpdateModification.JButton.Import");
        this.myExportButton = this.myExportEvent.createButton("Export", RmaDefs.getImageIcon("export1_16.png"), "Export configuration to file.");
        this.myExportButton.setName("MultiDataUpdateModification.JButton.Export");
        this.mySaveButton = this.mySaveEvent.createButton("Save", RmaDefs.getImageIcon("disk_blue16.png"), "Save changes to the selection tree.");
        this.mySaveButton.setName("MultiDataUpdateModification.JButton.Save");
        this.mySaveAsButton = this.mySaveAsEvent.createButton("Save As", RmaDefs.getImageIcon("save_as16.png"), "Save changes as a new selection tree.");
        this.mySaveAsButton.setName("MultiDataUpdateModification.JButton.SaveAs");
        this.myDiscardButton = this.myDiscardEvent.createButton("Discard", RmaDefs.getImageIcon("garbage.png"), "Discards all changes and clears the filter and result view.");
        this.myDiscardButton.setName("MultiDataUpdateModification.JButton.Discard");
        this.enableMyButtons(false);
        buttonPanel.add((Component)this.myImportButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        buttonPanel.add((Component)this.myExportButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        buttonPanel.add((Component)this.mySaveButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        buttonPanel.add((Component)this.mySaveAsButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        buttonPanel.add((Component)this.myDiscardButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, EMPTY_INSETS, 0, 0));
    }

    private JComponent specifyTableForTab(TableModel tableModel, String tabName) {
        JPanel contentPanel = new JPanel(new GridBagLayout());
        final MultiDataUpdateTable table = new MultiDataUpdateTable(tableModel);
        table.setName("MultiDataUpdateModification.JTable." + tabName);
        table.setFocusable(true);
        table.registerKeyboardAction(this.myCopyPasteListener, "Copy", KeyStroke.getKeyStroke(67, 128, false), 0);
        table.registerKeyboardAction(this.myCopyPasteListener, "Paste", KeyStroke.getKeyStroke(86, 128, false), 0);
        table.registerKeyboardAction(new UndoAction(), "Undo", KeyStroke.getKeyStroke(90, 128, false), 0);
        table.registerKeyboardAction(new RedoAction(), "Redo", KeyStroke.getKeyStroke(89, 128, false), 0);
        this.myUsedEditTables.put(tabName, table);
        JScrollPane tableScroller = new JScrollPane(table);
        tableScroller.setHorizontalScrollBarPolicy(30);
        tableScroller.setVerticalScrollBarPolicy(20);
        tableScroller.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                table.requestFocusInWindow();
                if (table.isEditing()) {
                    table.getCellEditor().stopCellEditing();
                }
                e.consume();
            }
        });
        contentPanel.add((Component)table.getTableHeader(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, EMPTY_INSETS, 0, 0));
        contentPanel.add((Component)tableScroller, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, EMPTY_INSETS, 0, 0));
        return tableScroller;
    }

    @Override
    public EventSource saveDataEvent() {
        return this.mySaveEvent;
    }

    @Override
    public EventSource saveDataAsEvent() {
        return this.mySaveAsEvent;
    }

    @Override
    public EventSource exportDataToFileEvent() {
        return this.myExportEvent;
    }

    @Override
    public EventSource importDataFromFileEvent() {
        return this.myImportEvent;
    }

    @Override
    public void updateModel(final Map<String, MultiDataUpdateTableModel> map) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                MultiDataUpdateModificationPanel.this.myTabs.removeAll();
                MultiDataUpdateModificationPanel.this.removeListenersForModels();
                MultiDataUpdateModificationPanel.this.myUsedModels.clear();
                MultiDataUpdateModificationPanel.this.myUsedEditTables.clear();
                Set keys = map.keySet();
                if (keys.isEmpty()) {
                    MultiDataUpdateModificationPanel.this.addEmptyTab("No matching elements found");
                    MultiDataUpdateModificationPanel.this.enableMyButtons(false);
                } else {
                    ArrayList lkeys = new ArrayList(keys);
                    Collections.sort(lkeys, String.CASE_INSENSITIVE_ORDER);
                    for (String key : lkeys) {
                        MultiDataUpdateTableModel model = (MultiDataUpdateTableModel)map.get(key);
                        MultiDataUpdateModificationPanel.this.myTabs.addTab(key, MultiDataUpdateModificationPanel.this.specifyTableForTab(model, key));
                        MultiDataUpdateModificationPanel.this.myUsedModels.put(key, model);
                        model.addTableModelListener(MultiDataUpdateModificationPanel.this);
                        model.addUndoableEditListener(MultiDataUpdateModificationPanel.this.myUndoManager);
                    }
                    MultiDataUpdateModificationPanel.this.enableSave(false);
                    MultiDataUpdateModificationPanel.this.enableDiscard(true);
                    MultiDataUpdateModificationPanel.this.enableExport(true);
                    MultiDataUpdateModificationPanel.this.enableImport(true);
                }
            }
        });
    }

    private void removeListenersForModels() {
        for (MultiDataUpdateTableModel model : this.myUsedModels.values()) {
            model.removeTableModelListener(this);
            model.removeUndoableEditListener(this.myUndoManager);
        }
    }

    private void enableSave(boolean enabled) {
        this.mySaveAsButton.setEnabled(enabled);
        this.mySaveButton.setEnabled(enabled);
    }

    private void enableDiscard(boolean enabled) {
        this.myDiscardButton.setEnabled(enabled);
    }

    private void enableImport(boolean enabled) {
        this.myImportButton.setEnabled(enabled);
    }

    private void enableExport(boolean enabled) {
        this.myExportButton.setEnabled(enabled);
    }

    private void enableMyButtons(boolean enabled) {
        this.enableSave(enabled);
        this.enableDiscard(enabled);
        this.enableImport(enabled);
        this.enableExport(enabled);
    }

    private void addEmptyTab(String label) {
        JLabel infoLabel = new JLabel(label);
        JPanel infoPanel = new JPanel(new GridBagLayout());
        infoPanel.setPreferredSize(this.myTabs.getPreferredSize());
        infoPanel.add((Component)infoLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myTabs.addTab("Result", infoPanel);
    }

    @Override
    public String getActiveTabTitle() {
        return this.myTabs.getTitleAt(this.myTabs.getSelectedIndex());
    }

    @Override
    public EventSource discardDataEvent() {
        return this.myDiscardEvent;
    }

    @Override
    public void clearResults() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                MultiDataUpdateModificationPanel.this.myTabs.removeAll();
                MultiDataUpdateModificationPanel.this.removeListenersForModels();
                MultiDataUpdateModificationPanel.this.myUsedModels.clear();
                MultiDataUpdateModificationPanel.this.addEmptyTab(MultiDataUpdateModificationPanel.RESULT_AREA_START_STRING);
                MultiDataUpdateModificationPanel.this.enableMyButtons(false);
            }
        });
    }

    @Override
    public Map<String, MultiDataUpdateTableModel> getUsedModels() {
        return this.myUsedModels;
    }

    @Override
    public boolean finishEditing() {
        boolean save = EDT.runAndWait(new EDT.ValueRunnable<Boolean>(){

            @Override
            public Boolean run() {
                boolean readyForSave = true;
                for (JTable table : MultiDataUpdateModificationPanel.this.myUsedEditTables.values()) {
                    if (!table.isEditing()) {
                        readyForSave &= true;
                        continue;
                    }
                    if (table.getCellEditor() != null) {
                        readyForSave &= table.getCellEditor().stopCellEditing();
                        continue;
                    }
                    readyForSave = false;
                }
                return readyForSave;
            }
        });
        return save;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == -1) {
            this.enableSave(false);
            this.enableDiscard(true);
            this.enableImport(true);
            this.enableExport(true);
        } else {
            this.enableMyButtons(true);
            this.showTableChange(e);
        }
    }

    private void showTableChange(TableModelEvent e) {
        TableModel model = (TableModel)e.getSource();
        JTable table = null;
        int tabIndex = -1;
        for (Map.Entry<String, MultiDataUpdateTableModel> entry : this.myUsedModels.entrySet()) {
            int i;
            if (entry.getValue() != model || (i = this.indexOfTab(this.myTabs, entry.getKey())) < 0) continue;
            tabIndex = i;
            table = this.myUsedEditTables.get(entry.getKey());
            break;
        }
        if (table != null && !table.isEditing()) {
            this.myTabs.setSelectedIndex(tabIndex);
            int row = e.getFirstRow();
            int col = e.getColumn();
            if (row >= 0 && col >= 0) {
                table.scrollRectToVisible(table.getCellRect(row, col, true));
            }
        }
    }

    private int indexOfTab(JTabbedPane tabs, String key) {
        int idx = -1;
        int tc = tabs.getTabCount();
        for (int i = 0; idx < 0 && i < tc; ++i) {
            if (!key.equals(tabs.getTitleAt(i))) continue;
            idx = i;
        }
        return idx;
    }

    @Override
    public void setCopyPasteListener(ActionListener listener) {
        this.myCopyPasteListener = listener;
    }

    @Override
    public File getFileToImport() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(IMPORT_DIALOG_TITLE);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilterImpl("csv", "Comma Separated Values Files"));
        int result = fileChooser.showOpenDialog(this);
        if (result == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    @Override
    public File getFileForExport() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(EXPORT_DIALOG_TITLE);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(new FileFilterImpl("csv", "Comma Separated Values Files"));
        fileChooser.setSelectedFile(new File(this.getActiveTabTitle() + ".csv"));
        int result = fileChooser.showSaveDialog(this);
        if (result == 0) {
            int response;
            File theFile = fileChooser.getSelectedFile();
            if (theFile == null) {
                return null;
            }
            if (theFile.exists() && (response = JOptionPane.showConfirmDialog(this, "The file '" + theFile.getAbsolutePath() + "' exists, overwrite existing file?", "File exists", 2, 3)) == 2) {
                return this.getFileForExport();
            }
            return theFile;
        }
        return null;
    }

    @Override
    public boolean isModified() {
        boolean isModified = false;
        for (MultiDataUpdateTableModel model : this.myUsedModels.values()) {
            if (!model.isModified()) continue;
            isModified = true;
            break;
        }
        return isModified;
    }

    @Override
    public void runInBackground(final MultiDataUpdateModificationView.ProgressJob job) {
        final ProgressDialog dialog = new ProgressDialog(job.getTitle(), job.getText(), true);
        if (!job.needsProgressControl()) {
            dialog.setIndeterminate(true);
            dialog.setStringPainted(false);
        }
        final Thread jobThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator pi = dialog.getProgressIndicator();
                job.run(pi);
            }
        });
        Thread waitThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    jobThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                });
            }
        });
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setInfoText("Canceled, please wait...");
                jobThread.interrupt();
            }
        });
        jobThread.start();
        waitThread.start();
        dialog.setVisible(true);
    }

    @Override
    public void synchronizeTableModels() {
        for (MultiDataUpdateTableModel model : this.myUsedModels.values()) {
            model.synchronizeModel();
        }
    }

    @Override
    public void commitTableModels() {
        for (MultiDataUpdateTableModel model : this.myUsedModels.values()) {
            if (!model.isModified()) continue;
            model.commitValues();
        }
        this.myUndoManager.discardAllEdits();
    }

    @Override
    public boolean askQuestion(String title, String queryMessage) {
        return DialogFactory.getQuestionDialogCustomButtons(this, title, queryMessage, "Yes", "No");
    }

    private class RedoAction
    implements ActionListener {
        private RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MultiDataUpdateModificationPanel.this.myUndoManager.canRedo()) {
                MultiDataUpdateModificationPanel.this.myUndoManager.redo();
            }
        }
    }

    private class UndoAction
    implements ActionListener {
        private UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MultiDataUpdateModificationPanel.this.myUndoManager.canUndo()) {
                MultiDataUpdateModificationPanel.this.myUndoManager.undo();
            }
        }
    }
}

