/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.gui.navigator.nodeimport.ImportUtil;
import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.ratingrules.VersionHandler;
import com.ericsson.ere.gui.undoredo.UndoableTree;
import com.ericsson.ere.gui.util.Version;
import com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateModel;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import ericsson.ere.xml.XMLUtil;
import java.awt.Component;
import java.beans.PropertyChangeSupport;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JTree;
import org.w3c.dom.Element;

public class MultiDataUpdateSaveHandler
implements SelectionTree,
VersionHandler {
    private MultiDataUpdateModel myModel;
    private boolean myIsModified;
    private Component myOwner;
    private PropertyChangeSupport myPropChangeSupport = new PropertyChangeSupport(this);

    public MultiDataUpdateSaveHandler(Component ownerFrame, MultiDataUpdateModel model) {
        this.myModel = model;
        this.myOwner = ownerFrame;
        this.myIsModified = true;
    }

    @Override
    public TSTariffStructure buildCopy(RatingRuleBuilder builder) {
        XMLInitializable rootNode;
        try {
            rootNode = builder.build(this.myModel.getConfiguration());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
        if (!(rootNode instanceof TSTariffStructure)) {
            throw new IllegalArgumentException("Builder did not produce a TSTariffStructure root.");
        }
        return (TSTariffStructure)rootNode;
    }

    @Override
    public Element getUpdatedXMLConfiguration() {
        return this.getConfiguration(false);
    }

    @Override
    public Element getUpdatedXMLConfigurationClone() {
        return this.getConfiguration(true);
    }

    private Element getConfiguration(boolean clone) {
        Element updatedConfig = (Element)this.myModel.getConfiguration();
        if (clone) {
            updatedConfig = (Element)updatedConfig.cloneNode(true);
        }
        return updatedConfig;
    }

    @Override
    public VersionHandler getVersionHandler() {
        return this;
    }

    @Override
    public void updateVersion(Element xml, long currentVersion) {
        long remoteVersion = currentVersion;
        Element versionElement = XMLUtil.getFirstElementNamed("Version", xml);
        if (versionElement == null) {
            ImportUtil.addVersionElement(xml);
        } else {
            long version = remoteVersion >= 0L ? remoteVersion + 1L : this.createFallbackVersion(versionElement);
            versionElement.setAttribute("version", String.valueOf(version));
            versionElement.setAttribute("modified", new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS").format(Calendar.getInstance().getTime()));
        }
    }

    private long createFallbackVersion(Element versionElement) {
        String versionString = versionElement.getAttribute("version");
        return Long.valueOf(versionString) + 1L;
    }

    @Override
    public boolean isTreeValid() {
        return true;
    }

    @Override
    public boolean isModified() {
        return this.myIsModified;
    }

    @Override
    public boolean validateLinkTargets() {
        return true;
    }

    @Override
    public void addElement(int type, boolean asChild) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSetting(String setting) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JTree getTreeComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TSTariffStructure getTreeRoot() {
        throw new UnsupportedOperationException();
    }

    @Override
    public UndoableTree getUndoableTree() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Version getVersion() {
        Element config = (Element)this.myModel.getConfiguration();
        Element versionElement = XMLUtil.getFirstElementNamed("Version", config);
        return Version.create(versionElement, null);
    }

    @Override
    public void resetModified() {
        assert (this.myIsModified);
        this.myIsModified = false;
        this.myPropChangeSupport.firePropertyChange("modified", true, false);
    }

    @Override
    public void setTree(JTree tree) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setVersion(Version version) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Component getOwnerFrame() {
        return this.myOwner;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.myPropChangeSupport;
    }
}

