/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.exception.UncheckedInterruptedException;
import com.ericsson.ere.gui.multiupdate.ConfigurationParameterHelper;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateFindCriteria;
import com.ericsson.ere.selectiontree.interfaces.ConfigurationParameter;
import com.ericsson.ere.selectiontree.mdu.filter.ExtendedSelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.PathBasedElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.TagBasedElementFilter;
import com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateModel;
import com.ericsson.ere.selectiontree.mdu.model.SelectionTreeElementType;
import com.ericsson.ere.util.CollectionUtils;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class MultiDataUpdateTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8362868524223893678L;
    private static final String ID_PATH = "Path";
    private static final String ID_TAG = "Tag";
    private static final String ID_UNKNOWN = "Identifier";
    private TableModel myReadAndWriteModel;
    private TableModel myReadOnlyModel;
    private MultiDataUpdateModel myUnderlyingModel;
    private SelectionTreeElementType myElementType;
    private Integer[] myRowElemCountCache;
    private Object[][] myNewValueCache;
    private ConfigurationParameterHelper[][] myHelpers;
    private String myIdentifier;
    private UndoableEditSupport myUndoSupport = new UndoableEditSupport();
    boolean myIsUndoingOrRedoing;

    public MultiDataUpdateTableModel(SelectionTreeElementType type, MultiDataUpdateModel model, List<SelectionTreeElementFilter> rowFilters, Comparator<? super ConfigurationParameter> parameterComparator) {
        this.myUnderlyingModel = model;
        this.myElementType = type;
        this.myIdentifier = this.deduceIdentifier(rowFilters);
        this.myReadOnlyModel = new CachedModel(com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateTableModel.createReadOnlyTableModel(model, type, parameterComparator, rowFilters));
        com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateTableModel rwModel = com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateTableModel.createReadWriteTableModel(model, type, parameterComparator, rowFilters);
        rwModel.useCollectionValues(false);
        this.myReadAndWriteModel = rwModel;
        this.createHelpers(rwModel.getParameters());
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.myUndoSupport.addUndoableEditListener(l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.myUndoSupport.removeUndoableEditListener(l);
    }

    protected void fireChangeEdit(int row, int col, Object oldValue, Object newValue) {
        TableChangeEdit edit = new TableChangeEdit(row, col, oldValue, newValue);
        this.myUndoSupport.beginUpdate();
        this.myUndoSupport.postEdit(edit);
        this.myUndoSupport.endUpdate();
    }

    private String deduceIdentifier(List<SelectionTreeElementFilter> filters) {
        String id;
        SelectionTreeElementFilter filter = filters.get(0);
        if (filter instanceof MultiDataUpdateFindCriteria.CriteriaBasedElementFilter) {
            MultiDataUpdateFindCriteria ct = ((MultiDataUpdateFindCriteria.CriteriaBasedElementFilter)filter).getCriteriaType();
            switch (ct) {
                case PATH_BASED: {
                    id = ID_PATH;
                    break;
                }
                case TAG_BASED: {
                    id = ID_TAG;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled criteria type: " + (Object)((Object)ct)));
                }
            }
        } else {
            id = filter instanceof TagBasedElementFilter ? ID_TAG : (filter instanceof PathBasedElementFilter ? ID_PATH : ID_UNKNOWN);
        }
        return id;
    }

    private void createHelpers(List<ConfigurationParameter> parameters) {
        int rc = this.getRowCount();
        int cc = (this.getColumnCount() - 1) / 2;
        assert (cc == parameters.size());
        this.myHelpers = new ConfigurationParameterHelper[rc][cc];
        for (int r = 0; r < rc; ++r) {
            for (int c = 0; c < cc; ++c) {
                ConfigurationParameter param = parameters.get(c);
                SelectionTreeElementFilter rowFilter = (SelectionTreeElementFilter)this.getValueAt(r, 0);
                this.myHelpers[r][c] = new ConfigurationParameterHelper(this.myUnderlyingModel, this.myElementType, rowFilter, param);
            }
        }
    }

    public int getElementCountForRow(int row) {
        int count;
        if (row < 0 || row >= this.getRowCount()) {
            throw new IndexOutOfBoundsException("Invalid row index: " + row);
        }
        if (this.myRowElemCountCache != null && this.myRowElemCountCache[row] != null) {
            count = this.myRowElemCountCache[row];
        } else {
            if (this.myRowElemCountCache == null) {
                this.myRowElemCountCache = new Integer[this.getRowCount()];
            }
            SelectionTreeElementFilter filter = (SelectionTreeElementFilter)this.getValueAt(row, 0);
            count = 0;
            if (filter != null) {
                List<TariffStructureNode> elements = this.myUnderlyingModel.getElementsOfType(this.myElementType);
                count = this.filterAndCount(elements, filter);
            }
            this.myRowElemCountCache[row] = count;
        }
        return count;
    }

    private int filterAndCount(List<TariffStructureNode> elements, SelectionTreeElementFilter filter) {
        if (filter instanceof ExtendedSelectionTreeElementFilter) {
            Collection<TariffStructureNode> coll = ((ExtendedSelectionTreeElementFilter)filter).filter(elements);
            return coll.size();
        }
        return CollectionUtils.filter(elements, filter).size();
    }

    Variable createVariableForCell(int row, int column, Object value) throws Exception {
        ConfigurationParameterHelper helper = this.getConfigParamHelper(row, column);
        return helper.createVariableForValue(value);
    }

    Component createRendererForCell(int row, int column, Object value) throws Exception {
        ConfigurationParameterHelper helper = this.getConfigParamHelper(row, column);
        return helper.createRendererForValue(value);
    }

    String getDisplayStringForCell(int row, int column, Object value) throws Exception {
        ConfigurationParameterHelper helper = this.getConfigParamHelper(row, column);
        return helper.getDisplayStringForValue(value);
    }

    String getValueStringForCell(int row, int column, Object value) throws Exception {
        ConfigurationParameterHelper helper = this.getConfigParamHelper(row, column);
        return helper.getValueStringForValue(value);
    }

    Object parseStringToObjectForCell(int row, int column, String str) throws Exception {
        ConfigurationParameterHelper helper = this.getConfigParamHelper(row, column);
        return helper.parseStringToObject(str);
    }

    private ConfigurationParameterHelper getConfigParamHelper(int row, int column) {
        int idx = this.getValueColumnIndex(column) - 1;
        return this.myHelpers[row][idx];
    }

    @Override
    public int getColumnCount() {
        return this.myReadOnlyModel.getColumnCount() + this.getWritableColumnCount();
    }

    public int getWritableColumnCount() {
        return this.myReadAndWriteModel.getColumnCount() - 1;
    }

    @Override
    public int getRowCount() {
        return this.myReadAndWriteModel.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object value;
        if (columnIndex == 0) {
            value = this.myReadAndWriteModel.getValueAt(rowIndex, 0);
        } else if (this.isWriteColumn(columnIndex)) {
            Object cachedValue;
            int idx = this.getValueColumnIndex(columnIndex);
            value = this.myReadAndWriteModel.getValueAt(rowIndex, idx);
            if (this.myNewValueCache != null && (cachedValue = this.myNewValueCache[rowIndex][idx - 1]) != null) {
                value = cachedValue;
            }
        } else {
            value = this.myReadOnlyModel.getValueAt(rowIndex, this.getValueColumnIndex(columnIndex));
            if (value instanceof Collection) {
                value = this.extractUniqueValues((Collection)value);
            }
        }
        return value;
    }

    private Object extractUniqueValues(Collection<?> values) {
        if (values.isEmpty()) {
            return null;
        }
        HashSet set = new HashSet(values);
        return set.size() > 1 ? set : set.iterator().next();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (this.isWriteColumn(columnIndex)) {
            if (value == null) {
                throw new IllegalArgumentException("Cannot set null value");
            }
            int idx = this.getValueColumnIndex(columnIndex) - 1;
            if (this.myNewValueCache == null) {
                this.myNewValueCache = new Object[this.getRowCount()][this.myReadAndWriteModel.getColumnCount() - 1];
            }
            Object oldValue = this.myNewValueCache[rowIndex][idx];
            this.myNewValueCache[rowIndex][idx] = value;
            this.fireTableCellUpdated(rowIndex, columnIndex);
            if (!this.myIsUndoingOrRedoing) {
                this.fireChangeEdit(rowIndex, columnIndex, oldValue, value);
            }
        } else {
            throw new IllegalArgumentException("Column " + columnIndex + " is not editable.");
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.isWriteColumn(columnIndex)) {
            return false;
        }
        Object oldValue = this.getValueAt(rowIndex, columnIndex - 1);
        return !this.isNullOrEmptyCollection(oldValue);
    }

    private boolean isNullOrEmptyCollection(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof Collection && ((Collection)value).isEmpty();
    }

    private int getValueColumnIndex(int col) {
        assert (col > 0);
        return 1 + (col - 1) / 2;
    }

    @Override
    public String getColumnName(int column) {
        String headerValue = column == 0 ? this.myIdentifier : (this.isWriteColumn(column) ? this.myReadAndWriteModel.getColumnName(this.getValueColumnIndex(column)) + " - New" : this.myReadOnlyModel.getColumnName(this.getValueColumnIndex(column)) + " - Old");
        return headerValue;
    }

    public int getWritableColumnByName(String name) {
        int columnCount = this.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String columnName;
            if (!this.isWriteColumn(i) || !(columnName = this.myReadAndWriteModel.getColumnName(this.getValueColumnIndex(i))).equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int getRowByIdentifier(String identifier) {
        for (int i = 0; i < this.myReadAndWriteModel.getRowCount(); ++i) {
            Object o = this.myReadAndWriteModel.getValueAt(i, 0);
            if (!(o instanceof SelectionTreeElementFilter) || !((SelectionTreeElementFilter)o).getDisplayString().equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class<?> clazz = column == 0 ? this.myReadAndWriteModel.getColumnClass(0) : (this.isWriteColumn(column) ? this.myReadAndWriteModel.getColumnClass(this.getValueColumnIndex(column)) : this.myReadOnlyModel.getColumnClass(this.getValueColumnIndex(column)));
        return clazz;
    }

    public void resetToOldValue(int rowIndex, int colIndex) {
        int idx;
        if (!this.isWriteColumn(colIndex)) {
            throw new IllegalArgumentException("Column " + colIndex + " is not editable.");
        }
        boolean didReset = false;
        if (this.myNewValueCache != null && this.myNewValueCache[rowIndex][idx = this.getValueColumnIndex(colIndex) - 1] != null) {
            this.myNewValueCache[rowIndex][idx] = null;
            didReset = true;
        }
        if (!didReset) {
            throw new IllegalArgumentException("Cannot reset for unset new value.");
        }
        this.fireTableCellUpdated(rowIndex, colIndex);
    }

    public void commitValues() {
        if (this.myNewValueCache != null) {
            int rc = this.myNewValueCache.length;
            int cc = this.myNewValueCache[0].length;
            for (int r = 0; r < rc; ++r) {
                for (int c = 0; c < cc; ++c) {
                    Object value = this.myNewValueCache[r][c];
                    if (value == null) continue;
                    this.myReadAndWriteModel.setValueAt(value, r, c + 1);
                }
            }
        }
    }

    public void synchronizeModel() {
        if (this.myNewValueCache != null) {
            int rc = this.myNewValueCache.length;
            int cc = this.myNewValueCache[0].length;
            for (int r = 0; r < rc; ++r) {
                for (int c = 0; c < cc; ++c) {
                    this.myNewValueCache[r][c] = null;
                }
            }
        }
        CachedModel cm = (CachedModel)this.myReadOnlyModel;
        cm.refreshCache();
        this.fireTableDataChanged();
    }

    public boolean isModified() {
        boolean changed = false;
        if (this.myNewValueCache != null) {
            int rc = this.myNewValueCache.length;
            int cc = this.myNewValueCache[0].length;
            block0: for (int r = 0; r < rc; ++r) {
                for (int c = 0; c < cc; ++c) {
                    if (this.myNewValueCache[r][c] == null) continue;
                    changed = true;
                    continue block0;
                }
            }
        }
        return changed;
    }

    public boolean isModifiedAt(int row, int column) {
        if (!this.isWriteColumn(column)) {
            throw new IllegalArgumentException("Can only query modified status for a cell in a write column.");
        }
        boolean modified = false;
        if (this.myNewValueCache != null) {
            int idx = this.getValueColumnIndex(column) - 1;
            return this.myNewValueCache[row][idx] != null;
        }
        return modified;
    }

    private boolean isWriteColumn(int column) {
        return column > 0 && column % 2 == 0;
    }

    private class TableChangeEdit
    extends AbstractUndoableEdit {
        private int myColumnIndex;
        private int myRowIndex;
        private Object myOldValue;
        private Object myNewValue;

        public TableChangeEdit(int rowIndex, int columnIndex, Object oldValue, Object newValue) {
            this.myColumnIndex = columnIndex;
            this.myRowIndex = rowIndex;
            this.myOldValue = oldValue;
            this.myNewValue = newValue;
        }

        @Override
        public void undo() {
            super.undo();
            this.setValue(this.myOldValue);
        }

        @Override
        public void redo() {
            super.redo();
            this.setValue(this.myNewValue);
        }

        private void setValue(Object value) {
            if (value == null) {
                MultiDataUpdateTableModel.this.resetToOldValue(this.myRowIndex, this.myColumnIndex);
            } else {
                MultiDataUpdateTableModel.this.myIsUndoingOrRedoing = true;
                try {
                    MultiDataUpdateTableModel.this.setValueAt(value, this.myRowIndex, this.myColumnIndex);
                }
                finally {
                    MultiDataUpdateTableModel.this.myIsUndoingOrRedoing = false;
                }
            }
        }
    }

    private static class CachedModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4855474351395735165L;
        private Object[][] myCache;
        private TableModel myOriginal;

        CachedModel(TableModel original) {
            this.myOriginal = original;
            int rc = original.getRowCount();
            int cc = original.getColumnCount();
            this.myCache = new Object[rc][cc];
            this.refreshCache();
        }

        void refreshCache() {
            int rc = this.myCache.length;
            int cc = rc > 0 ? this.myCache[0].length : 0;
            for (int r = 0; r < rc; ++r) {
                for (int c = 0; c < cc; ++c) {
                    if (Thread.interrupted()) {
                        throw new UncheckedInterruptedException("Interrupted while refreshing old value cache.");
                    }
                    this.myCache[r][c] = this.myOriginal.getValueAt(r, c);
                }
            }
        }

        @Override
        public int getColumnCount() {
            return this.myOriginal.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return this.myOriginal.getRowCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myCache[rowIndex][columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.myOriginal.getColumnClass(columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            return this.myOriginal.getColumnName(column);
        }
    }
}

