/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate.presenter;

import com.ericsson.ere.gui.multiupdate.MultiDataUpdateModelIOHandler;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateState;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateTableModel;
import com.ericsson.ere.gui.multiupdate.Status;
import com.ericsson.ere.gui.multiupdate.StatusHandler;
import com.ericsson.ere.gui.multiupdate.view.MultiDataUpdateModificationView;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import java.util.Observable;

final class ImportAction
extends Observable
implements ActionListener {
    private MultiDataUpdateModificationView myModificationView;
    private MultiDataUpdateState myState;

    public ImportAction(MultiDataUpdateModificationView modificationView, MultiDataUpdateState state) {
        this.myModificationView = modificationView;
        this.myState = state;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        StatusHandler statusHandler = new StatusHandler();
        if (this.currentViewStateAllowsImport(statusHandler) && (file = this.myModificationView.getFileToImport()) != null) {
            Map<String, MultiDataUpdateTableModel> tableModels = this.myModificationView.getUsedModels();
            String key = this.myModificationView.getActiveTabTitle();
            Status statusFromImport = MultiDataUpdateModelIOHandler.importFromFileToModel(file, tableModels, key);
            statusHandler.add(statusFromImport);
        }
        if (statusHandler.getStatusCount() > 0) {
            this.myState.setStatus(statusHandler.generateCompoundStatus());
        } else {
            this.myState.setResultStatus();
        }
    }

    private boolean currentViewStateAllowsImport(StatusHandler statusHandler) {
        boolean continueImport = this.myModificationView.finishEditing();
        if (continueImport) {
            if (this.myModificationView.isModified()) {
                continueImport = this.viewAllowsOverwritingExistingValues();
            }
        } else {
            statusHandler.add(this.createErrorStatus());
        }
        return continueImport;
    }

    private boolean viewAllowsOverwritingExistingValues() {
        String question = "There are modified values in the current view.\nImported values will overwrite any existing modifications.\nDo you want to continue?";
        return this.myModificationView.askQuestion("Import", question);
    }

    private Status createErrorStatus() {
        String msg = "Import cannot be performed since a cell is open for editing and cannot be commited.";
        return new Status("Import canceled", msg, Status.SEVERITY.ERROR);
    }
}

