/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator;

import com.ericsson.ere.gui.diff.DiffToolPanel;
import com.ericsson.ere.gui.navigator.NavigatorTreeCascadeHandler;
import com.ericsson.ere.gui.navigator.NavigatorTreeExpansionStateTracker;
import com.ericsson.ere.gui.navigator.NavigatorTreeRenderer;
import com.ericsson.ere.gui.navigator.NavigatorTreeTransferHandler;
import com.ericsson.ere.gui.navigator.NavigatorTreeUtil;
import com.ericsson.ere.gui.navigator.actions.AddNodeFilterAction;
import com.ericsson.ere.gui.navigator.actions.CompareAction;
import com.ericsson.ere.gui.navigator.actions.ConnectAction;
import com.ericsson.ere.gui.navigator.actions.DeleteAction;
import com.ericsson.ere.gui.navigator.actions.DisconnectAction;
import com.ericsson.ere.gui.navigator.actions.DistributedDeleteAction;
import com.ericsson.ere.gui.navigator.actions.DistributedSaveAction;
import com.ericsson.ere.gui.navigator.actions.EditAction;
import com.ericsson.ere.gui.navigator.actions.ExportAction;
import com.ericsson.ere.gui.navigator.actions.ImportAction;
import com.ericsson.ere.gui.navigator.actions.MultiDataUpdateAction;
import com.ericsson.ere.gui.navigator.actions.NewRatingPeriodAction;
import com.ericsson.ere.gui.navigator.actions.NewServiceAction;
import com.ericsson.ere.gui.navigator.actions.PropertiesAction;
import com.ericsson.ere.gui.navigator.actions.SaveAction;
import com.ericsson.ere.gui.navigator.distribute.DistributionWizardOptions;
import com.ericsson.ere.gui.navigator.distribute.EREDistributorDialog;
import com.ericsson.ere.gui.navigator.model.NavigatorTreeModel;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.EreNode;
import com.ericsson.ere.gui.navigator.nodes.InternalEreNode;
import com.ericsson.ere.gui.navigator.nodes.ManagerNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceNode;
import com.ericsson.ere.gui.navigator.popupmenus.AbstractNavigatorPopupMenu;
import com.ericsson.ere.gui.navigator.popupmenus.NavigatorPopupMenu;
import com.ericsson.ere.gui.navigator.popupmenus.RatingManagerPopupMenu;
import com.ericsson.ere.gui.navigator.popupmenus.RatingPopupMenu;
import com.ericsson.ere.gui.navigator.popupmenus.ServicePopupMenu;
import com.ericsson.ere.gui.util.SystemPropertyUtil;
import com.ericsson.ere.gui.wizard.WizardDialog;
import com.ericsson.ere.gui.wizard.WizardOptions;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.InternalEreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.ratingrules.RatingRuleFrame;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.FrameOpener;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.integration.connector.EreCommunicationException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.InputMap;
import javax.swing.JInternalFrame;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;

public class NavigatorTree
extends JTree {
    private static final long serialVersionUID = 8484991552249428763L;
    public static final String NAV_TREE_DISABLE_NO_NODES_MESSAGE = "navtree.disable.nonodes.message";
    @Deprecated
    public static final String NODE_SEPARATOR_STRING = "\u0000";
    NavigatorTreeRenderer treeRenderer = new NavigatorTreeRenderer();
    final Map<Class<? extends AbstractEreProxy>, AbstractNavigatorPopupMenu> myPopupMenuTable = new HashMap<Class<? extends AbstractEreProxy>, AbstractNavigatorPopupMenu>();
    public static ConnectAction connectAction = null;
    public static DeleteAction deleteAction = null;
    public static DisconnectAction disconnectAction = null;
    public static EditAction editAction = null;
    public static ExportAction exportAction = null;
    public static ImportAction importAction = null;
    public static PropertiesAction propertiesAction = null;
    public static SaveAction saveAction = null;
    public static CompareAction compareToAction = null;
    public static DistributedDeleteAction distributedDeleteAction = null;
    public static DistributedSaveAction distributedSaveAction = null;
    public static NewRatingPeriodAction newRatingPeriodAction = null;
    public static NewServiceAction newServiceAction = null;
    public static AddNodeFilterAction addNodeFilterAction = null;
    public static MultiDataUpdateAction mduAction = null;
    @Deprecated
    public boolean cascadeExpand = false;

    public NavigatorTree(NavigatorTreeModel anyNavigatorTreeModel) {
        super(anyNavigatorTreeModel);
        this.setName("EreNavigatorTree");
        anyNavigatorTreeModel.registerTreeOwner(this);
        if (((DefaultMutableTreeNode)this.getModel().getRoot()).getChildCount() == 0) {
            this.showNoNodesMessage();
        }
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setCellRenderer(this.treeRenderer);
        this.getSelectionModel().setSelectionMode(4);
        this.addListenerToTree();
        anyNavigatorTreeModel.addModelStructureListener(new NavigatorTreeExpansionStateTracker(this));
        this.initActions();
        this.populatePopupMenuTable(this.myPopupMenuTable);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.enableTransferHandler(new NavigatorTreeTransferHandler());
        this.buildMenuForEreNodes((DefaultMutableTreeNode)this.getModel().getRoot());
        this.expandRatingPeriodNode((DefaultMutableTreeNode)this.getModel().getRoot());
    }

    private void populatePopupMenuTable(Map<Class<? extends AbstractEreProxy>, AbstractNavigatorPopupMenu> table) {
        AbstractNavigatorPopupMenu pm = new NavigatorPopupMenu(this);
        table.put(null, pm);
        table.put(EreProxy.class, pm);
        table.put(InternalEreProxy.class, pm);
        pm = new RatingManagerPopupMenu(this);
        table.put(RatingManagerProxy.class, pm);
        pm = new ServicePopupMenu(this);
        table.put(ServiceListProxy.class, pm);
        table.put(ServiceProxy.class, pm);
        pm = new RatingPopupMenu(this);
        table.put(ServiceProviderListProxy.class, pm);
        table.put(RatingPeriodProxy.class, pm);
        table.put(RatingPlanProxy.class, pm);
        table.put(ServiceProviderProxy.class, pm);
    }

    private void enableTransferHandler(TransferHandler th) {
        this.setTransferHandler(th);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON);
    }

    private void showNoNodesMessage() {
        boolean suppress = Boolean.parseBoolean(SystemPropertyUtil.getPropertyWithOptionalJnlpPrefix(NAV_TREE_DISABLE_NO_NODES_MESSAGE, "false"));
        if (!suppress) {
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "No configured nodes", "No nodes are configured.\nTo configure new nodes, right-click on the Ere Navigator node\nand select Add ERE Node.");
        }
    }

    private void buildMenuForEreNodes(DefaultMutableTreeNode node) {
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)e.nextElement();
            EreProxy proxy = null;
            if (tNode instanceof EreNode) {
                proxy = ((EreNode)tNode).getEreProxy();
            } else if (tNode instanceof InternalEreNode) {
                proxy = (EreProxy)((InternalEreNode)tNode).getProxy();
            }
            if (proxy == null || !proxy.isConnected()) continue;
            proxy.getNavigatorMenuBuilderForNavigatorTree(this).registerCustomPopupMenus(this);
        }
    }

    private void initActions() {
        connectAction = new ConnectAction(this);
        deleteAction = new DeleteAction(this);
        disconnectAction = new DisconnectAction(this);
        editAction = new EditAction(this);
        exportAction = new ExportAction(this);
        importAction = new ImportAction(this);
        propertiesAction = new PropertiesAction(this);
        compareToAction = new CompareAction(this);
        saveAction = new SaveAction(this);
        mduAction = new MultiDataUpdateAction(this);
        distributedDeleteAction = new DistributedDeleteAction(this);
        distributedSaveAction = new DistributedSaveAction(this);
        addNodeFilterAction = new AddNodeFilterAction(this);
        newServiceAction = new NewServiceAction(this);
        newRatingPeriodAction = new NewRatingPeriodAction(this);
        InputMap input = this.getInputMap();
        ActionMap action = this.getActionMap();
        input.put(KeyStroke.getKeyStroke(83, 128), "save");
        action.put("save", saveAction);
        input.put(KeyStroke.getKeyStroke(73, 128), "import");
        action.put("import", importAction);
        input.put(KeyStroke.getKeyStroke(69, 128), "export");
        action.put("export", exportAction);
        input.put(KeyStroke.getKeyStroke(127, 0), "delete");
        action.put("delete", deleteAction);
        input.put(KeyStroke.getKeyStroke(10, 512), "properties");
        action.put("properties", propertiesAction);
        input.put(KeyStroke.getKeyStroke(116, 0), "refresh");
        action.put("refresh", connectAction);
        input.put(KeyStroke.getKeyStroke(77, 128), "multidataupdate");
        action.put("multidataupdate", mduAction);
        input.put(KeyStroke.getKeyStroke(127, 64), "distributedDelete");
        action.put("distributedDelete", distributedDeleteAction);
        input.put(KeyStroke.getKeyStroke(83, 64), "distributedSave");
        action.put("distributedSave", distributedSaveAction);
        input.put(KeyStroke.getKeyStroke(10, 0), "defaultAction");
        action.put("defaultAction", new DefaultAction());
        this.disableAllActions();
    }

    public void disableAllActions() {
        connectAction.setEnabled(false);
        deleteAction.setEnabled(false);
        disconnectAction.setEnabled(false);
        editAction.setEnabled(false);
        exportAction.setEnabled(false);
        importAction.setEnabled(false);
        propertiesAction.setEnabled(false);
        saveAction.setEnabled(false);
        compareToAction.setEnabled(false);
        distributedDeleteAction.setEnabled(false);
        distributedSaveAction.setEnabled(false);
        newServiceAction.setEnabled(false);
        newRatingPeriodAction.setEnabled(false);
        mduAction.setEnabled(false);
    }

    private void addListenerToTree() {
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (!NavigatorTree.isMultiSelectForRatingPeriodNodes(NavigatorTree.this.getSelectionPaths())) {
                    NavigatorTree.this.filterSelectionPathForNodes();
                }
                NavigatorTree.this.enableActionsForNode();
            }
        });
        this.addMouseListener(new MouseHandler());
        NavigatorTreeCascadeHandler handler = new NavigatorTreeCascadeHandler();
        this.addKeyListener(handler);
        this.addTreeExpansionListener(handler);
        GuiUtil.disableRootCollapse(this);
    }

    public static boolean isMultiSelectForRatingPeriodNodes(TreePath[] selectionPaths) {
        boolean multiSelRatingPeriodNode = true;
        if (selectionPaths != null && selectionPaths.length > 1) {
            for (TreePath treePath : selectionPaths) {
                if (NavigatorTree.isValidMultiSelectNode(treePath, selectionPaths[0])) continue;
                multiSelRatingPeriodNode = false;
                break;
            }
        } else {
            multiSelRatingPeriodNode = false;
        }
        return multiSelRatingPeriodNode;
    }

    private static boolean isValidMultiSelectNode(TreePath actualTreePath, TreePath firstTreePath) {
        boolean isValidNode = true;
        AbstractNavigatorNode actualNode = (AbstractNavigatorNode)actualTreePath.getLastPathComponent();
        AbstractNavigatorNode firstNode = (AbstractNavigatorNode)firstTreePath.getLastPathComponent();
        if (actualNode instanceof RatingPeriodNode && firstNode instanceof RatingPeriodNode) {
            RatingPeriodProxy actualProxy = (RatingPeriodProxy)actualNode.getProxy();
            RatingPeriodProxy firstProxy = (RatingPeriodProxy)firstNode.getProxy();
            if (actualProxy.isSelectedActive() || !firstProxy.getParentRatingPlanProxy().equals(actualProxy.getParentRatingPlanProxy())) {
                isValidNode = false;
            }
        } else {
            isValidNode = false;
        }
        return isValidNode;
    }

    private void filterSelectionPathForNodes() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths != null && selectionPaths.length > 1) {
            ArrayList<TreePath> list = new ArrayList<TreePath>();
            for (TreePath treePath : selectionPaths) {
                if (!NavigatorTree.isValidMultiSelectNode(treePath, selectionPaths[0])) continue;
                list.add(treePath);
            }
            int pathSize = list.size();
            if (pathSize == 1) {
                this.setSelectionPath(this.getSelectionPath());
            } else {
                this.setSelectionPaths(list.toArray(new TreePath[pathSize]));
            }
        }
    }

    public void enableActionsForNode() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node instanceof NavigatorNodeInterface) {
            AbstractEreProxy proxy = ((NavigatorNodeInterface)((Object)node)).getProxy();
            AbstractNavigatorPopupMenu pm = null;
            pm = proxy != null ? this.myPopupMenuTable.get(proxy.getClass()) : this.myPopupMenuTable.get(null);
            if (pm != null && ((NavigatorNodeInterface)((Object)this.getSelectedNode())).isMenuOn()) {
                TreePath[] selectionPaths = this.getSelectionModel().getSelectionPaths();
                if (NavigatorTree.isMultiSelectForRatingPeriodNodes(selectionPaths)) {
                    this.disableAllActions();
                    deleteAction.setEnabled(this.nodesIsDeleteable(selectionPaths));
                    this.setDragEnabled(false);
                    GuiServiceCenter.getInstance().saveAsMenuAction.setEnabled(false);
                    GuiServiceCenter.getInstance().importMenuAction.setEnabled(false);
                } else {
                    pm.enableActions();
                    this.setDragEnabled(true);
                    GuiServiceCenter.getInstance().saveAsMenuAction.setEnabled(true);
                    GuiServiceCenter.getInstance().importMenuAction.setEnabled(true);
                }
                GuiServiceCenter.getInstance().enableHelpKey(this, this.getSelectedNode().getClass().toString(), null);
            }
        }
    }

    public DefaultMutableTreeNode getSelectedNode() {
        TreePath selPath = this.getSelectionPath();
        if (selPath != null) {
            return (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return null;
    }

    private void setTreeSelection(MouseEvent e) {
        TreePath[] selPaths = this.getSelectionPaths();
        TreePath newPath = this.getPathForLocation(e.getX(), e.getY());
        if (!(newPath == null || selPaths != null && Arrays.asList(selPaths).contains(newPath))) {
            this.getSelectionModel().setSelectionPath(newPath);
        }
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.setTreeSelection(e);
            if (this.getSelectedNode() instanceof ManagerNode && ((NavigatorNodeInterface)((Object)this.getSelectedNode())).getProxy().getAbortRefresh()) {
                return;
            }
            DefaultMutableTreeNode node = this.getSelectedNode();
            AbstractNavigatorPopupMenu pm = null;
            if (node instanceof NavigatorNodeInterface) {
                AbstractEreProxy proxy = ((NavigatorNodeInterface)((Object)node)).getProxy();
                if (proxy != null) {
                    Class<?> classForPopup = proxy.getClass();
                    pm = this.myPopupMenuTable.get(classForPopup);
                } else {
                    pm = this.myPopupMenuTable.get(null);
                }
                if (pm != null && ((NavigatorNodeInterface)((Object)this.getSelectedNode())).isMenuOn()) {
                    pm.enablePopupMenu();
                    TreePath[] selectionPaths = this.getSelectionModel().getSelectionPaths();
                    if (NavigatorTree.isMultiSelectForRatingPeriodNodes(selectionPaths)) {
                        pm.removeAll();
                        pm.addDeleteMenu(false);
                        deleteAction.setEnabled(this.nodesIsDeleteable(selectionPaths));
                    }
                    pm.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }
    }

    private boolean nodesIsDeleteable(TreePath[] selectionPath) {
        boolean nodeIsDeletable = true;
        for (TreePath treePath : selectionPath) {
            AbstractNavigatorNode node = (AbstractNavigatorNode)treePath.getLastPathComponent();
            if (NavigatorTreeUtil.nodeIsDeletable(node)) continue;
            nodeIsDeletable = false;
            break;
        }
        return nodeIsDeletable;
    }

    public void fireNodeStructureChanged(DefaultMutableTreeNode node) {
        ((NavigatorTreeModel)this.getModel()).nodeStructureChanged(node);
    }

    public void comparePeriodTo(RatingPeriodProxy ratingPeriodProxy) {
        DiffToolPanel diffTool = new DiffToolPanel(ratingPeriodProxy, 1);
        RmaFrameSupport frame = diffTool.getInternalFrame();
        new FrameOpener(frame).open();
    }

    public void distribute(AbstractEreProxy source, Class<?> task) {
        DistributionWizardOptions wizardOptions = new DistributionWizardOptions();
        wizardOptions.wizardTitle = "ERE Distribution wizard";
        Element sourceElement = this.getSourceElement(source);
        EREDistributorDialog analyzePanel = new EREDistributorDialog(source, sourceElement, task, EREDistributorDialog.DistributionMode.ANALYZE, wizardOptions);
        EREDistributorDialog performPanel = new EREDistributorDialog(source, sourceElement, task, EREDistributorDialog.DistributionMode.PERFORM, wizardOptions);
        wizardOptions.wizardPanels.add(analyzePanel);
        wizardOptions.wizardPanels.add(performPanel);
        WizardDialog tDialog = new WizardDialog(GuiServiceCenter.getInstance().getMainWindow(), (WizardOptions)wizardOptions);
        tDialog.setSize(500, 700);
        tDialog.setVisible(true);
    }

    private Element getSourceElement(AbstractEreProxy sourceProxy) {
        Element sourceStruture = null;
        try {
            if (sourceProxy instanceof RatingPeriodProxy) {
                sourceStruture = ((RatingPeriodProxy)sourceProxy).getRatingPeriodRuleTree();
            } else if (sourceProxy instanceof ServiceProxy) {
                sourceStruture = ((ServiceProxy)sourceProxy).getServiceXML();
            }
        }
        catch (EreCommunicationException ereCommunicationException) {
            // empty catch block
        }
        return sourceStruture;
    }

    public TreePath stringToPath(String string) {
        return NavigatorTreeUtil.stringToPath(this.getModel(), string);
    }

    public static String pathToString(TreePath path) {
        return NavigatorTreeUtil.pathToString(path);
    }

    public void expandRatingPeriodNode(DefaultMutableTreeNode node) {
        if (node instanceof ManagerNode || node instanceof EreNode || node instanceof InternalEreNode) {
            this.expandPath(new TreePath(node.getPath()));
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)e.nextElement();
            this.expandRatingPeriodNode(tNode);
        }
    }

    public void registerPopupMenu(AbstractNavigatorPopupMenu popupMenu, Class<? extends AbstractEreProxy> clazz) {
        this.myPopupMenuTable.put(clazz, popupMenu);
    }

    public void unregisterPopupMenu(Class<? extends AbstractEreProxy> clazz) {
        this.myPopupMenuTable.remove(clazz);
    }

    @Deprecated
    public boolean containsOpenedRatingPeriod() {
        AbstractEreProxy selectedProxy = ((AbstractNavigatorNode)this.getSelectedNode()).getProxy();
        JInternalFrame[] allFrames = GuiServiceCenter.getInstance().getDesktopPane().getAllFrames();
        for (int i = 0; i < allFrames.length; ++i) {
            if (!(allFrames[i] instanceof RatingRuleFrame)) continue;
            RatingPeriodProxy proxy = ((RatingRuleFrame)allFrames[i]).getRatingPeriodProxy();
            RatingPlanProxy parent = proxy.getParentRatingPlanProxy();
            ServiceProviderProxy grandParent = parent.getServiceProviderProxy();
            if (!selectedProxy.equals(proxy) && !selectedProxy.equals(parent) && !selectedProxy.equals(grandParent)) continue;
            return true;
        }
        return false;
    }

    private final class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int selRow;
            if (e.getClickCount() == 2 && e.getButton() == 1 && (selRow = NavigatorTree.this.getRowForLocation(e.getX(), e.getY())) != -1) {
                TreePath selPath = NavigatorTree.this.getPathForRow(selRow);
                DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                ((NavigatorTreeModel)NavigatorTree.this.getModel()).performNodeAction(tNode);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            NavigatorTree.this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            NavigatorTree.this.maybeShowPopup(e);
        }
    }

    private final class DefaultAction
    extends AbstractAction {
        private DefaultAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode selected = NavigatorTree.this.getSelectedNode();
            if ((selected instanceof RatingPeriodNode || selected instanceof ServiceNode) && NavigatorTree.this.getSelectionPaths().length == 1) {
                ((NavigatorTreeModel)NavigatorTree.this.getModel()).performNodeAction(selected);
            }
        }
    }
}

