/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator;

import com.ericsson.ere.gui.navigator.model.event.NavigatorModelStructureEvent;
import com.ericsson.ere.gui.navigator.model.event.NavigatorModelStructureListener;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.swing.TreeNodeExpansionState;
import java.util.Stack;
import javax.swing.JTree;

public class NavigatorTreeExpansionStateTracker
implements NavigatorModelStructureListener {
    private JTree myTree;
    private Stack<TreeNodeExpansionState> myStateStack = new Stack();

    public NavigatorTreeExpansionStateTracker(JTree tree) {
        this.myTree = tree;
    }

    @Override
    public void modelStructureHasChanged(NavigatorModelStructureEvent e) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                TreeNodeExpansionState state;
                if (!NavigatorTreeExpansionStateTracker.this.myStateStack.isEmpty() && (state = (TreeNodeExpansionState)NavigatorTreeExpansionStateTracker.this.myStateStack.pop()) != null) {
                    state.restore(NavigatorTreeExpansionStateTracker.this.myTree);
                }
            }
        });
    }

    @Override
    public void modelStructureWillChange(NavigatorModelStructureEvent e) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                TreeNodeExpansionState state = null;
                if (NavigatorTreeExpansionStateTracker.this.myStateStack.isEmpty()) {
                    state = new TreeNodeExpansionState(NavigatorTreeExpansionStateTracker.this.myTree);
                }
                NavigatorTreeExpansionStateTracker.this.myStateStack.push(state);
            }
        });
    }
}

