/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator;

import com.ericsson.ere.gui.navigator.nodes.EreNode;
import com.ericsson.ere.gui.navigator.nodes.InternalEreNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ActiveSavedRatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import ericsson.ere.datatype.Time;
import java.util.List;
import java.util.Vector;

public class NavigatorTreeNodeProperties {
    private final NavigatorNodeInterface myNodeInterface;

    public NavigatorTreeNodeProperties(NavigatorNodeInterface aNodeInterface) {
        this.myNodeInterface = aNodeInterface;
    }

    public boolean isRefreshAborted() {
        AbstractEreProxy abstractEreProxy;
        boolean abortRefresh = false;
        if ((this.myNodeInterface instanceof EreNode || this.myNodeInterface instanceof InternalEreNode) && (abstractEreProxy = this.myNodeInterface.getProxy()).getAbortRefresh()) {
            abortRefresh = true;
        }
        return abortRefresh;
    }

    public boolean isRatingPeriodCurrentlyExecuting() {
        boolean ratingPeriodCurrentlyExecuting = false;
        if (this.myNodeInterface instanceof RatingPeriodNode) {
            AbstractEreProxy abstractEreProxy = this.myNodeInterface.getProxy();
            if (abstractEreProxy instanceof ActiveSavedRatingPeriodProxy) {
                ActiveSavedRatingPeriodProxy currentActiveSavedRatingPeriodProxy = (ActiveSavedRatingPeriodProxy)abstractEreProxy;
                ratingPeriodCurrentlyExecuting = currentActiveSavedRatingPeriodProxy.isSelectedActive() ? this.isRatingPeriodTheCurrentExecutingInList(currentActiveSavedRatingPeriodProxy, this.getRatingPeriodProxyList(currentActiveSavedRatingPeriodProxy, true)) : false;
            } else if (abstractEreProxy instanceof RatingPeriodProxy) {
                RatingPeriodProxy currentRatingPeriodProxy = (RatingPeriodProxy)abstractEreProxy;
                ratingPeriodCurrentlyExecuting = this.isRatingPeriodTheCurrentExecutingInList(currentRatingPeriodProxy, this.getRatingPeriodProxyList(currentRatingPeriodProxy, false));
            }
        }
        return ratingPeriodCurrentlyExecuting;
    }

    private List<RatingPeriodProxy> getRatingPeriodProxyList(RatingPeriodProxy aRatingPeriodProxy, boolean isActiveRatingPeriod) {
        Vector<RatingPeriodProxy> ratingPeriodList = null;
        RatingPlanProxy ratingPlanProxy = aRatingPeriodProxy.getParentRatingPlanProxy();
        if (ratingPlanProxy != null) {
            ratingPeriodList = isActiveRatingPeriod ? ratingPlanProxy.getActiveListProxy().getRatingPeriodList() : ratingPlanProxy.getRatingPeriodList();
        }
        return ratingPeriodList;
    }

    private boolean isRatingPeriodTheCurrentExecutingInList(RatingPeriodProxy aNodeProxy, List<RatingPeriodProxy> aRatingPeriodList) {
        boolean ratingPeriodisExecuting = true;
        if (aRatingPeriodList != null && !aRatingPeriodList.isEmpty() && aNodeProxy.isStartTimeUsed()) {
            Time curTime;
            Time curRPStartTime = aNodeProxy.getRatingPeriodTime();
            if (curRPStartTime.compareTo(curTime = new Time()) < 0) {
                for (RatingPeriodProxy proxy : aRatingPeriodList) {
                    Time proxyRPTime = proxy.getRatingPeriodTime();
                    if (curRPStartTime.compareTo(proxyRPTime) >= 0 || proxyRPTime.compareTo(curTime) > 0) continue;
                    ratingPeriodisExecuting = false;
                    break;
                }
            } else {
                ratingPeriodisExecuting = false;
            }
        }
        return ratingPeriodisExecuting;
    }
}

