/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator;

import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.navigator.NavigatorNodeTransferable;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.EreNode;
import com.ericsson.ere.gui.navigator.nodes.InternalEreNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPlanNode;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.ToggleDialog;
import com.ericsson.ere.gui.wizard.WizardFactory;
import com.ericsson.ere.gui.wizard.WizardView;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.swing.NoClipboardTransferHandler;
import ericsson.ere.gui.Config;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.StatusPanel;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class NavigatorTreeTransferHandler
extends NoClipboardTransferHandler {
    private static final String ASK_ON_DRAG_COPY = "navigator.dnd.askOnDragCopy";

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTree tree = (JTree)c;
        DefaultMutableTreeNode aNode = this.getSelectedNode(tree);
        NavigatorNodeTransferable transferable = null;
        if (aNode != null && aNode.getPath() != null && (aNode instanceof RatingPeriodNode || aNode instanceof RatingPlanNode)) {
            transferable = new NavigatorNodeTransferable(new TreePath(aNode.getPath()));
        }
        return transferable;
    }

    @Override
    public boolean importDropData(TransferHandler.TransferSupport support) {
        Point loc = support.getDropLocation().getDropPoint();
        JTree tree = (JTree)support.getComponent();
        TreePath pathToDropOn = tree.getPathForLocation(loc.x, loc.y);
        boolean didAction = false;
        if (this.dropOnPathAllowed(pathToDropOn)) {
            try {
                Transferable transferData = support.getTransferable();
                List<File> fileList = null;
                AbstractNavigatorNode sourceNode = null;
                if (transferData.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    fileList = (List<File>)transferData.getTransferData(DataFlavor.javaFileListFlavor);
                } else if (transferData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String dropData = (String)transferData.getTransferData(DataFlavor.stringFlavor);
                    fileList = this.extractFileList(dropData);
                } else if (transferData.isDataFlavorSupported(NavigatorNodeTransferable.NAVIGATOR_TREE_PATH_FLAVOR)) {
                    TreePath path = (TreePath)transferData.getTransferData(NavigatorNodeTransferable.NAVIGATOR_TREE_PATH_FLAVOR);
                    sourceNode = (AbstractNavigatorNode)path.getLastPathComponent();
                }
                if (sourceNode != null) {
                    AbstractNavigatorNode destinationNode = (AbstractNavigatorNode)pathToDropOn.getLastPathComponent();
                    didAction = this.attemptNodeCopy(sourceNode, destinationNode);
                } else if (fileList != null && fileList.size() == 1) {
                    didAction = this.performFileImport(fileList, pathToDropOn);
                }
            }
            catch (Exception e) {
                ExceptionUtil.handleException(e, "navigator", 1, "Failed to drop the node in the Navigator.", true);
            }
        }
        return didAction;
    }

    private void setMsg(final String msg) {
        EDT.runLater(new Runnable(){

            @Override
            public void run() {
                StatusPanel.getInstance().setStatusMsg(msg);
            }
        });
    }

    private boolean attemptNodeCopy(AbstractNavigatorNode sourceNode, AbstractNavigatorNode destinationNode) {
        boolean didCopy = false;
        if (sourceNode != destinationNode && this.supportsWithinTreeDrag(destinationNode)) {
            if (!sourceNode.getProxy().isImportableUnder(destinationNode.getProxy())) {
                JOptionPane.showMessageDialog(GuiServiceCenter.getInstance().getMainWindow(), "Type mismatch, can not copy node.", "Node type error", 0);
            } else {
                int answer = 0;
                if (this.shouldAskAboutDragCopyNode()) {
                    answer = this.askAboutDragCopyNode();
                }
                if (answer == 0) {
                    this.performNodeCopy(sourceNode, destinationNode);
                    didCopy = true;
                }
            }
        }
        return didCopy;
    }

    private boolean shouldAskAboutDragCopyNode() {
        return Boolean.parseBoolean(Config.getInstance().getLocalProperty(ASK_ON_DRAG_COPY, "true"));
    }

    private int askAboutDragCopyNode() {
        int answer = ToggleDialog.showToggleConfirmDialog(GuiServiceCenter.getInstance().getMainWindow(), "Drag Copy Node", "<html>Do you want to copy the selected node? <br>This action is possibly destructive and can not be undone.", "Do not ask me again", 0);
        if (ToggleDialog.checkboxSelected && answer == 0) {
            Config.getInstance().setLocalProperty(ASK_ON_DRAG_COPY, "false");
        }
        return answer;
    }

    private boolean performFileImport(List<File> fileList, TreePath dropPath) {
        AbstractNavigatorNode dropPathNode = (AbstractNavigatorNode)dropPath.getLastPathComponent();
        boolean predictedSuccessfulImportOutcome = this.connectERENodeIfDisconnectedAndReturnStatus(dropPathNode);
        if (predictedSuccessfulImportOutcome) {
            File importFile = fileList.get(0);
            WizardView view = WizardFactory.createNavigatorImportWizard(GuiServiceCenter.getInstance().getMainWindow(), importFile, dropPathNode);
            view.run();
        }
        return predictedSuccessfulImportOutcome;
    }

    private boolean connectERENodeIfDisconnectedAndReturnStatus(AbstractNavigatorNode node) {
        boolean connected = true;
        if (node instanceof EreNode && !((EreNode)node).isConnected()) {
            node.performNodeAction();
            connected = ((EreNode)node).isConnected();
        } else if (node instanceof InternalEreNode && !((InternalEreNode)node).isConnected()) {
            node.performNodeAction();
            connected = ((InternalEreNode)node).isConnected();
        }
        return connected;
    }

    private List<File> extractFileList(String dropData) {
        ArrayList<File> fileList;
        block3: {
            String[] fileNames;
            block2: {
                String[] fileNames2;
                fileList = null;
                if (!dropData.matches("^/(.|\n)*")) break block2;
                fileList = new ArrayList<File>();
                for (String fileName : fileNames2 = dropData.split("\n")) {
                    fileList.add(new File(fileName));
                }
                break block3;
            }
            if (!dropData.matches("^(file:///)(.|(\r\n))*(\r\n)$")) break block3;
            fileList = new ArrayList();
            for (String fileName : fileNames = dropData.split("file://")) {
                if ("".equals(fileName)) continue;
                fileList.add(new File(fileName.substring(0, fileName.length() - 2)));
            }
        }
        return fileList;
    }

    private void performNodeCopy(AbstractNavigatorNode droppedNode, AbstractNavigatorNode pastePathNode) {
        boolean includeService = this.shouldIncludeServiceInDragAndDrop(droppedNode.getProxy(), pastePathNode.getProxy());
        WizardView wizardView = WizardFactory.createNavigatorDnDWizard(GuiServiceCenter.getInstance().getMainWindow(), droppedNode, pastePathNode, includeService);
        wizardView.run();
    }

    private boolean shouldIncludeServiceInDragAndDrop(AbstractEreProxy sourceProxy, AbstractEreProxy targetProxy) {
        boolean includeService;
        boolean bl = includeService = sourceProxy.getRatingManagerProxy() != targetProxy.getRatingManagerProxy();
        if (includeService && (!targetProxy.isServiceEditingAllowed() || "SDP".equals(targetProxy.getEreProxy().getType()))) {
            includeService = false;
        }
        return includeService;
    }

    @Override
    public boolean canDrop(TransferHandler.TransferSupport support) {
        Point dragPoint = support.getDropLocation().getDropPoint();
        JTree tree = (JTree)support.getComponent();
        boolean isExternalDrag = !support.isDataFlavorSupported(NavigatorNodeTransferable.NAVIGATOR_TREE_PATH_FLAVOR);
        TreePath pathNowUnderThePointer = tree.getPathForLocation(dragPoint.x, dragPoint.y);
        boolean isValidDropNode = false;
        if (pathNowUnderThePointer != null) {
            isValidDropNode = (isExternalDrag || this.supportsWithinTreeDrag(pathNowUnderThePointer.getLastPathComponent())) && this.canDropOnPath(pathNowUnderThePointer);
        }
        return isValidDropNode;
    }

    private boolean supportsWithinTreeDrag(Object comp) {
        return comp instanceof RatingPeriodNode || comp instanceof RatingPlanNode;
    }

    private boolean canDropOnPath(TreePath path) {
        boolean canDrop = false;
        if (path != null) {
            Object leaf = path.getLastPathComponent();
            canDrop = leaf instanceof AbstractNavigatorNode && !(leaf instanceof NavigatorNode);
        }
        return canDrop;
    }

    private boolean dropOnPathAllowed(TreePath path) {
        Object lastPathComp;
        boolean allowDrop = false;
        if (path != null && (lastPathComp = path.getLastPathComponent()) instanceof AbstractNavigatorNode) {
            AbstractNavigatorNode nodeToDropOn = (AbstractNavigatorNode)lastPathComp;
            allowDrop = this.canDropOnPath(path) && this.importFunctionIsOnForNode(nodeToDropOn);
        }
        return allowDrop;
    }

    private boolean importFunctionIsOnForNode(AbstractNavigatorNode nodeToDropOn) {
        AbstractEreProxy proxy = nodeToDropOn.getProxy();
        FunctionContext ctx = FunctionContext.build().withProxy(proxy).get();
        FunctionManager mgr = FunctionManagerImpl.getInstance();
        FunctionState testImpState = mgr.getStateForFunction(FunctionToken.IMPORT_ALLOWED, ctx);
        boolean canDrop = false;
        if (testImpState.getState() == FunctionState.State.OFF) {
            this.setMsg("Import not allowed...");
        } else {
            canDrop = true;
        }
        return canDrop;
    }

    private DefaultMutableTreeNode getSelectedNode(JTree tree) {
        TreePath selPath = tree.getSelectionPath();
        DefaultMutableTreeNode node = null;
        if (selPath != null) {
            node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
        }
        return node;
    }
}

