/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.actions;

import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.wizard.WizardFactory;
import com.ericsson.ere.gui.wizard.WizardView;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.StatusPanel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ImportAction
extends AbstractAction {
    NavigatorTree myTreeOwner = null;

    public ImportAction(NavigatorTree owner) {
        super("Import...");
        this.myTreeOwner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractNavigatorNode node = (AbstractNavigatorNode)this.myTreeOwner.getSelectedNode();
        AbstractEreProxy proxy = node.getProxy();
        FunctionContext ctx = FunctionContext.build().withProxy(proxy).get();
        FunctionManager mgr = FunctionManagerImpl.getInstance();
        FunctionState testImpState = mgr.getStateForFunction(FunctionToken.IMPORT_ALLOWED, ctx);
        if (testImpState.getState() == FunctionState.State.ON) {
            WizardView view = WizardFactory.createNavigatorImportWizard(GuiServiceCenter.getInstance().getMainWindow(), node);
            view.run();
        } else {
            this.setMsg("Import not allowed...");
        }
    }

    private void setMsg(final String msg) {
        EDT.runLater(new Runnable(){

            @Override
            public void run() {
                StatusPanel.getInstance().setStatusMsg(msg);
            }
        });
    }
}

