/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.distribute;

import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ActiveListProxy;
import com.ericsson.ere.proxy.ActiveSavedRatingPlanProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.SavedListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.progress.ProgressIndicator;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public abstract class AbstractEREDistributeTask {
    protected DistributionTaskStatus myAnalyzeStatus = DistributionTaskStatus.NONE;
    protected DistributionTaskStatus myPerformStatus = DistributionTaskStatus.NONE;
    protected EreProxy myTargetEREProxy;
    protected AbstractEreProxy mySource;
    protected Element mySourceStructure;
    protected String CONNECTOR_TYPE_CS40 = "SDP";

    public AbstractEREDistributeTask(EreProxy ere, AbstractEreProxy source, Element sourceStructure) {
        this.myTargetEREProxy = ere;
        this.mySource = source;
        this.mySourceStructure = sourceStructure;
    }

    public static String getDescription() {
        return "";
    }

    public static boolean performOnAssociatedERE() {
        return true;
    }

    public abstract void analyze(ProgressIndicator var1);

    public abstract void perform(ProgressIndicator var1);

    public DistributionTaskStatus getAnalyzeStatus() {
        return this.myAnalyzeStatus;
    }

    public DistributionTaskStatus getPerformStatus() {
        return this.myPerformStatus;
    }

    public EreProxy getEREProxy() {
        return this.myTargetEREProxy;
    }

    public abstract JPanel getAnalyzePanel();

    public abstract JPanel getPerformPanel();

    public static JPanel getInformationPanel(String header, String info) {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(new Color(238, 238, 238));
        JLabel infoLabel = new JLabel(info);
        infoLabel.setBackground(null);
        if (header != null) {
            JLabel headerLabel = new JLabel(header);
            headerLabel.setBackground(null);
            panel.add((Component)headerLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        panel.add((Component)infoLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    protected ServiceProxy getService(EreProxy destination, String serviceName) throws Exception {
        ServiceProxy serviceProxy = null;
        serviceProxy = destination.getRatingManagerProxy().getServiceListProxy().getServiceProxy(serviceName);
        if (serviceProxy == null) {
            throw new Exception("the service '" + serviceName + "' doesn't exist on " + destination + "!");
        }
        return serviceProxy;
    }

    protected ServiceProviderProxy getServiceProvider(EreProxy destination, String providerName) throws Exception {
        ServiceProviderProxy serviceProviderProxy = destination.getRatingManagerProxy().getServiceProviderListProxy().getServiceProvider(providerName);
        if (serviceProviderProxy == null) {
            throw new Exception("The Service Provider '" + providerName + "' doesn't exist on " + destination + "!");
        }
        return serviceProviderProxy;
    }

    protected RatingPlanProxy getPlan(EreProxy destination, String providerName, String planName) throws Exception {
        RatingPlanProxy ratingPlanProxy = this.getServiceProvider(destination, providerName).getRatingPlanProxy(planName);
        if (ratingPlanProxy == null) {
            throw new Exception("The Rating Plan '" + planName + "' doesn't exist under the Service Provider '" + providerName + "'!");
        }
        return ratingPlanProxy;
    }

    protected RatingPeriodProxy getPeriod(EreProxy destination, String providerName, String planName, String periodName, String startTime) throws Exception {
        return this.getPeriod(false, destination, providerName, planName, periodName, startTime);
    }

    protected RatingPeriodProxy getPeriodActiveOrSaved(EreProxy destination, String providerName, String planName, String periodName, String startTime) throws Exception {
        return this.getPeriod(true, destination, providerName, planName, periodName, startTime);
    }

    private RatingPeriodProxy getPeriod(boolean considerActive, EreProxy destination, String providerName, String planName, String periodName, String startTime) throws Exception {
        RatingPeriodProxy ratingPeriodProxy = null;
        RatingPlanProxy planProxy = this.getPlan(destination, providerName, planName);
        if (planProxy.hasActiveAndSavedPeriods() && planProxy instanceof ActiveSavedRatingPlanProxy) {
            SavedListProxy savedListProxy = ((ActiveSavedRatingPlanProxy)planProxy).getSavedListProxy();
            if (considerActive) {
                ActiveSavedRatingPlanProxy activeSavedPlanProxy = (ActiveSavedRatingPlanProxy)planProxy;
                ActiveListProxy activeListProxy = activeSavedPlanProxy.getActiveListProxy();
                ratingPeriodProxy = activeListProxy.getRatingPeriodProxy(periodName, startTime);
            }
            if (ratingPeriodProxy == null) {
                ratingPeriodProxy = savedListProxy.getRatingPeriodProxy(periodName, startTime);
            }
        } else {
            ratingPeriodProxy = planProxy.getRatingPeriodProxy(periodName, startTime);
        }
        if (ratingPeriodProxy == null) {
            throw new Exception("The Rating Period '" + periodName + "' doesn't exist under the Rating Plan '" + planName + "'!");
        }
        return ratingPeriodProxy;
    }

    protected boolean isDistributionAllowed() {
        FunctionContext ctx = FunctionContext.build().withProxy(this.myTargetEREProxy).get();
        FunctionState state = FunctionManagerImpl.getInstance().getStateForFunction(FunctionToken.DISTRIBUTION_TARGET, ctx);
        return state.getState() != FunctionState.State.OFF;
    }

    public static enum DistributionTaskStatus {
        NONE,
        READY,
        WARNING,
        IMPOSSIBLE,
        SUCCESS,
        FAILURE;

    }
}

