/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.distribute;

import com.ericsson.ere.gui.navigator.distribute.AbstractEREDistributeTask;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import ericsson.ere.progress.ProgressIndicator;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class DistributedDeActivateTask
extends AbstractEREDistributeTask {
    private JPanel myAnalyzePanel;
    private JPanel myPerformPanel;

    public DistributedDeActivateTask(EreProxy ere, AbstractEreProxy source, Element sourceStructure) {
        super(ere, source, sourceStructure);
    }

    @Override
    public void analyze(ProgressIndicator progress) {
        RatingPeriodProxy sourceProxy = (RatingPeriodProxy)this.mySource;
        try {
            if (!this.isDistributionAllowed()) {
                this.myAnalyzePanel = DistributedDeActivateTask.getInformationPanel(this.myTargetEREProxy + " does not allow distribution", "");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                return;
            }
            RatingPeriodProxy targetProxy = this.getPeriodActiveOrSaved(this.myTargetEREProxy, sourceProxy.getServiceProviderName(), sourceProxy.getRatingPlanName(), sourceProxy.getName(), sourceProxy.getRatingPeriodStartTime());
            if (!targetProxy.hasActiveOrSavedParentProxy()) {
                this.myAnalyzePanel = DistributedDeActivateTask.getInformationPanel(null, "Deactivation is not supported by this nodes connector");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                return;
            }
            if (targetProxy.isSelectedActive()) {
                this.myAnalyzePanel = DistributedDeActivateTask.getInformationPanel(null, "'" + targetProxy.getName() + "' was found on " + this.myTargetEREProxy + " and will be deactivated.");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
            } else {
                this.myAnalyzePanel = DistributedDeActivateTask.getInformationPanel(null, "'" + targetProxy.getName() + "' is not activated on " + this.myTargetEREProxy + ".");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
            }
        }
        catch (Exception e) {
            this.myAnalyzePanel = DistributedDeActivateTask.getInformationPanel("'" + sourceProxy.getName() + "' cannot be deactivated at " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
        }
    }

    @Override
    public void perform(ProgressIndicator progress) {
        RatingPeriodProxy sourceProxy = (RatingPeriodProxy)this.mySource;
        try {
            RatingPeriodProxy targetProxy = this.getPeriodActiveOrSaved(this.myTargetEREProxy, sourceProxy.getServiceProviderName(), sourceProxy.getRatingPlanName(), sourceProxy.getName(), sourceProxy.getRatingPeriodStartTime());
            if (!targetProxy.hasActiveOrSavedParentProxy()) {
                this.myPerformPanel = DistributedDeActivateTask.getInformationPanel(null, "Deactivation is not supported by this nodes connector");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                return;
            }
            if (targetProxy.isSelectedActive()) {
                targetProxy.deActivateRatingPeriod();
                this.myPerformPanel = DistributedDeActivateTask.getInformationPanel("'" + targetProxy + "' was succesfully deactivated at " + this.myTargetEREProxy, "");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.SUCCESS;
            } else {
                this.myPerformPanel = DistributedDeActivateTask.getInformationPanel(null, "'" + targetProxy.getName() + "' is not activated on " + this.myTargetEREProxy + ".");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
            }
        }
        catch (Exception e) {
            this.myPerformPanel = DistributedDeActivateTask.getInformationPanel("'" + sourceProxy.getName() + "' cannot be deactivated at " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
        }
    }

    @Override
    public JPanel getAnalyzePanel() {
        return this.myAnalyzePanel;
    }

    @Override
    public JPanel getPerformPanel() {
        return this.myPerformPanel;
    }

    public static String getDescription() {
        return "deactivate";
    }
}

