/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.distribute;

import com.ericsson.ere.gui.navigator.distribute.AbstractEREDistributeTask;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.progress.ProgressIndicator;
import javax.swing.JPanel;
import org.w3c.dom.Element;

public class DistributedDeleteServiceTask
extends AbstractEREDistributeTask {
    private JPanel myAnalyzePanel;
    private JPanel myPerformPanel;

    public DistributedDeleteServiceTask(EreProxy ere, AbstractEreProxy source, Element sourceStructure) {
        super(ere, source, sourceStructure);
    }

    @Override
    public void analyze(ProgressIndicator progress) {
        ServiceProxy sourceServiceProxy = (ServiceProxy)this.mySource;
        try {
            if (!this.isDistributionAllowed()) {
                this.myAnalyzePanel = DistributedDeleteServiceTask.getInformationPanel(this.myTargetEREProxy + " does not allow distribution", "");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                return;
            }
            ServiceProxy targetServiceProxy = this.getService(this.myTargetEREProxy, sourceServiceProxy.getName());
            if (targetServiceProxy.isServiceUsed()) {
                this.myAnalyzePanel = DistributedDeleteServiceTask.getInformationPanel(null, "'" + targetServiceProxy.getName() + "' is used by one or more Rating Plans and cannot be deleted.");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
            } else {
                this.myAnalyzePanel = DistributedDeleteServiceTask.getInformationPanel(null, "'" + targetServiceProxy.getName() + "' was found on " + this.myTargetEREProxy + " and will be deleted.");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
            }
        }
        catch (Exception e) {
            this.myAnalyzePanel = DistributedDeleteServiceTask.getInformationPanel("'" + sourceServiceProxy.getName() + "' cannot be deleted at " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
        }
    }

    @Override
    public void perform(ProgressIndicator progress) {
        ServiceProxy sourceServiceProxy = (ServiceProxy)this.mySource;
        try {
            ServiceProxy targetServiceProxy = this.getService(this.myTargetEREProxy, sourceServiceProxy.getName());
            if (targetServiceProxy.isServiceUsed()) {
                this.myPerformPanel = DistributedDeleteServiceTask.getInformationPanel(null, "'" + targetServiceProxy.getName() + "' is used by one or more Rating Plans and cannot be deleted.");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
            } else {
                this.myTargetEREProxy.getRatingManagerProxy().getServiceListProxy().deleteService(targetServiceProxy);
                this.myPerformPanel = DistributedDeleteServiceTask.getInformationPanel(null, "'" + targetServiceProxy.getName() + "' has been succesfully deleted from " + this.myTargetEREProxy + ".");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.SUCCESS;
            }
        }
        catch (Exception e) {
            this.myPerformPanel = DistributedDeleteServiceTask.getInformationPanel("'" + sourceServiceProxy.getName() + "' cannot be deleted at " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
        }
    }

    @Override
    public JPanel getAnalyzePanel() {
        return this.myAnalyzePanel;
    }

    @Override
    public JPanel getPerformPanel() {
        return this.myPerformPanel;
    }

    public static String getDescription() {
        return "delete";
    }
}

