/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.distribute;

import com.ericsson.ere.gui.navigator.distribute.AbstractEREDistributeTask;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.xml.XMLUtil;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DistributedSaveServiceTask
extends AbstractEREDistributeTask {
    private JPanel myAnalyzePanel;
    private JPanel myPerformPanel;

    public DistributedSaveServiceTask(EreProxy ere, AbstractEreProxy source, Element sourceStructure) {
        super(ere, source, sourceStructure);
    }

    @Override
    public void analyze(ProgressIndicator progress) {
        ServiceProxy sourceServiceProxy = (ServiceProxy)this.mySource;
        try {
            try {
                if (!this.isDistributionAllowed()) {
                    this.myAnalyzePanel = DistributedSaveServiceTask.getInformationPanel(this.myTargetEREProxy + " does not allow distribution", "");
                    this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
                    return;
                }
                this.getService(this.myTargetEREProxy, sourceServiceProxy.getName());
                this.myAnalyzePanel = DistributedSaveServiceTask.getInformationPanel("A service named '" + sourceServiceProxy.getName() + "' was found at " + this.myTargetEREProxy + ".", "If you go ahead, that service will be overwritten!");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.WARNING;
            }
            catch (Exception e) {
                this.myAnalyzePanel = DistributedSaveServiceTask.getInformationPanel(null, "'" + sourceServiceProxy.getName() + "' will be distributed to " + this.myTargetEREProxy + ".");
                this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.READY;
            }
        }
        catch (Exception e) {
            this.myAnalyzePanel = DistributedSaveServiceTask.getInformationPanel("'" + sourceServiceProxy.getName() + "' cannot be distributed to " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myAnalyzeStatus = AbstractEREDistributeTask.DistributionTaskStatus.IMPOSSIBLE;
        }
    }

    @Override
    public void perform(ProgressIndicator progress) {
        ServiceProxy sourceServiceProxy = (ServiceProxy)this.mySource;
        ServiceProxy targetServiceProxy = null;
        try {
            try {
                targetServiceProxy = this.getService(this.myTargetEREProxy, sourceServiceProxy.getName());
                if (this.mySourceStructure == null) {
                    this.mySourceStructure = sourceServiceProxy.getServiceXML();
                }
                NodeList children = this.mySourceStructure.getChildNodes();
                Element structureElement = XMLUtil.getNamedElement("ServiceDefinition", children);
                Element conditionElement = XMLUtil.getNamedElement("Settings", children);
                SettingsMap serviceSettings = (SettingsMap)sourceServiceProxy.getSettingsMap().clone();
                targetServiceProxy.updateService(structureElement, conditionElement, serviceSettings, true);
                this.myPerformPanel = DistributedSaveServiceTask.getInformationPanel(null, "'" + sourceServiceProxy.getName() + "' has been succesfully distributed to " + this.myTargetEREProxy + ".");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.SUCCESS;
            }
            catch (Exception e) {
                SettingsMap sourcePropertyMap = (SettingsMap)sourceServiceProxy.getSettingsMap().clone();
                Element definitionElement = sourceServiceProxy.getServiceDefinition();
                Element conditionElement = sourceServiceProxy.getServiceCondition();
                this.myTargetEREProxy.getRatingManagerProxy().getServiceListProxy().createService(sourcePropertyMap, definitionElement, conditionElement);
                this.myPerformPanel = DistributedSaveServiceTask.getInformationPanel(null, "'" + sourceServiceProxy.getName() + "' was sucessfully distributed to " + this.myTargetEREProxy + ".");
                this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.SUCCESS;
            }
        }
        catch (Exception e) {
            this.myPerformPanel = DistributedSaveServiceTask.getInformationPanel("'" + sourceServiceProxy.getName() + "' cannot be distributed to " + this.myTargetEREProxy + ",", "since " + e.getMessage());
            this.myPerformStatus = AbstractEREDistributeTask.DistributionTaskStatus.FAILURE;
        }
    }

    @Override
    public JPanel getAnalyzePanel() {
        return this.myAnalyzePanel;
    }

    @Override
    public JPanel getPerformPanel() {
        return this.myPerformPanel;
    }

    public static String getDescription() {
        return "distribute";
    }

    public static boolean performOnAssociatedERE() {
        return false;
    }
}

