/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodednd.panels;

import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.InformationPane;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressIndicatorHandler;
import ericsson.ere.progress.ProgressVisualizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;

public class DndProgressPanel
extends AbstractWizardPanel
implements ProgressVisualizer,
WizardStateView {
    private JScrollPane myJScrollPane = null;
    private InformationPane myAdditionalInfo = null;
    private JProgressBar myJProgressBar = null;

    public DndProgressPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.insets = new Insets(0, 12, 17, 12);
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 11, 12);
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(435, 357));
        this.add((Component)this.createJScrollPane(), gridBagConstraints);
        this.add((Component)this.createJProgressBar(), gridBagConstraints1);
    }

    public void handleDnDFailure(String message) {
        DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), "Drag and drop failed: ", message);
    }

    @Override
    public String getPanelDescription() {
        return "Copying selected node.";
    }

    @Override
    public String getPanelIdentifier() {
        return "ProgressPanel";
    }

    @Override
    public void wizardCanceled() {
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public void setConfirmBeforeExit() {
    }

    public void clearInfoText() {
        this.myAdditionalInfo.setText("");
    }

    @Override
    public void setInfoText(String text) {
        this.myAdditionalInfo.addInformation(text, Color.BLACK, 0);
    }

    @Override
    public void setProgressGoal(int goal) {
        this.myJProgressBar.setMinimum(0);
        this.myJProgressBar.setMaximum(goal);
    }

    @Override
    public void setValue(int value) {
        this.myJProgressBar.setValue(value);
    }

    @Override
    public void showAdditionalInfo(String text) {
        this.myAdditionalInfo.addInformation(text, Color.RED, 0);
    }

    public ProgressIndicator getProgressIndicator() {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(this);
        return handler.getProgressIndicator();
    }

    public ProgressIndicator getProgressIndicator(int goal) {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(goal, this);
        return handler.getProgressIndicator();
    }

    private JScrollPane createJScrollPane() {
        this.myJScrollPane = new JScrollPane();
        this.myAdditionalInfo = new InformationPane();
        this.myAdditionalInfo.setLineWrap(true);
        this.myJScrollPane.getViewport().add(this.myAdditionalInfo);
        return this.myJScrollPane;
    }

    private JProgressBar createJProgressBar() {
        this.myJProgressBar = new JProgressBar();
        this.myJProgressBar.setStringPainted(true);
        return this.myJProgressBar;
    }
}

