/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeexport;

import com.ericsson.ere.exportmanager.ExportContext;
import com.ericsson.ere.exportmanager.ExportFailedException;
import com.ericsson.ere.exportmanager.ExportManager;
import com.ericsson.ere.exportmanager.ExportManagerFactory;
import com.ericsson.ere.gui.navigator.nodeexport.states.ExportWizardFileState;
import com.ericsson.ere.gui.navigator.nodeexport.states.ExportWizardNodesState;
import com.ericsson.ere.gui.navigator.nodeexport.states.ExportWizardOptionsState;
import com.ericsson.ere.gui.navigator.nodeexport.states.ExportWizardProgressState;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.wizard.AbstractWizardModel;
import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class ExportWizardModel
extends AbstractWizardModel {
    private boolean myDefaultSelectAllTreeNodes = true;
    private Vector<DefaultMutableTreeNode> mySelectedNodes = new Vector();
    private boolean myDefaultExportRequiredService = false;
    private AbstractNavigatorNode mySourceNavigatorTreeNode = null;
    private ExportManager myExportManager = ExportManagerFactory.getExportManager(ExportManagerFactory.ExportType.NAVIGATOR_NODE_EXPORT);
    private File mySelectedTargetFile = null;

    public ExportWizardModel(AbstractNavigatorNode sourceNode) {
        this.mySourceNavigatorTreeNode = sourceNode;
        this.setUpButtonStates();
        this.setUpModelStates();
    }

    private final void setUpModelStates() {
        ExportWizardFileState fileState = new ExportWizardFileState(this);
        ExportWizardNodesState nodesState = new ExportWizardNodesState(this);
        ExportWizardOptionsState optionsState = new ExportWizardOptionsState(this);
        ExportWizardProgressState progressState = new ExportWizardProgressState(this);
        fileState.setAdjacentStates(null, nodesState);
        nodesState.setAdjacentStates(fileState, optionsState);
        optionsState.setAdjacentStates(nodesState, progressState);
        progressState.setAdjacentStates(optionsState, null);
        this.setCurrentState(fileState);
    }

    private final void setUpButtonStates() {
        this.setBackAndNextEnabled(false, false);
    }

    public File getSelectedTargetFile() {
        return this.mySelectedTargetFile;
    }

    public void setSelectedTargetFile(File targetFile) {
        this.mySelectedTargetFile = targetFile;
    }

    public void doExport(ExportContext context) throws ExportFailedException {
        this.myExportManager.doExport(context);
    }

    public boolean isExportRequiringService() {
        return this.myDefaultExportRequiredService;
    }

    public void setExportRequiringService(boolean isRequired) {
        this.myDefaultExportRequiredService = isRequired;
    }

    public boolean isSelectAllTreeNodes() {
        return this.myDefaultSelectAllTreeNodes;
    }

    public void setSelectAllTreeNodes(boolean isSelected) {
        this.myDefaultSelectAllTreeNodes = isSelected;
    }

    public void clearSelectedNodes() {
        this.mySelectedNodes.clear();
    }

    public void addAllNodesToSelectedNodes(List<DefaultMutableTreeNode> nodeList) {
        this.mySelectedNodes.addAll(nodeList);
    }

    public Vector<DefaultMutableTreeNode> getNodesSelected() {
        return this.mySelectedNodes;
    }

    public AbstractNavigatorNode getSourceNavigatorTreeNode() {
        return this.mySourceNavigatorTreeNode;
    }

    @Override
    public void cancelAllActions() {
    }

    @Override
    public void wizardDataChanged() {
    }
}

