/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeexport.panels;

import com.ericsson.ere.gui.navigator.nodeexport.ExportWizardModel;
import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.gui.wizard.selectabletree.SelectableNodeWrapper;
import com.ericsson.ere.gui.wizard.selectabletree.SelectableTreeModel;
import com.ericsson.ere.gui.wizard.selectabletree.SelectableTreeRenderer;
import ericsson.ere.defs.RmaDefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ExportNodesPanel
extends AbstractWizardPanel
implements WizardStateView {
    private ExportWizardModel myModel;
    private JScrollPane myJScrollPane = null;
    private JTree myJTree = null;
    private JButton mySelectAllButton = null;
    private JButton myClearAllButton = null;
    private SelectableTreeModel myExportTreeModel = null;

    public ExportNodesPanel(ExportWizardModel model) {
        this.myModel = model;
        SelectableNodeWrapper wrappedRoot = SelectableTreeModel.wrapExportableTree(this.myModel.getSourceNavigatorTreeNode());
        this.myExportTreeModel = new SelectableTreeModel(wrappedRoot);
        if (this.myModel.isSelectAllTreeNodes()) {
            this.myExportTreeModel.markAllForExport(true);
        }
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.insets = new Insets(11, 4, 0, 0);
        gridBagConstraints2.anchor = 16;
        gridBagConstraints2.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 16;
        gridBagConstraints1.insets = new Insets(17, 11, 0, 0);
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 11, 11, 11);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(401, 362));
        this.add((Component)this.createJScrollPane(), gridBagConstraints);
        this.add((Component)this.createSelectAllButton(), gridBagConstraints1);
        this.add((Component)this.createClearAllButton(), gridBagConstraints2);
    }

    @Override
    public String getPanelDescription() {
        return "Select the nodes that should be included in the export.";
    }

    private JScrollPane createJScrollPane() {
        this.myJScrollPane = new JScrollPane();
        this.myJScrollPane.setViewportView(this.createJTree());
        return this.myJScrollPane;
    }

    private JTree createJTree() {
        this.myJTree = new JTree(){

            @Override
            protected void setExpandedState(TreePath path, boolean state) {
                if (ExportNodesPanel.this.myJTree.getRowForPath(path) != 0) {
                    super.setExpandedState(path, state);
                }
            }
        };
        this.myJTree.setName("ExportNodePanel.JTree.NodeTree");
        this.myJTree.setModel(this.myExportTreeModel);
        this.myJTree.setCellRenderer(new SelectableTreeRenderer());
        this.myJTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = ExportNodesPanel.this.myJTree.getRowForLocation(e.getX(), e.getY());
                Object comp = ExportNodesPanel.this.myJTree.getLastSelectedPathComponent();
                if (row != -1 && comp instanceof SelectableNodeWrapper) {
                    ((SelectableNodeWrapper)comp).toggleMarkedForExport();
                    ExportNodesPanel.this.myJTree.repaint();
                    ExportNodesPanel.this.triggerObservers();
                }
            }
        });
        this.myJTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent k) {
                if (k.getKeyCode() != 32) {
                    return;
                }
                Object comp = ExportNodesPanel.this.myJTree.getLastSelectedPathComponent();
                if (comp instanceof SelectableNodeWrapper) {
                    ((SelectableNodeWrapper)comp).toggleMarkedForExport();
                    ExportNodesPanel.this.myJTree.repaint();
                    ExportNodesPanel.this.triggerObservers();
                }
            }
        });
        return this.myJTree;
    }

    @Override
    public String getPanelIdentifier() {
        return "NodesPanel";
    }

    private JButton createSelectAllButton() {
        this.mySelectAllButton = new JButton();
        this.mySelectAllButton.setToolTipText("Select all");
        this.mySelectAllButton.setPreferredSize(new Dimension(20, 20));
        this.mySelectAllButton.setMinimumSize(new Dimension(20, 20));
        this.mySelectAllButton.setIcon(RmaDefs.getImageIcon("MultiSelect16.gif"));
        this.mySelectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportNodesPanel.this.myExportTreeModel.markAllForExport(true);
                ExportNodesPanel.this.myJTree.repaint();
                ExportNodesPanel.this.triggerObservers();
            }
        });
        return this.mySelectAllButton;
    }

    private JButton createClearAllButton() {
        this.myClearAllButton = new JButton();
        this.myClearAllButton.setName("ExportNodesPanel.JButton.ClearAll");
        this.myClearAllButton.setToolTipText("Clear all");
        this.myClearAllButton.setPreferredSize(new Dimension(20, 20));
        this.myClearAllButton.setMinimumSize(new Dimension(20, 20));
        this.myClearAllButton.setIcon(RmaDefs.getImageIcon("MultiDeSelect16.gif"));
        this.myClearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportNodesPanel.this.myExportTreeModel.markAllForExport(false);
                ExportNodesPanel.this.myJTree.repaint();
                ExportNodesPanel.this.triggerObservers();
            }
        });
        return this.myClearAllButton;
    }

    @Override
    public void wizardCanceled() {
    }

    public boolean hasExportableSelection() {
        return this.myExportTreeModel.hasExportableSelection();
    }

    public Vector<DefaultMutableTreeNode> getAllNodesToExport() {
        return this.myExportTreeModel.getAllMarkedForExport();
    }
}

