/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport;

import com.ericsson.ere.gui.navigator.nodeimport.ElementTreeNode;
import com.ericsson.ere.gui.wizard.selectabletree.SelectableNodeWrapper;
import com.ericsson.ere.gui.wizard.selectabletree.SelectableTreeRenderer;
import ericsson.ere.defs.RmaDefs;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTree;

public class ImportTreeRenderer
extends SelectableTreeRenderer {
    ImageIcon navigatorRatingPlanOpen = RmaDefs.getImageIcon("navigator_open_ratingplan2.png");
    ImageIcon navigatorRatingPlanClosed = RmaDefs.getImageIcon("navigator_closed_ratingplan2.png");
    ImageIcon navigatorFolderClosed = RmaDefs.getImageIcon("navigator_folder.gif");
    ImageIcon navigatorFolderOpen = null;
    ImageIcon navigatorRatingPeriod = RmaDefs.getImageIcon("text_tree.png");
    ImageIcon navigatorService = RmaDefs.getImageIcon("navigator_service.png");
    ImageIcon navigatorServiceProviderOpen = RmaDefs.getImageIcon("navigator_open_folder.png");
    ImageIcon navigatorServiceProviderClosed = RmaDefs.getImageIcon("navigator_closed_folder.png");

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
        Component result = null;
        if (value instanceof SelectableNodeWrapper) {
            SelectableNodeWrapper tNodeWrapper = (SelectableNodeWrapper)value;
            if (tNodeWrapper.wrappedNode instanceof ElementTreeNode) {
                ElementTreeNode tElementNode = (ElementTreeNode)tNodeWrapper.wrappedNode;
                JLabel tLabel = new JLabel();
                if (tElementNode.elementType.equals("RatingPeriod")) {
                    tLabel.setIcon(this.navigatorRatingPeriod);
                } else if (tElementNode.elementType.equals("RatingPlan")) {
                    if (expanded) {
                        tLabel.setIcon(this.navigatorRatingPlanOpen);
                    } else {
                        tLabel.setIcon(this.navigatorRatingPlanClosed);
                    }
                } else if (tElementNode.elementType.equals("Service")) {
                    tLabel.setIcon(this.navigatorService);
                } else {
                    tLabel.setIcon(this.navigatorFolderClosed);
                }
                tLabel.setText(tElementNode.elementLabel);
                JCheckBox tBox = new JCheckBox();
                tBox.setSelected(((SelectableNodeWrapper)value).isMarkedForExport());
                tBox.setOpaque(false);
                tBox.setLayout(new GridBagLayout());
                tBox.add((Component)tLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
                result = tBox;
            }
        } else {
            result = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
        }
        return result;
    }
}

