/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport;

import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPlanNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceListNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceProviderListNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceProviderNode;
import com.ericsson.ere.gui.util.Version;
import com.ericsson.ere.migration.MigrationContext;
import ericsson.ere.gui.ratingrules.nodes.DOMUtil;
import ericsson.ere.management.Service;
import ericsson.ere.xml.EreXmlException;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ImportUtil {
    public static final String ERE_EXPORT_TAG = "EreExport";
    public static final String TARIFF_STRUCTURE_TAG = "TariffStructure";
    public static final String SERVICE_DEFINITION_TAG = "ServiceDefinition";

    private ImportUtil() {
    }

    public static Service getService(Vector<Service> serviceList, Element service) {
        for (Service existingService : serviceList) {
            if (!existingService.getId().equalsIgnoreCase(service.getAttribute("Name"))) continue;
            return existingService;
        }
        return null;
    }

    public static ServiceNode getServiceNode(Vector<ServiceNode> serviceList, String service) {
        for (ServiceNode serviceNode : serviceList) {
            if (!serviceNode.getName().equals(service)) continue;
            return serviceNode;
        }
        return null;
    }

    public static boolean serviceExists(Vector<Service> serviceList, String service) {
        for (Service existingService : serviceList) {
            if (!existingService.getId().equalsIgnoreCase(service)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEREExportStructure(Element element) {
        return element.getNodeName().equalsIgnoreCase(ERE_EXPORT_TAG);
    }

    public static String getNodeType(NavigatorNodeInterface baseNode) {
        String nodeType = "UNDEFINED";
        if (baseNode instanceof ServiceNode) {
            ServiceNode cfr_ignored_0 = (ServiceNode)baseNode;
            nodeType = "ServiceNode";
        } else if (baseNode instanceof ServiceListNode) {
            nodeType = ((ServiceListNode)baseNode).NODE_TYPE;
        } else if (baseNode instanceof RatingPeriodNode) {
            RatingPeriodNode cfr_ignored_1 = (RatingPeriodNode)baseNode;
            nodeType = "RatingPeriodNode";
        } else if (baseNode instanceof RatingPlanNode) {
            RatingPlanNode cfr_ignored_2 = (RatingPlanNode)baseNode;
            nodeType = "RatingPlanNode";
        } else if (baseNode instanceof ServiceProviderNode) {
            ServiceProviderNode cfr_ignored_3 = (ServiceProviderNode)baseNode;
            nodeType = "ServiceProviderNode";
        } else if (baseNode instanceof ServiceProviderListNode) {
            ServiceProviderListNode cfr_ignored_4 = (ServiceProviderListNode)baseNode;
            nodeType = "ServiceProviderListNode";
        }
        return nodeType;
    }

    public static Vector<Element> getServiceElements(Element element) {
        Vector<Element> serviceElements = new Vector<Element>();
        try {
            serviceElements.addAll(XMLUtil.getElementNodesNamed("Service", element.getChildNodes()));
            if (serviceElements.isEmpty()) {
                Element serviceList = XMLUtil.getFirstElementNamed("ServiceList", element);
                serviceElements.addAll(XMLUtil.getElementNodesNamed("Service", serviceList.getChildNodes()));
            }
        }
        catch (Exception e) {
            System.out.println("Could not find Service elements in the XML.");
        }
        return serviceElements;
    }

    public static String getServiceProviderName(Element element) {
        return element.getAttribute("Name");
    }

    public static Vector<Element> getServiceProviderList(Element importRootElement) {
        Vector<Element> serviceProviderElements = new Vector<Element>();
        try {
            serviceProviderElements.addAll(XMLUtil.getElementNodesNamed("ServiceProvider", importRootElement.getChildNodes()));
            if (serviceProviderElements.isEmpty()) {
                Element serviceProviderList = XMLUtil.getFirstElementNamed("ServiceProviderList", importRootElement);
                serviceProviderElements.addAll(XMLUtil.getElementNodesNamed("ServiceProvider", serviceProviderList.getChildNodes()));
            }
        }
        catch (Exception e) {
            System.out.println("- Could not find ServiceProvider elements in the XML.");
        }
        return serviceProviderElements;
    }

    public static Vector<Element> getRatingPlanList(Element element) {
        Vector<Element> ratingPlanElements = new Vector<Element>();
        try {
            ratingPlanElements.addAll(XMLUtil.getElementNodesNamed("RatingPlan", element.getChildNodes()));
        }
        catch (Exception e) {
            System.out.println("- Could not find RatingPlan elements in the XML.");
        }
        return ratingPlanElements;
    }

    public static Vector<Element> getRatingPeriodList(Element element) {
        Vector<Element> ratingPeriodElements = new Vector<Element>();
        try {
            List<Element> tempList;
            List<Element> nodeList = XMLUtil.getElementNodesNamed("RatingPeriod", element.getChildNodes());
            if (nodeList.isEmpty() && !(tempList = XMLUtil.getElementNodesNamed("RatingPlan", element.getChildNodes())).isEmpty()) {
                nodeList = XMLUtil.getElementNodesNamed("RatingPeriod", tempList.get(0).getChildNodes());
            }
            ratingPeriodElements.addAll(nodeList);
        }
        catch (Exception e) {
            System.out.println("- Could not find RatingPeriod elements in the XML.");
        }
        return ratingPeriodElements;
    }

    public static String getRatingPlanName(Element ratingPlan) {
        return ratingPlan.getAttribute("Name");
    }

    public static String getRatingPlanService(Element ratingPlan) {
        return ratingPlan.getAttribute("Service");
    }

    public static boolean containsOneValidTariffStructure(File file, String serviceId) throws IOException, ParserConfigurationException, SAXException {
        Document doc = XMLUtil.buildDocumentFromFile(file);
        return ImportUtil.containsOneValidTariffStructure(doc, serviceId);
    }

    public static boolean containsOneValidTariffStructure(Document doc, String serviceId) {
        boolean ret;
        if (serviceId == null) {
            throw new IllegalArgumentException("ServiceId must not be null");
        }
        Element root = doc.getDocumentElement();
        if (TARIFF_STRUCTURE_TAG.equals(root.getNodeName())) {
            String attr = root.getAttribute("ServiceId");
            ret = serviceId.equals(attr);
        } else {
            NodeList serviceNodes = doc.getElementsByTagName("Service");
            NodeList serviceListNodes = doc.getElementsByTagName("ServiceList");
            NodeList tsNodes = doc.getElementsByTagName(TARIFF_STRUCTURE_TAG);
            if (serviceNodes.getLength() > 0 || serviceListNodes.getLength() > 0 || tsNodes.getLength() != 1) {
                ret = false;
            } else {
                root = (Element)tsNodes.item(0);
                String attr = root.getAttribute("ServiceId");
                ret = serviceId.equals(attr);
            }
        }
        return ret;
    }

    private static boolean containExactlyOneServiceElement(Document doc) {
        boolean containsOneServiceElement = false;
        NodeList services = doc.getElementsByTagName("Service");
        if (services != null && services.getLength() == 1) {
            containsOneServiceElement = true;
        }
        return containsOneServiceElement;
    }

    public static boolean containOneServiceElement(Document doc) {
        Element serviceElement;
        boolean serviceNoParent = false;
        if (ImportUtil.containExactlyOneServiceElement(doc)) {
            serviceElement = (Element)doc.getElementsByTagName("Service").item(0);
            boolean bl = serviceNoParent = !"ServiceList".equalsIgnoreCase(serviceElement.getParentNode().getNodeName());
        }
        if (ImportUtil.containsSingleServiceDefinition(doc)) {
            serviceElement = (Element)doc.getElementsByTagName(SERVICE_DEFINITION_TAG).item(0);
            serviceNoParent = !"ServiceList".equalsIgnoreCase(serviceElement.getParentNode().getNodeName());
        }
        return serviceNoParent;
    }

    public static boolean containsFloatingServiceElement(Document doc) {
        boolean floatingElementFound = false;
        NodeList serviceNodes = doc.getElementsByTagName("Service");
        NodeList serviceListNodes = doc.getElementsByTagName("ServiceList");
        if (serviceNodes != null && serviceListNodes != null && serviceListNodes.getLength() > 0) {
            for (int i = 0; i < serviceNodes.getLength(); ++i) {
                Node node = serviceNodes.item(i);
                if ("ServiceList".equalsIgnoreCase(node.getParentNode().getNodeName())) continue;
                floatingElementFound = true;
                break;
            }
        }
        return floatingElementFound;
    }

    public static boolean containsSingleOrFloatingServiceElements(Document doc) {
        return ImportUtil.containOneServiceElement(doc) || ImportUtil.containsFloatingServiceElement(doc);
    }

    public static List<Node> getFlotingServiceElements(Document doc) throws EreXmlException {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList list = doc.getElementsByTagName("Service");
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if ("ServiceList".equalsIgnoreCase(node.getParentNode().getNodeName())) continue;
                result.add(node);
            }
        }
        return result;
    }

    public static String getAttributeValueFromXml(String tagName, String attribute, Document doc) {
        String value = null;
        NodeList list = doc.getElementsByTagName(tagName);
        if (list != null && list.getLength() != 0) {
            Element node = (Element)list.item(0);
            value = "".equals(node.getAttribute(attribute)) ? null : node.getAttribute(attribute);
        }
        return value;
    }

    public static String getFirstExistingAttributeValue(String tagName, String attribute, Document doc) {
        String value = null;
        NodeList list = doc.getElementsByTagName(tagName);
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Element node = (Element)list.item(i);
                String string = value = node.getAttribute(attribute) != "" ? node.getAttribute(attribute) : null;
                if (value != null) break;
            }
        }
        return value;
    }

    public static MigrationContext createContextForServiceDefinitionImport(Document doc) {
        String service = ImportUtil.getAttributeValueFromXml(SERVICE_DEFINITION_TAG, "Service", doc);
        if (service == null) {
            throw new IllegalArgumentException("No service definition found, or missing Service attribute.");
        }
        MigrationContext.MigrationContextBuilder ctxBuilder = new MigrationContext.MigrationContextBuilder();
        ctxBuilder.serviceProviderName("N/A");
        ctxBuilder.ratingPeriodName("N/A");
        ctxBuilder.ratingPeriodStartTime("99990101T000000000");
        ctxBuilder.ratingPlanName("N/A");
        ctxBuilder.ratingStructureFile("");
        ctxBuilder.serviceName(service);
        MigrationContext resultContext = ctxBuilder.build();
        return resultContext;
    }

    public static boolean containsSingleServiceDefinition(Document doc) {
        Element rootNode = doc.getDocumentElement();
        if (SERVICE_DEFINITION_TAG.equalsIgnoreCase(rootNode.getNodeName())) {
            return true;
        }
        NodeList allNodes = rootNode.getElementsByTagName("*");
        NodeList serviceDefNodes = doc.getElementsByTagName(SERVICE_DEFINITION_TAG);
        return allNodes.getLength() == 1 && serviceDefNodes != null && serviceDefNodes.getLength() == 1;
    }

    public static void addVersionElement(Element structureRootElement) {
        if (structureRootElement == null || structureRootElement.getNodeName() != TARIFF_STRUCTURE_TAG) {
            throw new IllegalArgumentException("The structure root must be a TariffStructure element");
        }
        Element versionElement = XMLUtil.getNamedElement("Version", structureRootElement.getChildNodes());
        if (versionElement != null) {
            throw new IllegalArgumentException("The structure root already has a child Version tag");
        }
        Element theSavedElement = XMLUtil.getNamedElement("Saved", structureRootElement.getChildNodes());
        Node theElementAfter = null;
        if (theSavedElement != null) {
            for (theElementAfter = theSavedElement.getNextSibling(); theElementAfter != null && theElementAfter.getNodeType() != 1; theElementAfter = theElementAfter.getNextSibling()) {
            }
        }
        Version version = new Version((Version.VersionUpdateListener)null);
        Element newVersionElement = null;
        try {
            newVersionElement = version.getVersionElement();
        }
        catch (Exception ex) {
            new AssertionError((Object)"This indicates an error in the Version class");
        }
        DOMUtil.adoptNode(structureRootElement.getOwnerDocument(), newVersionElement);
        if (theElementAfter != null) {
            structureRootElement.insertBefore(newVersionElement, theElementAfter);
        } else {
            structureRootElement.appendChild(newVersionElement);
        }
    }

    public static boolean hasValidRootTag(Document doc) {
        boolean result = true;
        if (!(ImportUtil.hasRootTag(doc, ERE_EXPORT_TAG) || ImportUtil.hasRootTag(doc, TARIFF_STRUCTURE_TAG) || ImportUtil.hasRootTag(doc, SERVICE_DEFINITION_TAG))) {
            result = false;
        }
        return result;
    }

    private static boolean hasRootTag(Document doc, String tag) {
        Element root = doc.getDocumentElement();
        return tag.equalsIgnoreCase(root.getNodeName());
    }
}

