/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport.states;

import com.ericsson.ere.gui.navigator.nodeimport.ElementTreeNode;
import com.ericsson.ere.gui.navigator.nodeimport.ImportWizardModel;
import com.ericsson.ere.gui.navigator.nodeimport.ProxiedNavigatorTreeImporter;
import com.ericsson.ere.gui.navigator.nodeimport.panels.ImportProgressPanel;
import com.ericsson.ere.gui.wizard.AbstractWizardState;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.util.NodeListIterable;
import java.util.ArrayList;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ImportWizardProgressState
extends AbstractWizardState {
    private ImportProgressPanel myPanel;
    private SwingWorker<Void, Void> myImportWorker;

    public ImportWizardProgressState(ImportWizardModel model) {
        super(model);
        this.createPanel();
    }

    private void createPanel() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardProgressState.this.myPanel = new ImportProgressPanel();
            }
        });
    }

    @Override
    public void activate() {
        final ImportProgressPanel visualizer = this.myPanel;
        this.myModel.setStopNavigationButtonMode();
        this.setInfoTextInPanel("");
        this.myImportWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                ImportWizardProgressState.this.recPruneXMLTree(((ImportWizardModel)ImportWizardProgressState.this.myModel).getRootElement());
                ProxiedNavigatorTreeImporter importer = new ProxiedNavigatorTreeImporter(visualizer);
                if (this.isCancelled()) {
                    return null;
                }
                importer.importXML(((ImportWizardModel)ImportWizardProgressState.this.myModel).getRootElement(), ((ImportWizardModel)ImportWizardProgressState.this.myModel).getTargetNode(), ((ImportWizardModel)ImportWizardProgressState.this.myModel).getNodesSelected().size());
                return null;
            }

            @Override
            protected void done() {
                ImportWizardProgressState.this.myModel.setFinishedNavigationButtonMode();
            }
        };
        this.myImportWorker.execute();
    }

    @Override
    public WizardStateView getPanel() {
        return this.myPanel;
    }

    @Override
    public void cancelStateActions() {
        if (this.myImportWorker != null) {
            this.myImportWorker.cancel(true);
        }
    }

    private boolean recPruneXMLTree(Element currentElement) {
        boolean currentElementExists = false;
        ElementTreeNode tNode = null;
        for (DefaultMutableTreeNode node : ((ImportWizardModel)this.myModel).getNodesSelected()) {
            tNode = (ElementTreeNode)node;
            if (tNode.wrappedElement != currentElement) continue;
            currentElementExists = true;
            break;
        }
        if (currentElementExists) {
            boolean isLeaf;
            boolean bl = isLeaf = "RatingPeriod".equals(currentElement.getNodeName()) || "Service".equals(currentElement.getNodeName());
            if (!isLeaf) {
                ArrayList<Element> toRemove = new ArrayList<Element>();
                for (Node child : new NodeListIterable(currentElement.getChildNodes(), 1)) {
                    Element tElement = (Element)child;
                    if (!this.recPruneXMLTree(tElement)) continue;
                    toRemove.add(tElement);
                }
                for (Element e : toRemove) {
                    currentElement.removeChild(e);
                }
            }
            return false;
        }
        return true;
    }

    private void setInfoTextInPanel(final String text) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ImportWizardProgressState.this.myPanel.setInfoText(text);
            }
        });
    }
}

