/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodes;

import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.DeletableNode;
import com.ericsson.ere.gui.navigator.nodes.task.OpenRatingPeriodTask;
import com.ericsson.ere.gui.navigator.nodes.visitor.Visitor;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.management.DateUtil;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RatingPeriodNode
extends AbstractNavigatorNode
implements Comparable<RatingPeriodNode>,
DeletableNode {
    public static final String LBL_SERVICEPROVIDER = "Service provider";
    public static final String LBL_RATINGPLAN = "Ratingplan";
    public static final String LBL_SERVICE = "Service";
    public static final String LBL_NAME = "Name";
    public static final String LBL_START_DATE = "Start date";
    public static final String ICON = "text_tree.png";
    public static final String NODE_TYPE = "RatingPeriodNode";
    protected boolean isImport = false;
    private RatingPeriodProxy myRatingPeriodProxy = null;
    public static final int IMPORT_SUCCESS = 0;
    public static final int IMPORT_STOP = 2;

    public RatingPeriodNode(RatingPeriodProxy periodProxy) {
        this.myRatingPeriodProxy = periodProxy;
    }

    public String getServiceProviderName() {
        return this.myRatingPeriodProxy.getServiceProviderName();
    }

    public String getRatingPlanName() {
        return this.myRatingPeriodProxy.getRatingPlanName();
    }

    public String getServiceName() {
        return this.myRatingPeriodProxy.getServiceName();
    }

    public String getRatingPeriodName() {
        return this.myRatingPeriodProxy.getName();
    }

    public String getRatingPeriodFileRef() {
        return this.myRatingPeriodProxy.getRatingStructureFileRef();
    }

    public String getRatingPeriodStartTime() {
        Time timeObject = this.myRatingPeriodProxy.getRatingPeriodTime();
        if (timeObject != null) {
            return timeObject.getString();
        }
        return "";
    }

    public String getRatingPeriodFormattedStartTime() {
        return DateUtil.format(this.myRatingPeriodProxy.getRatingPeriodTime(), 2);
    }

    @Override
    public String toString() {
        String startTime = this.getRatingPeriodFormattedStartTime().trim();
        return this.getRatingPeriodName() + (startTime.length() > 0 ? " (" + startTime + ")" : "");
    }

    @Override
    public void performNodeAction() {
        OpenRatingPeriodTask pt = new OpenRatingPeriodTask(this.getPathForNode(this), this.myRatingPeriodProxy);
        pt.openRatingPeriod();
    }

    @Override
    public void cancel() {
        if (this.isNew && (DefaultMutableTreeNode)this.getParent() != null) {
            DefaultMutableTreeNode nextNode = this.getNextSibling();
            if (nextNode == null && (nextNode = this.getPreviousSibling()) == null) {
                nextNode = (DefaultMutableTreeNode)this.getParent();
            }
            ((DefaultMutableTreeNode)this.getParent()).remove(this);
            if (this.myOwner != null) {
                this.myOwner.setSelectionPath(new TreePath(nextNode.getPath()));
            }
        }
    }

    @Override
    public String getTitle() {
        return this.toString();
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        return RmaDefs.getImageIcon(ICON);
    }

    @Override
    public String getNodeToolTip() {
        String toolTip = "RatingPeriod : <b>" + this.getRatingPeriodName() + "</b>";
        if (this.isStartTimeUsed()) {
            toolTip = toolTip + "\n" + LBL_START_DATE + " : " + this.getRatingPeriodFormattedStartTime();
        }
        if (this.getRatingPeriodFileRef() != null && !this.getRatingPeriodFileRef().isEmpty()) {
            toolTip = toolTip + "\n" + "Selection Tree file" + " : " + this.getRatingPeriodFileRef() + "\n";
        }
        return toolTip;
    }

    private boolean isStartTimeUsed() {
        return this.myRatingPeriodProxy.isStartTimeUsed();
    }

    @Override
    public int compareTo(RatingPeriodNode rpNode) {
        return this.getRatingPeriodStartTime().compareTo(rpNode.getRatingPeriodStartTime());
    }

    private TreePath getPathForNode(DefaultMutableTreeNode node) {
        ArrayList<TreeNode> pathToNode = new ArrayList<TreeNode>();
        pathToNode.add(node);
        for (TreeNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
            pathToNode.add(0, parent);
        }
        TreePath nodePath = new TreePath(pathToNode.toArray());
        return nodePath;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public AbstractEreProxy getProxy() {
        return this.myRatingPeriodProxy;
    }
}

