/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodes;

import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.DeletableNode;
import com.ericsson.ere.gui.navigator.nodes.task.OpenServiceTask;
import com.ericsson.ere.gui.navigator.nodes.visitor.Visitable;
import com.ericsson.ere.gui.navigator.nodes.visitor.Visitor;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class ServiceNode
extends AbstractNavigatorNode
implements Visitable,
DeletableNode {
    public static final String ICON = "navigator_service.png";
    private ServiceProxy myServiceProxy = null;
    public static final String NODE_TYPE = "ServiceNode";
    public static final String TAG_SERVICEDEFINITION = "ServiceDefinition";
    public static final String TAG_SETTING = "Settings";

    public ServiceNode(ServiceProxy serviceProxy) {
        this.isNew = false;
        this.myServiceProxy = serviceProxy;
    }

    public String getXML() {
        return "<Service" + ServiceNode.createAttribute("Name", this.getName()) + ServiceNode.createAttribute("DefinitionFile", this.getDefinitionFileRef()) + ServiceNode.createAttribute("ConditionLeafClassFile", this.getConditionFileRef()) + "/>";
    }

    public String getName() {
        return this.myServiceProxy.getName();
    }

    public String getDefinitionFileRef() {
        return this.myServiceProxy.getServiceDefinitionFileName();
    }

    public String getConditionFileRef() {
        return this.myServiceProxy.getServiceConditionFileName();
    }

    @Override
    public String toString() {
        return this.myServiceProxy.getName();
    }

    @Override
    public void performNodeAction() {
        OpenServiceTask pt = new OpenServiceTask(this.myServiceProxy);
        pt.openService();
    }

    @Override
    public void cancel() {
        if (this.isNew && (DefaultMutableTreeNode)this.getParent() != null) {
            ((DefaultMutableTreeNode)this.getParent()).remove(this);
        }
    }

    @Override
    public void newNode(String type) {
        if (type.equals(NODE_TYPE)) {
            ServiceNode newNode = new ServiceNode(this.myServiceProxy);
            DefaultMutableTreeNode aParent = (DefaultMutableTreeNode)this.getParent();
            aParent.insert(newNode, aParent.getIndex(this) + 1);
        }
    }

    @Override
    public String getTitle() {
        return this.toString();
    }

    @Override
    public void deleteNode() {
        try {
            this.myServiceProxy.getRatingManagerProxy().getServiceListProxy().deleteService(this.myServiceProxy);
            ((DefaultMutableTreeNode)this.getParent()).remove(this);
        }
        catch (Exception e) {
            String msg = "Can not delete the selected service '" + this.getName() + "'\nReason : " + e.getMessage();
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Problem deleting Service " + this.getName(), msg);
        }
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        return RmaDefs.getImageIcon(ICON);
    }

    @Override
    public String getNodeToolTip() {
        return "Service : <b>" + this.getName() + "</b>\n" + "Service definition file" + " : " + this.getDefinitionFileRef() + "\n" + "Service condition file" + " : " + this.getConditionFileRef();
    }

    public void createFileRef(VarTableModel model) {
        String serviceName = VarListUtil.getValueStringForName(model.getData(), "Name");
        String definitionRef = ServiceNode.fixFileName(serviceName) + "_Definition";
        String conditionRef = ServiceNode.fixFileName(serviceName) + "_Condition";
        Variable definitionRefVar = VarListUtil.getVariableForName(model.getData(), "Service definition file");
        Variable conditionRefVar = VarListUtil.getVariableForName(model.getData(), "Service condition file");
        definitionRefVar.setValue(definitionRef);
        conditionRefVar.setValue(conditionRef);
    }

    private static String fixFileName(String str) {
        return str.replace(' ', '_');
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public AbstractEreProxy getProxy() {
        return this.myServiceProxy;
    }
}

