/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodes;

import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.DeletableNode;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import ericsson.ere.defs.RmaDefs;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class ServiceProviderNode
extends AbstractNavigatorNode
implements DeletableNode {
    public static final String ICON_EXPANDED = "navigator_open_folder.png";
    public static final String ICON = "navigator_closed_folder.png";
    public static final String NODE_TYPE = "ServiceProviderNode";
    private ServiceProviderProxy myServiceProviderProxy = null;

    public ServiceProviderNode(ServiceProviderProxy spProxy) {
        this.myServiceProviderProxy = spProxy;
    }

    public String getServiceProviderName() {
        return this.myServiceProviderProxy.getName();
    }

    @Override
    public String toString() {
        return this.getServiceProviderName();
    }

    @Override
    public void cancel() {
        if (this.isNew && (DefaultMutableTreeNode)this.getParent() != null) {
            ((DefaultMutableTreeNode)this.getParent()).remove(this);
        }
    }

    @Override
    public String getTitle() {
        return this.toString();
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        if (expanded) {
            return RmaDefs.getImageIcon(ICON_EXPANDED);
        }
        return RmaDefs.getImageIcon(ICON);
    }

    @Override
    public String getNodeToolTip() {
        if (this.myServiceProviderProxy.getProperty("ServiceProvider.name") != null) {
            return this.myServiceProviderProxy.getProperty("ServiceProvider.name") + " : <b>" + this.getServiceProviderName() + "</b>";
        }
        return "Service provider : <b>" + this.getServiceProviderName() + "</b>";
    }

    @Override
    public AbstractEreProxy getProxy() {
        return this.myServiceProviderProxy;
    }
}

