/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.popupmenus;

import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.NavigatorTreeUtil;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.ActiveListNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPlanNode;
import com.ericsson.ere.gui.navigator.nodes.SavedListNode;
import com.ericsson.ere.gui.navigator.popupmenus.RatingPopupMenu;
import com.ericsson.ere.proxy.EreProxyManager;
import ericsson.ere.integration.connector.http.ActiveSavedMenuBuilder;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class ActiveSavedPopupMenu
extends RatingPopupMenu {
    private JMenuItem deActivateMenu = new JMenuItem(ActiveSavedMenuBuilder.deactivateAction);
    private JMenuItem activateMenu;
    private JMenuItem distributedActivateMenu;
    private JMenuItem distributedDeActivateMenu;

    public ActiveSavedPopupMenu(NavigatorTree owner) {
        super(owner);
        this.deActivateMenu.setName("ActiveSavedPopupMenu.MenuItem.Deactivate");
        this.activateMenu = new JMenuItem(ActiveSavedMenuBuilder.activateAction);
        this.activateMenu.setName("ActiveSavedPopupMenu.MenuItem.Activate");
        this.distributedActivateMenu = new JMenuItem(ActiveSavedMenuBuilder.distributedActivateAction);
        this.distributedActivateMenu.setName("ActiveSavedPopupMenu.MenuItem.DistributedActivate");
        this.distributedDeActivateMenu = new JMenuItem(ActiveSavedMenuBuilder.distributedDeActivateAction);
        this.distributedDeActivateMenu.setName("ActiveSavedPopupMenu.MenuItem.DistributedDeactivate");
    }

    @Override
    public void enableActions() {
        super.enableActions();
        DefaultMutableTreeNode tmpTreeNode = this.myOwner.getSelectedNode();
        if (tmpTreeNode instanceof RatingPeriodNode) {
            ActiveSavedMenuBuilder.deactivateAction.setEnabled(true);
            ActiveSavedMenuBuilder.activateAction.setEnabled(true);
            if (tmpTreeNode.getParent() instanceof SavedListNode) {
                NavigatorTree.deleteAction.setEnabled(true);
                NavigatorTree.distributedDeleteAction.setEnabled(true);
                ActiveSavedMenuBuilder.distributedActivateAction.setEnabled(true);
            } else if (tmpTreeNode.getParent() instanceof ActiveListNode) {
                NavigatorTree.deleteAction.setEnabled(false);
                NavigatorTree.distributedDeleteAction.setEnabled(false);
                NavigatorTree.newRatingPeriodAction.setEnabled(false);
                ActiveSavedMenuBuilder.distributedDeActivateAction.setEnabled(true);
            }
        } else if (tmpTreeNode instanceof RatingPlanNode) {
            NavigatorTree.newRatingPeriodAction.setEnabled(false);
            NavigatorTree.deleteAction.setEnabled(false);
            NavigatorTree.exportAction.setEnabled(false);
            NavigatorTree.importAction.setEnabled(false);
        }
        int ereCount = 0;
        if (EreProxyManager.getInstance().getInternalEreProxy() != null) {
            ++ereCount;
        }
        if ((ereCount += EreProxyManager.getInstance().getRemoteEreList().size()) <= 1) {
            ActiveSavedMenuBuilder.distributedActivateAction.setEnabled(false);
            ActiveSavedMenuBuilder.distributedDeActivateAction.setEnabled(false);
        }
    }

    @Override
    public void enablePopupMenu() {
        super.enablePopupMenu();
        DefaultMutableTreeNode tmpTreeNode = this.myOwner.getSelectedNode();
        if (tmpTreeNode instanceof ActiveListNode) {
            this.menuForActiveListNode(tmpTreeNode);
        } else if (tmpTreeNode instanceof SavedListNode) {
            this.menuForSavedListNode(tmpTreeNode);
        }
    }

    @Override
    protected void menuForRatingPlan(TreeNode treeNode) {
        this.removeAll();
    }

    @Override
    protected void menuForRatingPeriod(TreeNode parentNode) {
        this.removeAll();
        this.addNewRatingPeriodMenuIfAllowed();
        if (parentNode instanceof SavedListNode) {
            this.addActivateMenu();
            this.addSeparator();
            this.addDeleteRatingPeriodMenuIfAllowed();
        } else {
            this.addDeActivateMenuIfAllowed();
            this.addSeparator();
        }
        this.addEditRatingPeriodMenuIfAllowed();
        this.addImportMenu();
        this.addExportMenu();
        this.addDistributeMenu();
        if (parentNode instanceof SavedListNode) {
            this.addMultiDataUpdateMenuIfAllowed();
        }
        this.addSeparator();
        this.addCompareToMenu();
        this.addPropertiesMenuIfAllowed();
    }

    private void addActivateMenu() {
        this.activateMenu.setVisible(true);
        this.distributedActivateMenu.setVisible(true);
        JMenu activateSubMenu = new JMenu("Activate");
        activateSubMenu.add(this.activateMenu);
        activateSubMenu.add(this.distributedActivateMenu);
        myPopupMenu.add(activateSubMenu);
    }

    private void addDeActivateMenuIfAllowed() {
        JMenu deActivateSubMenu = new JMenu("DeActivate");
        deActivateSubMenu.setName("ActiveSavedPopupMenu.MenuItem.DeactivateSubMenu");
        AbstractNavigatorNode node = (AbstractNavigatorNode)this.myOwner.getSelectedNode();
        if (node != null && !NavigatorTreeUtil.nodeIsInEditState(node.getProxy())) {
            this.deActivateMenu.setVisible(true);
            this.distributedDeActivateMenu.setVisible(true);
            deActivateSubMenu.add(this.deActivateMenu);
            deActivateSubMenu.add(this.distributedDeActivateMenu);
        } else {
            deActivateSubMenu.setEnabled(false);
        }
        myPopupMenu.add(deActivateSubMenu);
    }
}

