/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.sdp;

import com.ericsson.ere.gui.editors.propertyeditor.DefaultNavigatorNodeProperties;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.documents.NumbersOnlyDocument;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;

public class SDPNavigatorNodeProperties
extends DefaultNavigatorNodeProperties {
    private boolean ignoreLabel(String labelToIgnore) {
        if (labelToIgnore.equals("Service provider")) {
            return true;
        }
        if (this.getServiceName() != null && "AccountManagement".equals(this.getServiceName()) && labelToIgnore.equals("Start date")) {
            return true;
        }
        return labelToIgnore.equals("Selection Tree file");
    }

    private void checkVariable(Variable variable) {
        if (variable instanceof StringVariable && "Ratingplan".equals(variable.getLabel())) {
            int maxId = 99;
            if (this.getServiceName() != null && "UssdTextMessage".equals(this.getServiceName())) {
                maxId = 199;
            }
            ((StringVariable)variable).setModel(new NumbersOnlyDocument(0L, maxId));
        }
        if (variable instanceof DropDownVariable && "Service".equals(variable.getLabel())) {
            variable.setAllowEdit(false);
        }
        if (this.getServiceName() != null && "NumberNormalization".equals(this.getServiceName()) && variable.getLabel().equals("Ratingplan")) {
            variable.setValue("0");
            variable.setAllowEdit(false);
        }
    }

    @Override
    protected void set(String label, String value, boolean allowEdit) {
        Variable variable = VarListUtil.getVariableForName(this.getData(), label);
        if (variable == null) {
            variable = new StringVariable(label, value);
            variable.setAllowEdit(allowEdit);
            this.checkVariable(variable);
            this.addRow(variable);
        } else {
            variable.setValue(value);
        }
    }

    @Override
    public VarTableModel getVarTableModel() {
        return this;
    }

    @Override
    public void insertRowAt(Variable variable, int index) {
        this.checkVariable(variable);
        if (this.ignoreLabel(variable.getLabel())) {
            return;
        }
        super.insertRowAt(variable, index);
    }

    @Override
    public void addRow(Variable variable) {
        this.checkVariable(variable);
        if (this.ignoreLabel(variable.getLabel())) {
            return;
        }
        super.addRow(variable);
    }

    @Override
    public String getServiceProviderName() {
        return this.getServiceName();
    }

    @Override
    public void setServiceProviderName(String serviceProviderName, boolean allowEdit) {
        this.setServiceName(serviceProviderName, allowEdit);
    }

    @Override
    public VarTableModel getCompleteRatingPeriodVarTableModel() {
        VarTableModel model = new VarTableModel();
        for (Variable var : this.getData()) {
            model.addRow(var);
        }
        model.addRow(new StringVariable("Service provider", this.getServiceProviderName()));
        return model;
    }

    @Override
    public void setRatingPeriodFileRef(String fileRef, boolean allowEdit) {
    }

    @Override
    public String getRatingPeriodStartTime() {
        String retStr = this.get("Start date");
        if (retStr == null) {
            return "";
        }
        return retStr;
    }
}

