/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.ratingrules;

import ericsson.ere.gui.ratingrules.RatingRuleFrame;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public final class SelectionTreeUtil {
    private static final String PROP_CANCEL_BATCH_EXPAND = "BatchExpand.cancel";

    private SelectionTreeUtil() {
    }

    public static void selectAndMakeVisible(JTree tree, TreePath path) {
        tree.setSelectionPath(path);
        tree.scrollPathToVisible(path);
    }

    public static RatingRuleFrame getRatingRuleFrame(JTree tree) {
        return GuiUtil.getClosestParentOfClass(tree, RatingRuleFrame.class);
    }

    public static TreePath[] arrangePaths(TreePath[] paths) {
        int i;
        if (paths == null) {
            return null;
        }
        ArrayList<TreePath> thePaths = new ArrayList<TreePath>();
        for (i = 0; i < paths.length; ++i) {
            TariffDAGNode lastNode = (TariffDAGNode)paths[i].getLastPathComponent();
            if (lastNode.getTypename().equals("Defs") || lastNode.getNodeType() == 0) continue;
            thePaths.add(paths[i]);
        }
        Collections.sort(thePaths, new Comparator<TreePath>(){

            @Override
            public int compare(TreePath o1, TreePath o2) {
                return o1.getPathCount() - o2.getPathCount();
            }
        });
        block1: for (i = thePaths.size() - 1; i > 0; --i) {
            boolean justGo = false;
            for (int j = i - 1; j >= 0; --j) {
                if (!justGo && ((TreePath)thePaths.get(i)).getPathCount() <= ((TreePath)thePaths.get(j)).getPathCount()) continue;
                justGo = true;
                if (!((TreePath)thePaths.get(j)).isDescendant((TreePath)thePaths.get(i))) continue;
                thePaths.remove(i);
                continue block1;
            }
        }
        return thePaths.size() > 0 ? thePaths.toArray(new TreePath[thePaths.size()]) : null;
    }

    public static boolean checkNodeIdAmbiguity(JTree tree, TreePath path) {
        int[] ind = new int[1];
        String ambiguity = TSLink.checkDuplicatesInPath(path.getPath(), 0, ind);
        if (ambiguity != null) {
            String[] options = new String[]{"OK", "Select Path"};
            int selected = DialogFactory.showOptionDialog(tree, "Ambiguous link target", "<html>The node <em>" + SelectionTreeUtil.subpathToString(path.getPath(), ind[0]) + "</em> contains more than one element with the id <em>" + ambiguity + "</em><p>This is easy to correct, just set the \"Id\" variable for these elements to unique values.</html>", options);
            if (selected == 1) {
                int len = ind[0] + 1;
                Object[] pathPart = new Object[len];
                for (int i = 0; i < len; ++i) {
                    pathPart[i] = path.getPath()[i];
                }
                SelectionTreeUtil.selectAndMakeVisible(tree, new TreePath(pathPart));
            }
            return true;
        }
        return false;
    }

    public static TreePath extractOriginalPath(TariffDAGModel model, TreePath treePath) {
        TariffDAGNode selectedNode = (TariffDAGNode)treePath.getLastPathComponent();
        return model.getPathToRoot(selectedNode);
    }

    public static boolean checkNodeId(TreePath path) {
        Object[] nodeArray = path.getPath();
        boolean ok = true;
        for (int i = 1; ok && i < nodeArray.length; ++i) {
            if (!(nodeArray[i] instanceof TSNode) || !((TariffDAGNode)nodeArray[i]).getNodeName().isEmpty() || !((TariffDAGNode)nodeArray[i]).getNodeId().isEmpty()) continue;
            ok = false;
        }
        return ok;
    }

    public static Object[] findClosestMatchingPath(DAGNode node, DAGNode root, Object[] candidate) {
        ArrayList<List<DAGNode>> result = new ArrayList<List<DAGNode>>();
        DAGUtil.getPathsToRoot(node, root, new ArrayList<DAGNode>(100), result);
        Object[] retVal = null;
        int mostMatch = 0;
        int len = result.size();
        for (int i = 0; i < len; ++i) {
            List aPath = (List)result.get(i);
            if (aPath == null) continue;
            int thisMatch = 0;
            for (int j = 0; j < candidate.length && j < aPath.size() && candidate[j] == aPath.get(j); ++j) {
                thisMatch = Math.max(thisMatch, j + 1);
            }
            if (thisMatch <= mostMatch) continue;
            mostMatch = thisMatch;
            retVal = aPath.toArray();
        }
        return retVal;
    }

    public static void expandAll(final JTree tree) {
        boolean doExpand;
        TreeModel model = tree.getModel();
        if (model instanceof TariffDAGModel && ((TariffDAGModel)model).gaugeDepth((DAGNode)tree.getSelectionPath().getLastPathComponent()) > 6 && !(doExpand = DialogFactory.getQuestionDialog(tree, "Expand all action", "Warning! This operation may take a while, \n do you want to continue?"))) {
            return;
        }
        if (tree.getSelectionPath() != null) {
            tree.putClientProperty(PROP_CANCEL_BATCH_EXPAND, Boolean.FALSE);
            SelectionTreeUtil.enableRepaint(tree);
            final ProgressDialog expandDialog = new ProgressDialog("Expand all", "Expanding nodes...");
            expandDialog.setIndeterminate(true);
            expandDialog.setStringPainted(false);
            SelectionTreeUtil.expandTree(tree, expandDialog);
            expandDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tree.putClientProperty(SelectionTreeUtil.PROP_CANCEL_BATCH_EXPAND, Boolean.TRUE);
                    SelectionTreeUtil.enableRepaint(tree);
                    expandDialog.dispose();
                }
            });
            expandDialog.setVisible(true);
        }
    }

    private static void expandTree(final JTree tree, final ProgressDialog expandDialog) {
        SwingWorker<Boolean, Void> expandTask = new SwingWorker<Boolean, Void>(){

            @Override
            protected Boolean doInBackground() throws Exception {
                SelectionTreeUtil.disableRepaint(tree);
                return SelectionTreeUtil.expandRecursive(tree, tree.getSelectionPath());
            }

            @Override
            protected void done() {
                SelectionTreeUtil.enableRepaint(tree);
                expandDialog.dispose();
            }
        };
        expandTask.execute();
    }

    public static void collapseAll(final JTree tree) {
        if (tree.getSelectionPath() != null) {
            tree.putClientProperty(PROP_CANCEL_BATCH_EXPAND, Boolean.FALSE);
            SelectionTreeUtil.enableRepaint(tree);
            final ProgressDialog collapseDialog = new ProgressDialog("Collapse all", "Collapsing nodes...");
            collapseDialog.setIndeterminate(true);
            collapseDialog.setStringPainted(false);
            SelectionTreeUtil.collapseTree(tree, collapseDialog);
            collapseDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    tree.putClientProperty(SelectionTreeUtil.PROP_CANCEL_BATCH_EXPAND, Boolean.TRUE);
                    SelectionTreeUtil.enableRepaint(tree);
                    collapseDialog.dispose();
                }
            });
            collapseDialog.setVisible(true);
        }
    }

    private static void collapseTree(final JTree tree, final ProgressDialog collapseDialog) {
        SwingWorker<Void, Void> collapseTask = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                SelectionTreeUtil.disableRepaint(tree);
                SelectionTreeUtil.collapseRecursive(tree, tree.getSelectionPath());
                return null;
            }

            @Override
            protected void done() {
                SelectionTreeUtil.enableRepaint(tree);
                collapseDialog.dispose();
            }
        };
        collapseTask.execute();
    }

    public static void disableRepaint(JTree tree) {
        if (!SelectionTreeUtil.isRepaintingDisabled(tree)) {
            tree.putClientProperty("PaintControlledJTree.disableRepaint", Boolean.TRUE);
        }
    }

    public static void enableRepaint(JTree tree) {
        if (SelectionTreeUtil.isRepaintingDisabled(tree)) {
            tree.putClientProperty("PaintControlledJTree.disableRepaint", Boolean.FALSE);
            tree.treeDidChange();
        }
    }

    public static boolean isRepaintingDisabled(JTree tree) {
        return tree.getClientProperty("PaintControlledJTree.disableRepaint") == Boolean.TRUE;
    }

    private static String subpathToString(Object[] path, int index) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i <= index; ++i) {
            buf.append("/");
            buf.append(((TariffStructureNode)path[i]).getNodeId());
        }
        return buf.toString();
    }

    private static boolean expandRecursive(JTree tree, TreePath path) {
        boolean cancel;
        boolean bl = cancel = tree.getClientProperty(PROP_CANCEL_BATCH_EXPAND) == Boolean.TRUE;
        if (cancel) {
            return false;
        }
        DAGNode node = (DAGNode)path.getLastPathComponent();
        if (tree.getModel().isLeaf(node)) {
            return false;
        }
        if (node.getChildCount() >= 0) {
            boolean childDidExpand = false;
            for (int i = 0; i < node.getChildCount(); ++i) {
                DAGNode n = node.getChildAt(i);
                TreePath child = path.pathByAddingChild(n);
                childDidExpand |= SelectionTreeUtil.expandRecursive(tree, child);
            }
            if (childDidExpand) {
                return true;
            }
        }
        tree.expandPath(path);
        return true;
    }

    private static void collapseRecursive(JTree tree, TreePath path) {
        boolean cancel;
        boolean bl = cancel = tree.getClientProperty(PROP_CANCEL_BATCH_EXPAND) == Boolean.TRUE;
        if (cancel) {
            return;
        }
        DAGNode node = (DAGNode)path.getLastPathComponent();
        if (node.getChildCount() >= 0 && !cancel) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DAGNode n = node.getChildAt(i);
                TreePath child = path.pathByAddingChild(n);
                SelectionTreeUtil.collapseRecursive(tree, child);
            }
        }
        if (node != tree.getModel().getRoot() && !tree.getModel().isLeaf(node)) {
            tree.collapsePath(path);
        }
    }
}

