/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.ratingrules.actions;

import com.ericsson.ere.gui.ratingrules.SelectionTreeActionHandler;
import com.ericsson.ere.gui.ratingrules.TariffClipboardOwner;
import com.ericsson.ere.gui.ratingrules.actions.ConditionallyInvokable;
import com.ericsson.ere.gui.ratingrules.actions.SelectionTreeActionContext;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;

public enum Paste implements ConditionallyInvokable<SelectionTreeActionHandler, SelectionTreeActionContext>
{
    Default{

        @Override
        public void invoke(SelectionTreeActionHandler handler, ActionEvent e) {
            handler.pasteDefaultAction(e);
        }

        @Override
        protected boolean allowForNode(TariffDAGModel model, Object[] path, TariffDAGNode node) {
            return model.allowsAddTariffStructureNodeDefault(path, node);
        }
    }
    ,
    Special{

        @Override
        public void invoke(SelectionTreeActionHandler handler, ActionEvent e) {
            handler.pasteSpecialAction(e);
        }

        @Override
        protected boolean allowForNode(TariffDAGModel model, Object[] path, TariffDAGNode node) {
            return model.allowsAddTariffStructureNodeDefault(path, node);
        }
    }
    ,
    Sibling{

        @Override
        public void invoke(SelectionTreeActionHandler handler, ActionEvent e) {
            handler.pasteAsSiblingAction(e);
        }

        @Override
        protected boolean allowForNode(TariffDAGModel model, Object[] path, TariffDAGNode node) {
            return model.allowsAddTariffStructureNodeAsSibling(path, node);
        }
    }
    ,
    Child{

        @Override
        public void invoke(SelectionTreeActionHandler handler, ActionEvent e) {
            handler.pasteAsChildAction(e);
        }

        @Override
        protected boolean allowForNode(TariffDAGModel model, Object[] path, TariffDAGNode node) {
            return model.allowsAddTariffStructureNodeAsChild(path, node);
        }
    };


    protected abstract boolean allowForNode(TariffDAGModel var1, Object[] var2, TariffDAGNode var3);

    @Override
    public boolean canBeInvoked(SelectionTreeActionContext ctx) {
        if (ctx.firstSelectedPath() == null) {
            return false;
        }
        SelectionTreeActionHandler sh = ctx.actionHandler();
        List<TariffDAGNode> pastableNodes = null;
        boolean allow = false;
        if (sh instanceof TariffClipboardOwner) {
            try {
                pastableNodes = ((TariffClipboardOwner)((Object)sh)).getPastableNodes();
                if (pastableNodes == null) {
                    pastableNodes = Collections.emptyList();
                }
                for (TariffDAGNode node : pastableNodes) {
                    allow |= this.allowForNode(ctx.treeModel(), ctx.firstSelectedPath(), node);
                }
            }
            catch (Exception e) {
                allow = false;
            }
        }
        return allow;
    }
}

