/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.ElementBasedFilterEditPanel;
import com.ericsson.ere.gui.search.SimulationBasedFilterEditPanel;
import com.ericsson.ere.gui.search.presenter.AbstractTypeSpecificFilterEditPresenter;
import com.ericsson.ere.gui.search.presenter.ElementBasedFilterEditPresenter;
import com.ericsson.ere.gui.search.presenter.SimulationBasedFilterEditPresenter;
import com.ericsson.ere.gui.search.view.ElementBasedFilterEditView;
import com.ericsson.ere.gui.search.view.SimulationBasedFilterEditView;
import com.ericsson.ere.gui.search.view.TypeSpecificFilterEditView;
import com.ericsson.ere.selectiontree.search.filter.BranchFilter;
import com.ericsson.ere.selectiontree.search.filter.ElementBasedBranchFilter;
import com.ericsson.ere.selectiontree.search.filter.SimulationBasedParameterBranchFilter;
import ericsson.ere.management.ContextAwareServiceContainer;
import javax.swing.JPanel;

public enum BranchSearchFilterType {
    SIMULATION_BASED{

        @Override
        public AbstractTypeSpecificFilterEditPresenter createPresenterFromType(TypeSpecificFilterEditView view, ContextAwareServiceContainer serviceContainer) {
            return new SimulationBasedFilterEditPresenter((SimulationBasedFilterEditView)view, serviceContainer);
        }

        @Override
        public JPanel createTypeSpecificViewPanel() {
            return new SimulationBasedFilterEditPanel();
        }

        @Override
        public BranchFilter createNewFilter(ContextAwareServiceContainer serviceContainer, String name) {
            return new SimulationBasedParameterBranchFilter(serviceContainer, name);
        }

        @Override
        public String getReadableName() {
            return "Field value";
        }
    }
    ,
    ELEMENT_BASED{

        @Override
        public ElementBasedBranchFilter createNewFilter(ContextAwareServiceContainer serviceContainer, String name) {
            return new ElementBasedBranchFilter(name);
        }

        @Override
        public AbstractTypeSpecificFilterEditPresenter createPresenterFromType(TypeSpecificFilterEditView view, ContextAwareServiceContainer serviceContainer) {
            return new ElementBasedFilterEditPresenter((ElementBasedFilterEditView)view);
        }

        @Override
        public JPanel createTypeSpecificViewPanel() {
            return new ElementBasedFilterEditPanel();
        }

        @Override
        public String getReadableName() {
            return "Element setting";
        }
    };


    public abstract AbstractTypeSpecificFilterEditPresenter createPresenterFromType(TypeSpecificFilterEditView var1, ContextAwareServiceContainer var2);

    public abstract JPanel createTypeSpecificViewPanel();

    public abstract BranchFilter createNewFilter(ContextAwareServiceContainer var1, String var2);

    public abstract String getReadableName();

    public static BranchSearchFilterType getFilterTypeFromFilter(BranchFilter filter) {
        if (filter instanceof SimulationBasedParameterBranchFilter) {
            return SIMULATION_BASED;
        }
        if (filter instanceof ElementBasedBranchFilter) {
            return ELEMENT_BASED;
        }
        throw new AssertionError((Object)("Unknown filter: " + filter.getClass().getName()));
    }
}

