/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.BranchSearchResultTable;
import com.ericsson.ere.gui.search.BranchSearchStateHandler;
import com.ericsson.ere.gui.search.BranchSearchTableModel;
import com.ericsson.ere.gui.search.SettingsComparatorDataSource;
import com.ericsson.ere.gui.search.SettingsComparatorDialog;
import com.ericsson.ere.gui.search.presenter.BranchSearchResultPresenter;
import com.ericsson.ere.gui.search.view.BranchSearchResultView;
import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.SettingsBasedBranchComparator;
import com.ericsson.ere.swing.EventSource;
import ericsson.ere.defs.RmaDefs;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class BranchSearchResultPanel
extends JPanel
implements BranchSearchResultView {
    private static final int COMPARATOR_COUNT = BranchSearchResultPresenter.SortingPriority.values().length;
    private BranchSearchResultTable myTable;
    private JLabel myInfoLabelIcon;
    private BranchSearchStateHandler myStateHandler;
    private EventSource myToggleConditionsEvent = new EventSource();
    private EventSource myToggleNodesEvent = new EventSource();
    private EventSource myToggleVerticalOrderEvent = new EventSource();
    private EventSource mySortEvent = new EventSource();
    private JCheckBox myToggleConditionsCheckBox;
    private JCheckBox myToggleNodesCheckBox;
    private JRadioButton myShowRootFirstButton;
    private JCheckBox myTableRowBasedCheckBox;
    private JComboBox[] myComparatorSelectors;
    private Map<BranchSearchResultPresenter.SortingPriority, SettingsComparatorDataSource> myDataSources;
    private boolean myHasResultingBranches;
    private JLabel myMessageLabel;
    private Map<Integer, Map<String, Set<String>>> mySettings;

    public BranchSearchResultPanel(BranchSearchStateHandler stateHandler, boolean hasResult) {
        this.myStateHandler = stateHandler;
        this.myHasResultingBranches = hasResult;
        this.buildLayout();
    }

    private void buildLayout() {
        this.setName("BranchSearch.ResultPanel");
        this.setLayout(new GridBagLayout());
        JPanel displayPanel = new JPanel(new GridBagLayout());
        displayPanel.setBorder(new TitledBorder(" Display "));
        JLabel sortLabel = new JLabel("Sort by:");
        displayPanel.add((Component)sortLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 5, 0, 5), 0, 0));
        this.myInfoLabelIcon = new JLabel(RmaDefs.getImageIcon("about.png"));
        this.setSortingInformation("Select sorting criteria.");
        displayPanel.add((Component)this.myInfoLabelIcon, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 0), 0, 0));
        JPanel sortPanel = this.buildSortingComponents();
        displayPanel.add((Component)sortPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0));
        JLabel hideShowLabel = new JLabel("Show:");
        displayPanel.add((Component)hideShowLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 5), 0, 0));
        JPanel togglePanel = this.buildToggleComponents();
        displayPanel.add((Component)togglePanel, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)displayPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setMinimumSize(new Dimension(500, 400));
        this.myTable = new BranchSearchResultTable(this.myStateHandler.getContext(), this);
        if (this.myHasResultingBranches) {
            contentPane.add((Component)this.myTable.getTableHeader(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            contentPane.add((Component)this.myTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            contentPane.add((Component)new JLabel("No matching branches found."), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        JScrollPane scrollPane = new JScrollPane(contentPane);
        this.add((Component)scrollPane, new GridBagConstraints(0, 1, 2, 1, 0.0, 1.0, 11, 1, new Insets(5, 10, 0, 10), 0, 0));
        this.myMessageLabel = new JLabel("");
        this.add((Component)this.myMessageLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 1, new Insets(5, 10, 0, 10), 0, 0));
        JButton backButton = new JButton("< Refine");
        backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchResultPanel.this.myStateHandler.showFilterView();
            }
        });
        this.add((Component)backButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 16, 0, new Insets(5, 10, 10, 10), 0, 0));
        JPanel reversePanel = this.buildReversePanel();
        this.add((Component)reversePanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 14, 3, new Insets(5, 0, 10, 10), 0, 0));
    }

    private JPanel buildSortingComponents() {
        JPanel sortByContentPanel = new JPanel(new GridBagLayout());
        this.myComparatorSelectors = new JComboBox[COMPARATOR_COUNT];
        for (int i = 0; i < COMPARATOR_COUNT; ++i) {
            JComboBox combo = new JComboBox(this.createDefaultComparatorVector());
            combo.setName("BranchSearch.ResultPanel.JComboBox.Sort-" + i);
            sortByContentPanel.add(combo, new GridBagConstraints(i + 1, 0, 1, 1, 0.2, 0.0, 11, 1, new Insets(0, 0, 0, 10), 0, 0));
            this.myComparatorSelectors[i] = combo;
        }
        JButton doSortButton = this.mySortEvent.createButton("", RmaDefs.getImageIcon("sort_exchange.png"), "Arrange columns by selected criterion");
        doSortButton.setName("BranchSearch.ResultPanel.JButton.Sort");
        doSortButton.setEnabled(this.myHasResultingBranches);
        sortByContentPanel.add((Component)doSortButton, new GridBagConstraints(4, 0, 1, 1, 0.2, 1.0, 11, 1, new Insets(0, 0, 0, 1), 0, 0));
        return sortByContentPanel;
    }

    private Vector<Comparator<?>> createDefaultComparatorVector() {
        Vector vector = new Vector();
        for (Comparator<Branch> comp : BranchSearchResultPresenter.createDefaultComparators()) {
            vector.add(comp);
        }
        return vector;
    }

    private JPanel buildToggleComponents() {
        JPanel toggleComponentPanel = new JPanel(new GridBagLayout());
        JLabel conditionIconLabel = new JLabel(RmaDefs.getImageIcon("condition16.png"));
        toggleComponentPanel.add((Component)conditionIconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.myToggleConditionsCheckBox = this.myToggleConditionsEvent.createCheckBox(true, "Toggle showing conditions in result branches");
        this.myToggleConditionsCheckBox.setName("BranchSearch.ResultPanel.JCheckBox.ToggleConditions");
        toggleComponentPanel.add((Component)this.myToggleConditionsCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        JLabel nodeIconLabel = new JLabel(RmaDefs.getImageIcon("folder16.png"));
        toggleComponentPanel.add((Component)nodeIconLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.myToggleNodesCheckBox = this.myToggleNodesEvent.createCheckBox(true, "Toggle showing nodes in result branches");
        this.myToggleNodesCheckBox.setName("BranchSearch.ResultPanel.JCheckBox.ToggleNodes");
        toggleComponentPanel.add((Component)this.myToggleNodesCheckBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        return toggleComponentPanel;
    }

    private JPanel buildReversePanel() {
        JPanel reversePanel = new JPanel(new GridBagLayout());
        JLabel rowBasedTableLabel = new JLabel(RmaDefs.getImageIcon("table_arrow_green_right_16.png"));
        this.myTableRowBasedCheckBox = new JCheckBox();
        this.myTableRowBasedCheckBox.setToolTipText("Show branches in row based mode.");
        this.myTableRowBasedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchResultPanel.this.myTable.setRowBased(BranchSearchResultPanel.this.myTableRowBasedCheckBox.isSelected());
            }
        });
        JLabel showRootFirstLabel = new JLabel(RmaDefs.getImageIcon("selection_up.png"));
        this.myShowRootFirstButton = this.myToggleVerticalOrderEvent.createRadioButton(true, "Toggle showing the root as top node.");
        this.myShowRootFirstButton.setName("BranchSearch.ResultPanel.JRadioButton.ShowRootFirst");
        JLabel showLeafFirstLabel = new JLabel(RmaDefs.getImageIcon("selection_down.png"));
        JRadioButton showLeafFirstButton = this.myToggleVerticalOrderEvent.createRadioButton(false, "Toggle showing the leaf as top node.");
        showLeafFirstButton.setName("BranchSearch.ResultPanel.JRadioButton.ShowLeafFirst");
        ButtonGroup reverseGroup = new ButtonGroup();
        reverseGroup.add(this.myShowRootFirstButton);
        reverseGroup.add(showLeafFirstButton);
        reversePanel.add((Component)rowBasedTableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        reversePanel.add((Component)this.myTableRowBasedCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        reversePanel.add((Component)showRootFirstLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        reversePanel.add((Component)this.myShowRootFirstButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        reversePanel.add((Component)showLeafFirstLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        reversePanel.add((Component)showLeafFirstButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        return reversePanel;
    }

    @Override
    public void setSortingInformation(String tooltip) {
        this.myInfoLabelIcon.setToolTipText(tooltip);
    }

    @Override
    public Comparator<Branch>[] getSelectedComparators() {
        Comparator[] comparators = new Comparator[COMPARATOR_COUNT];
        boolean needsSettingsBasedComparatorConfig = false;
        for (int i = 0; i < COMPARATOR_COUNT; ++i) {
            Comparator comp = (Comparator)this.myComparatorSelectors[i].getSelectedItem();
            needsSettingsBasedComparatorConfig |= comp instanceof SettingsBasedBranchComparator;
            comparators[i] = comp;
        }
        if (needsSettingsBasedComparatorConfig) {
            this.configureSettingsBasedComparators(comparators);
        }
        return comparators;
    }

    private void configureSettingsBasedComparators(Comparator<Branch>[] comparators) {
        this.myDataSources = this.showSettingsComparatorConfigurationDialog();
        for (int i = 0; i < comparators.length; ++i) {
            BranchSearchResultPresenter.SortingPriority prio;
            if (!(comparators[i] instanceof SettingsBasedBranchComparator) || !this.myDataSources.containsKey((Object)(prio = BranchSearchResultPresenter.SortingPriority.fromIndex(i)))) continue;
            comparators[i] = this.myDataSources.get((Object)prio).getComparator();
        }
    }

    private Map<BranchSearchResultPresenter.SortingPriority, SettingsComparatorDataSource> showSettingsComparatorConfigurationDialog() {
        List<SettingsComparatorDataSource> dataSources = this.createDataSourceListForComparatorConfigDialog();
        SettingsComparatorDialog d = new SettingsComparatorDialog(this, dataSources);
        d.setVisible(true);
        HashMap<BranchSearchResultPresenter.SortingPriority, SettingsComparatorDataSource> map = new HashMap<BranchSearchResultPresenter.SortingPriority, SettingsComparatorDataSource>();
        for (int i = 0; i < COMPARATOR_COUNT; ++i) {
            BranchSearchResultPresenter.SortingPriority prio = BranchSearchResultPresenter.SortingPriority.fromIndex(i);
            if (!d.hasSettingsForPrio(prio)) continue;
            map.put(prio, d.getDataSourceForPrio(prio));
        }
        return map;
    }

    private List<SettingsComparatorDataSource> createDataSourceListForComparatorConfigDialog() {
        ArrayList<SettingsComparatorDataSource> dataSources = new ArrayList<SettingsComparatorDataSource>();
        for (int i = 0; i < COMPARATOR_COUNT; ++i) {
            Comparator comp = (Comparator)this.myComparatorSelectors[i].getSelectedItem();
            if (!(comp instanceof SettingsBasedBranchComparator)) continue;
            BranchSearchResultPresenter.SortingPriority prio = BranchSearchResultPresenter.SortingPriority.fromIndex(i);
            if (this.myDataSources != null && this.myDataSources.containsKey((Object)prio)) {
                dataSources.add(this.myDataSources.get((Object)prio));
                continue;
            }
            dataSources.add(SettingsComparatorDataSource.createEmptyDataContainer(prio, this.mySettings));
        }
        return dataSources;
    }

    @Override
    public boolean shouldShowConditions() {
        return this.myToggleConditionsCheckBox.isSelected();
    }

    @Override
    public boolean shouldShowNodes() {
        return this.myToggleNodesCheckBox.isSelected();
    }

    @Override
    public boolean shouldShowRootOnTop() {
        return this.myShowRootFirstButton.isSelected();
    }

    @Override
    public EventSource sortEvent() {
        return this.mySortEvent;
    }

    @Override
    public EventSource toggleConditionsEvent() {
        return this.myToggleConditionsEvent;
    }

    @Override
    public EventSource toggleNodesEvent() {
        return this.myToggleNodesEvent;
    }

    @Override
    public EventSource toggleVerticalOrderEvent() {
        return this.myToggleVerticalOrderEvent;
    }

    @Override
    public void setBranchViewModel(BranchSearchTableModel model) {
        this.myTable.setModel(model);
    }

    @Override
    public boolean askYesNoQuestion(String question) {
        return false;
    }

    @Override
    public void handleError(Throwable error, String message) {
        if (message.length() > 0) {
            this.myMessageLabel.setIcon(RmaDefs.getImageIcon("error.png"));
        } else {
            this.myMessageLabel.setIcon(null);
        }
        this.myMessageLabel.setText(message);
    }

    @Override
    public void showInformation(String message) {
        if (message.length() > 0) {
            this.myMessageLabel.setIcon(RmaDefs.getImageIcon("information16.png"));
        } else {
            this.myMessageLabel.setIcon(null);
        }
        this.myMessageLabel.setText(message);
    }

    @Override
    public void setSettingsBasedSortParameters(Map<Integer, Map<String, Set<String>>> parametersMap) {
        this.mySettings = parametersMap;
    }
}

