/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.AbstractViewPanel;
import com.ericsson.ere.gui.search.BranchSearchFilterEditPanel;
import com.ericsson.ere.gui.search.BranchSearchFilterSelectionPanel;
import com.ericsson.ere.gui.search.view.BranchSearchFilterEditView;
import com.ericsson.ere.gui.search.view.BranchSearchFilterSelectionView;
import com.ericsson.ere.gui.search.view.BranchSearchSearchView;
import com.ericsson.ere.swing.EventSource;
import com.ericsson.ere.swing.WeightedSingleLineLayoutManager;
import ericsson.ere.gui.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BranchSearchSearchPanel
extends AbstractViewPanel
implements BranchSearchSearchView {
    public static final int GAP = 10;
    private static final String SEARCH_NO_FILTERS = "Show all";
    private static final String SEARCH_WITH_FILTERS = "Search";
    private EventSource mySearchEvent = new EventSource();
    private BranchSearchFilterSelectionPanel mySelectionPanel;
    private BranchSearchFilterEditPanel myEditPanel;
    private JButton mySearchButton;
    private JCheckBox myIncludeZerosCheckBox;
    private Border splitBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray), BorderFactory.createEmptyBorder(10, 0, 10, 0));
    private Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

    public BranchSearchSearchPanel() {
        super(new GridBagLayout());
        this.mySelectionPanel = new BranchSearchFilterSelectionPanel();
        this.myEditPanel = new BranchSearchFilterEditPanel();
        this.mySelectionPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.myEditPanel.setBorder(this.splitBorder);
        this.createSearchButton();
        JPanel executeSearchPanel = this.createExecutePanel();
        executeSearchPanel.setBorder(this.splitBorder);
        JPanel split = new JPanel(new WeightedSingleLineLayoutManager(new int[]{55, 45, 0}, WeightedSingleLineLayoutManager.Orientation.Vertical));
        split.add(this.mySelectionPanel);
        split.add(this.myEditPanel);
        split.add(executeSearchPanel);
        this.add((Component)split, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.mySelectionPanel.addIncludeExcludeFilterModelListener(new UpdateSearchButtonTextAction());
    }

    private JPanel createExecutePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.mySearchButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        buttonPanel.add(this.createCloseButton(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, this.EMPTY_INSETS, 0, 0));
        this.myIncludeZerosCheckBox = new JCheckBox("Include potential matches in the results.");
        this.myIncludeZerosCheckBox.setMargin(new Insets(0, 0, 0, 5));
        this.myIncludeZerosCheckBox.setName("BranchSearch.BranchSearchPropertiesPanel.JRadioButton.IncludeZero");
        this.myIncludeZerosCheckBox.setEnabled(false);
        panel.add((Component)this.myIncludeZerosCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, this.EMPTY_INSETS, 0, 0));
        panel.add((Component)buttonPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 12, 0, this.EMPTY_INSETS, 0, 0));
        return panel;
    }

    private Component createCloseButton() {
        JButton btn = new JButton("Close");
        this.setDimensionsForButton(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JInternalFrame parent = BranchSearchSearchPanel.this.getFrameParent();
                if (parent != null) {
                    parent.doDefaultCloseAction();
                }
            }
        });
        return btn;
    }

    private void setDimensionsForButton(JButton button) {
        Dimension dimension = button.getPreferredSize();
        dimension.height = 25;
        button.setPreferredSize(dimension);
        button.setMinimumSize(dimension);
    }

    private void createSearchButton() {
        this.mySearchButton = this.mySearchEvent.createButton(SEARCH_NO_FILTERS);
        this.mySearchButton.setName("BranchSearchFilterPanel.JButton.Search");
        this.setDimensionsForButton(this.mySearchButton);
    }

    @Override
    public EventSource searchFiltersEvent() {
        return this.mySearchEvent;
    }

    @Override
    public BranchSearchFilterEditView getFilterEditView() {
        return this.myEditPanel;
    }

    @Override
    public BranchSearchFilterSelectionView getFilterSelectionView() {
        return this.mySelectionPanel;
    }

    private JInternalFrame getFrameParent() {
        return GuiUtil.getClosestParentOfClass(this, JInternalFrame.class);
    }

    void updateSearchButtonText(boolean hasFilters) {
        String newText;
        String string = newText = hasFilters ? SEARCH_WITH_FILTERS : SEARCH_NO_FILTERS;
        if (!this.mySearchButton.getText().equals(newText)) {
            this.mySearchButton.setText(newText);
        }
    }

    @Override
    public void setZeroScoreOptionState(boolean enable) {
        this.myIncludeZerosCheckBox.setEnabled(enable);
    }

    @Override
    public boolean shouldConsiderZeroScores() {
        return this.myIncludeZerosCheckBox.isSelected();
    }

    private class UpdateSearchButtonTextAction
    implements ListDataListener {
        private Set<Object> myPopulatedModels = new HashSet<Object>();

        private UpdateSearchButtonTextAction() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            Object model = e.getSource();
            if (this.myPopulatedModels.add(model)) {
                BranchSearchSearchPanel.this.updateSearchButtonText(true);
                BranchSearchSearchPanel.this.setZeroScoreOptionState(true);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            ListModel model = (ListModel)e.getSource();
            if (model.getSize() == 0) {
                this.myPopulatedModels.remove(model);
                boolean hasFilters = !this.myPopulatedModels.isEmpty();
                BranchSearchSearchPanel.this.updateSearchButtonText(hasFilters);
                BranchSearchSearchPanel.this.setZeroScoreOptionState(hasFilters);
            }
        }
    }
}

