/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.BranchSearchFrame;
import com.ericsson.ere.gui.search.BranchSearchResultPanel;
import com.ericsson.ere.gui.search.BranchSearchTableModelImpl;
import com.ericsson.ere.gui.search.BranchSearchUIContext;
import com.ericsson.ere.gui.search.presenter.BranchSearchResultPresenter;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.selectiontree.SelectionTreeBuilder;
import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.BranchExtractor;
import com.ericsson.ere.selectiontree.search.BranchList;
import com.ericsson.ere.selectiontree.search.DefaultBranchFinder;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.RatingRuleFrame;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.ratingrules.RatingBuilderErrorHandler;
import java.util.ArrayList;
import javax.swing.JPanel;

public class BranchSearchStateHandler {
    private TSTariffStructure myStructureRoot;
    private BranchSearchFrame myView;
    private ClassRepository myRepository;
    private BranchSearchUIContext myContext;
    public static final String RESULT_VIEW_IDENTIFIER = "Branch Search Result View";
    public static final String FILTER_VIEW_IDENTIFIER = "Branch Search Filter Card";

    public BranchSearchStateHandler(ClassRepository rep, TSTariffStructure root, BranchSearchFrame view, BranchSearchUIContext ctx) {
        this.myStructureRoot = root;
        this.myView = view;
        this.myRepository = rep;
        this.myContext = ctx;
        this.myContext.addSearchFrame(view);
    }

    public void populateResultView(BranchList branches) {
        boolean hasMatchingBranches = !branches.isEmpty();
        BranchSearchResultPanel resultView = new BranchSearchResultPanel(this, hasMatchingBranches);
        new BranchSearchResultPresenter(resultView, new BranchSearchTableModelImpl(branches), this.myContext.getTree().getTreeModel());
        this.showResultCard(resultView);
    }

    public BranchList findAllBranches() throws Exception {
        BranchList resultList;
        SelectionTreeBuilder builder = BranchExtractor.createBuilder(this.myRepository, this.getRatingPlan(), new RatingBuilderErrorHandler());
        TariffStructureNode root = null;
        try {
            root = builder.build(this.myStructureRoot.getUpdatedXMLConfiguration());
            BranchExtractor extractor = BranchExtractor.createExtractor(root);
            resultList = extractor.extractBranches(new DefaultBranchFinder());
        }
        catch (IllegalStateException e) {
            resultList = new BranchList(new ArrayList<Branch>());
        }
        return resultList;
    }

    private String getRatingPlan() {
        RatingPeriodProxy proxy;
        String rp = null;
        RatingRuleFrame rrf = this.myContext.getOwnerFrame();
        if (rrf != null && (proxy = rrf.getRatingPeriodProxy()) != null) {
            rp = proxy.getRatingPlanName();
        }
        return rp;
    }

    private void showResultCard(JPanel view) {
        this.myView.addCard(view, RESULT_VIEW_IDENTIFIER);
        this.myView.showView(RESULT_VIEW_IDENTIFIER);
    }

    public void showFilterView() {
        this.myView.showView(FILTER_VIEW_IDENTIFIER);
    }

    public void showResultView() {
        this.myView.showView(RESULT_VIEW_IDENTIFIER);
    }

    public BranchSearchUIContext getContext() {
        return this.myContext;
    }

    public boolean isTreeValid() {
        return this.myStructureRoot.isNodeValid();
    }
}

