/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search.presenter;

import com.ericsson.ere.gui.search.BranchSearchFilterType;
import com.ericsson.ere.gui.search.presenter.AbstractTypeSpecificFilterEditPresenter;
import com.ericsson.ere.gui.search.view.BranchSearchFilterEditView;
import com.ericsson.ere.gui.search.view.BranchSearchFilterSelectionView;
import com.ericsson.ere.gui.search.view.InvalidViewDataException;
import com.ericsson.ere.selectiontree.search.BranchSearchModel;
import com.ericsson.ere.selectiontree.search.filter.BranchFilter;
import ericsson.ere.management.ContextAwareServiceContainer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BranchSearchFilterEditPresenter {
    private static final String NAME_UNIQUENESS_ERROR = "The name is not unique. Please choose another name.";
    private static final String NAME_EMPTY_ERROR = "The name cannot be empty. Please choose a non-empty name.";
    private static final String NAME_TOO_LONG_ERROR = "The name is too long. Please choose a shorter name.";
    public static final boolean NEW_FILTER_IS_MODIFIED = true;
    private static final String NEW_FILTER_NAME = "[Unnamed]";
    public static final int MAX_FILTER_NAME_LENGTH = 200;
    private BranchSearchFilterEditView myEditView;
    private BranchSearchFilterSelectionView mySelectionView;
    private BranchFilter myCurrentFilter;
    private boolean myIsModified = false;
    private BranchSearchModel myMainModel;
    private ContextAwareServiceContainer myServiceContainer;
    private AbstractTypeSpecificFilterEditPresenter myInnerPresenter;

    public BranchSearchFilterEditPresenter(BranchSearchFilterEditView editView, BranchSearchFilterSelectionView selectionView, BranchSearchModel model, ContextAwareServiceContainer serviceContainer) {
        this.myServiceContainer = serviceContainer;
        this.myEditView = editView;
        this.mySelectionView = selectionView;
        this.myMainModel = model;
        this.createAndSetModels();
        this.subscribeToViewEvents();
        this.initializeView();
    }

    private void initializeView() {
        this.stopEditingFilter();
    }

    private void createAndSetModels() {
        this.myMainModel.addListDataListener(new MainModelHandler());
    }

    private void subscribeToViewEvents() {
        this.myEditView.saveFilterEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterEditPresenter.this.saveFilter();
            }
        });
        this.mySelectionView.startEditFilterEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterEditPresenter.this.editSelectedFilter();
            }
        });
        this.mySelectionView.newFilterEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterEditPresenter.this.editNewFilter();
            }
        });
        this.myEditView.stopEditFilterEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchFilterEditPresenter.this.stopEditingCurrentFilter();
            }
        });
    }

    void editNewFilter() {
        if (!this.canStopEditingCurrentFilter()) {
            return;
        }
        this.stopEditingFilter();
        BranchSearchFilterType selectedFilter = this.myEditView.askForTypeOfFilter();
        if (selectedFilter == null) {
            return;
        }
        BranchFilter newFilter = selectedFilter.createNewFilter(this.myServiceContainer, NEW_FILTER_NAME);
        this.editFilter(newFilter);
        this.myEditView.setFilterIsNew(true);
        this.setModified();
    }

    void editSelectedFilter() {
        if (!this.canStopEditingCurrentFilter()) {
            return;
        }
        Object[] filters = this.mySelectionView.getSelectedMainFilters();
        if (filters.length == 1) {
            this.stopEditingFilter();
            this.editFilter((BranchFilter)filters[0]);
            this.myEditView.setFilterIsNew(false);
        }
    }

    void stopEditingCurrentFilter() {
        boolean yes;
        if (this.isModified() && !(yes = this.myEditView.askYesNoQuestion("The current filter has been modified. Do you want to stop editing anyway?"))) {
            return;
        }
        this.stopEditingFilter();
    }

    private void editFilter(BranchFilter filter) {
        this.myCurrentFilter = filter;
        BranchSearchFilterType type = BranchSearchFilterType.getFilterTypeFromFilter(filter);
        this.myEditView.startEditingFilter(filter.getName(), type);
        this.myInnerPresenter = type.createPresenterFromType(this.myEditView.getTypeSpecificFilterEditView(), this.myServiceContainer);
        this.myInnerPresenter.populateViewFromFilter(filter);
        this.resetModified();
    }

    private void stopEditingFilter() {
        this.myCurrentFilter = null;
        if (this.myInnerPresenter != null) {
            this.myInnerPresenter.stopEditingFilter();
        }
        this.myEditView.stopEditingFilter();
    }

    private boolean canStopEditingCurrentFilter() {
        if (this.myCurrentFilter == null || !this.isModified()) {
            return true;
        }
        boolean yes = this.myEditView.askYesNoQuestion("The changed made to the current filter will be lost. Do you want to continue?");
        return yes;
    }

    void saveFilter() {
        if (this.isModified()) {
            boolean filterIsNew;
            if (!this.updateFilterFromView(this.myCurrentFilter)) {
                return;
            }
            boolean bl = filterIsNew = !this.myMainModel.getFilters().contains(this.myCurrentFilter);
            if (filterIsNew && !this.myMainModel.addFilter(this.myCurrentFilter)) {
                this.showNameUniquenessError();
                return;
            }
            this.resetModified();
        }
        this.stopEditingFilter();
    }

    private void showNameUniquenessError() {
        this.myEditView.handleError(null, NAME_UNIQUENESS_ERROR);
    }

    private void showEmptyNameError() {
        this.myEditView.handleError(null, NAME_EMPTY_ERROR);
    }

    private void showNameTooLongError() {
        this.myEditView.handleError(null, NAME_TOO_LONG_ERROR);
    }

    private boolean updateFilterFromView(BranchFilter filter) {
        boolean updated;
        String newName = this.myEditView.getFilterName().trim();
        if (!this.checkName(newName)) {
            return false;
        }
        try {
            filter.setName(newName);
        }
        catch (IllegalArgumentException ex) {
            this.showNameUniquenessError();
            return false;
        }
        try {
            updated = this.myInnerPresenter.updateFilterDataFromView(this.myCurrentFilter);
        }
        catch (InvalidViewDataException ex) {
            this.myEditView.handleError(null, ex.getMessage());
            updated = false;
        }
        return updated;
    }

    private boolean checkName(String name) {
        boolean ok = false;
        if ("".equals(name)) {
            this.showEmptyNameError();
        } else if (name.length() > 200) {
            this.showNameTooLongError();
        } else {
            ok = true;
        }
        return ok;
    }

    private void resetModified() {
        this.myIsModified = false;
    }

    private boolean isModified() {
        if (this.myIsModified || this.myInnerPresenter != null && this.myInnerPresenter.isModified()) {
            return true;
        }
        if (this.myCurrentFilter == null) {
            return false;
        }
        return this.myEditView.isModified();
    }

    private void setModified() {
        this.myIsModified = true;
    }

    private class MainModelHandler
    implements ListDataListener {
        private MainModelHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            assert (e instanceof BranchSearchModel.FilterRemoveListDataEvent);
            BranchSearchModel.FilterRemoveListDataEvent evt = (BranchSearchModel.FilterRemoveListDataEvent)e;
            String name = evt.getFilterName();
            if (BranchSearchFilterEditPresenter.this.myCurrentFilter != null && BranchSearchFilterEditPresenter.this.myCurrentFilter.getName().equals(name)) {
                BranchSearchFilterEditPresenter.this.stopEditingFilter();
            }
        }
    }
}

