/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.ere.dataset.DataDescriber;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.defs.GuiService;
import com.ericsson.ere.defs.RMAClassRepositoryWithContext;
import com.ericsson.ere.defs.ServiceFieldStructure;
import com.ericsson.ere.gui.simulator.ContextSimulationField;
import com.ericsson.ere.gui.simulator.DefaultFieldContextDataVariable;
import com.ericsson.ere.gui.simulator.FieldBasedVariableProducerWrapper;
import com.ericsson.ere.gui.simulator.FieldContextDataVariable;
import com.ericsson.ere.gui.simulator.SearchableSimulationPanel;
import com.ericsson.ere.gui.simulator.SimulationDataDescriber;
import com.ericsson.ere.gui.simulator.SimulationDataDiff;
import com.ericsson.ere.gui.simulator.SimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationDataPanelChangeListener;
import com.ericsson.ere.gui.simulator.SimulationField;
import com.ericsson.ere.gui.simulator.SimulationPanelHelper;
import com.ericsson.ere.gui.simulator.SimulationPanelSearcher;
import com.ericsson.ere.gui.simulator.SimulationParameterFilterer;
import com.ericsson.ere.gui.simulator.SimulationVariableStructure;
import com.ericsson.ere.gui.simulator.SimulatorFocusPolicy;
import com.ericsson.ere.gui.util.ClosableVarPanel;
import com.ericsson.ere.gui.util.ClosableVarSelectionPanel;
import com.ericsson.ere.gui.util.GroupedPanel;
import com.ericsson.ere.naming.AbstractSwingComponentNamer;
import com.ericsson.ere.naming.NamingStrategy;
import com.ericsson.ere.naming.SimulationVarTablesNamingStrategies;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.variable.DefaultVariableProducer;
import com.ericsson.ere.variable.VariableChangeEvent;
import com.ericsson.ere.variable.VariableChangeListener;
import com.ericsson.ere.variable.VariableList;
import com.ericsson.ere.variable.VariableProducer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.Service;
import ericsson.ere.xml.ElementIterator;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.GroupedArrayVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.WatermarkStringVariable;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldPanelSupport;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldXmlUtil;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFAdditionalObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractGroupedSimulationDataPanel
extends SimulationDataPanel
implements DataItem,
TreeDefinedFieldPanelSupport,
ChangeListener,
SearchableSimulationPanel {
    @Deprecated
    public static final String CONTEXT_DELIMITER = "%";
    private static String LBL_TREE_DEFINED_FIELDS = "Tree Defined Fields";
    private List<FieldDefinition> myTreeDefinedFieldDefs;
    private SimulationDataPanelChangeListener myPanelChangeHandler = null;
    private Variable myTitleVariable;
    private List<JComponent> myComponentList;
    private Map<String, ContextData> myContextData;
    private ClosableVarSelectionPanel myContextPanel;
    private StringVariable myContextIdentifierVariable;
    private DataDescriber myDataDescriber = new SimulationDataDescriber();
    private JTextField mySearchField;
    private SimulationPanelSearcher mySimulationParameterFilterer;
    private VariableChangeHandler myVariableChangeHandler = new VariableChangeHandler();
    private VariableList myVariableList;
    private FieldContextDataVariable myFieldContextDataVariable;
    protected ContextAwareServiceContainer myServiceContainer;
    protected Service myService;
    protected ClassRepository myClassRepository;
    protected GroupedPanel myGroupedPanel;
    protected List<Variable> myInputVariables = new ArrayList<Variable>();
    protected List<Variable> myOutputVariables = new ArrayList<Variable>();
    protected List<Variable> myCommonVars = null;
    protected List<ChangeListener> myVariableSelectionListeners = new ArrayList<ChangeListener>();

    public AbstractGroupedSimulationDataPanel(Service service) {
        this(ContextAwareServiceContainer.createContainerWithoutContext(service));
    }

    public AbstractGroupedSimulationDataPanel(ContextAwareServiceContainer serviceContainer) {
        this.myServiceContainer = serviceContainer;
        this.myClassRepository = serviceContainer.getClassRepository();
        this.myService = serviceContainer.getService();
        this.init();
        this.initializePanel();
    }

    protected void initializePanel() {
        this.buildComponents();
        this.configureFocusTraversal(this.myGroupedPanel);
        this.setupPanel(this.myGroupedPanel);
        this.setTitleVariable(this.getTitleVariable());
        this.updateStartTimeVariable();
        this.setVariableListeners();
        this.setComponentNames();
    }

    private void setupPanel(GroupedPanel panel) {
        this.setLayout(new GridBagLayout());
        JComponent tables = this.createSimulationDataTables(panel);
        this.add((Component)tables, new GridBagConstraints(0, 1, 2, 5, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void enableSimulationPanelSearch() {
        this.mySimulationParameterFilterer = new SimulationParameterFilterer(this);
        this.setupSearchField();
    }

    private void setupSearchField() {
        JPanel searchContainer = new JPanel();
        searchContainer.setLayout(new BoxLayout(searchContainer, 0));
        WatermarkStringVariable var = new WatermarkStringVariable("", (Document)new PlainDocument(), "Type text to search in panel", (String)null);
        this.mySearchField = (JTextField)((Variable)var).getEditor();
        this.mySearchField.setHorizontalAlignment(10);
        this.mySearchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AbstractGroupedSimulationDataPanel.this.performSearch(AbstractGroupedSimulationDataPanel.this.mySearchField.getText());
            }
        });
        searchContainer.add(this.mySearchField);
        this.mySearchField.setName("SimulationPanel.JTextField.SimulationSearch");
        this.add((Component)searchContainer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void performSearch(String text) {
        this.mySimulationParameterFilterer.performSearch(text);
        this.revalidate();
        this.repaint();
    }

    private void buildComponents() {
        VariableProducer producer = this.createVariableProducer(this.myClassRepository);
        producer = new FieldBasedVariableProducerWrapper(producer);
        SimulationPanelHelper simPanelHelper = SimulationPanelHelper.create(this, producer);
        this.myComponentList = this.createComponentList(simPanelHelper, "Common fields", true, this.myInputVariables, this.myOutputVariables);
        this.myComponentList.addAll(this.createComponentList(simPanelHelper, this.myServiceContainer.getFieldContext().getServiceProviderStringKey(), true, this.myInputVariables, this.myOutputVariables));
        this.myComponentList.addAll(this.createComponentList(simPanelHelper, this.myServiceContainer.getFieldContext().getRatingPlanStringKey(), true, this.myInputVariables, this.myOutputVariables));
        this.createContextGroups(simPanelHelper);
        JComponent treeDefinedFieldVarComponent = this.buildClosableTreeDefinedFieldVarComponent(simPanelHelper);
        if (treeDefinedFieldVarComponent != null) {
            this.myComponentList.add(treeDefinedFieldVarComponent);
        }
        this.setFocusTraversalPolicy(new SimulatorFocusPolicy(this.myComponentList));
        JPanel table2 = simPanelHelper.createVarTableWithArrayVariablesLast(this.getCommonParameters());
        ArrayList<JPanel> commonTableList = new ArrayList<JPanel>();
        commonTableList.add(table2);
        this.myComponentList.add(0, new ClosableVarPanel("Common", false, commonTableList));
        this.myGroupedPanel = new GroupedPanel(this.myComponentList, true);
    }

    protected void addFieldContextDataVariableToCommonVariables(List<String> additionalServices) {
        if (this.myClassRepository instanceof RMAClassRepositoryWithContext) {
            RMAClassRepositoryWithContext classRepository = (RMAClassRepositoryWithContext)this.myClassRepository;
            if (additionalServices != null && this.myService instanceof GuiService) {
                GuiService service = (GuiService)this.myService;
                ServiceProxy serviceProxy = service.getServiceProxy();
                RatingManagerProxy ratingManagerProxy = serviceProxy.getRatingManagerProxy();
                ServiceListProxy serviceListProxy = ratingManagerProxy.getServiceListProxy();
                for (String serviceId : additionalServices) {
                    ServiceProxy otherServiceProxy = serviceListProxy.getServiceProxy(serviceId);
                    if (otherServiceProxy == null) continue;
                    try {
                        classRepository.addServiceProviderAndRatingPlanContextFields(otherServiceProxy.getServiceDefinition());
                    }
                    catch (EreCommunicationException ereCommunicationException) {}
                }
            }
            if (classRepository.hasOtherFieldContextFields()) {
                this.myFieldContextDataVariable = this.createFieldContextDataVariable(classRepository);
                this.myCommonVars.add((Variable)((Object)this.myFieldContextDataVariable));
            }
        }
    }

    protected FieldContextDataVariable createFieldContextDataVariable(RMAClassRepositoryWithContext classRepository) {
        return new DefaultFieldContextDataVariable(classRepository, this.getFieldContextDataVariableLabel());
    }

    protected String getFieldContextDataVariableLabel() {
        return "Field Context Data";
    }

    private void configureFocusTraversal(GroupedPanel panel) {
        panel.setFocusCycleRoot(true);
        panel.setFocusTraversalPolicy(new SimulatorFocusPolicy(this.myComponentList));
        panel.setFocusTraversalPolicyProvider(true);
        HashSet<KeyStroke> newForwardKeys = new HashSet<KeyStroke>();
        newForwardKeys.add(KeyStroke.getKeyStroke(40, 0));
        newForwardKeys.add(KeyStroke.getKeyStroke(10, 0));
        newForwardKeys.add(KeyStroke.getKeyStroke(9, 0));
        panel.setFocusTraversalKeys(0, newForwardKeys);
        HashSet<KeyStroke> newBackwardKeys = new HashSet<KeyStroke>();
        newBackwardKeys.add(KeyStroke.getKeyStroke(38, 0));
        newBackwardKeys.add(KeyStroke.getKeyStroke(9, 64));
        panel.setFocusTraversalKeys(1, newBackwardKeys);
        HashSet<KeyStroke> newUpCycleKeys = new HashSet<KeyStroke>();
        newUpCycleKeys.add(KeyStroke.getKeyStroke(9, 128));
        newUpCycleKeys.add(KeyStroke.getKeyStroke(38, 128));
        panel.setFocusTraversalKeys(2, newUpCycleKeys);
        panel.setFocusTraversalKeysEnabled(true);
    }

    private void setComponentNames() {
        GroupComponentNamer theNamer = new GroupComponentNamer(new SimulationVarTablesNamingStrategies());
        for (int i = 0; i < this.myComponentList.size(); ++i) {
            theNamer.setComponentName(this.myComponentList.get(i), "Simulation", i);
        }
    }

    private void setVariableListeners() {
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.addAll(this.getCommonParameters());
        vars.addAll(this.getAllInputParameters());
        vars.addAll(this.getAllOutputParameters());
        for (Variable var : vars) {
            var.addVariableChangeListener(this.myVariableChangeHandler);
            var.addSelectedActionListener(this);
        }
        this.myVariableList = new VariableList(vars);
    }

    private void updateStartTimeVariable() {
        Variable startTimeVariable = VarListUtil.getVariableForName(this.myInputVariables, "Start time");
        if (startTimeVariable != null) {
            startTimeVariable.setValue(Calendar.getInstance());
        }
    }

    protected VariableProducer createVariableProducer(ClassRepository repository) {
        return new DefaultVariableProducer(repository);
    }

    private void createContextGroups(SimulationPanelHelper simPanelHelper) {
        if (this.myClassRepository.getContextFieldIdentifier() == null) {
            return;
        }
        Set<Map.Entry<String, Element>> allContexts = this.myClassRepository.getAllContexts();
        if (allContexts != null) {
            String contextIdentifier = this.myClassRepository.getContextFieldIdentifier();
            this.myContextIdentifierVariable = new StringVariable(contextIdentifier);
            this.myContextIdentifierVariable.setSelected(true);
            this.myContextData = new HashMap<String, ContextData>(allContexts.size());
            HashMap<String, List<JComponent>> allContextPanels = new HashMap<String, List<JComponent>>();
            for (Map.Entry<String, Element> context : allContexts) {
                ContextData contextData = new ContextData(context.getKey());
                contextData.myPanels = this.createComponentList(simPanelHelper, context.getKey(), false, contextData.myInputVars, contextData.myOutputVars);
                this.myContextData.put(contextData.myName, contextData);
                allContextPanels.put(contextData.myName, contextData.myPanels);
            }
            this.myContextPanel = new ClosableVarSelectionPanel("Context", true, allContextPanels, this.myContextIdentifierVariable);
            this.myComponentList.add(this.myContextPanel);
        }
    }

    private List<JComponent> createComponentList(SimulationPanelHelper simPanelHelper, String rootName, boolean sort, List<Variable> inputVariables, List<Variable> outputVariables) {
        ServiceFieldStructure.RootElement fieldStructureRoot = this.myClassRepository.getFieldStructure().getRoot();
        ServiceFieldStructure.StructureElement root = fieldStructureRoot.getNamedChild(rootName);
        if (root != null) {
            SimulationVariableStructure variableStructure = simPanelHelper.buildSimulationVariableStructure(root, sort);
            simPanelHelper.collectSimulationVariables(variableStructure, inputVariables, outputVariables);
            return simPanelHelper.buildSimulationComponents(variableStructure);
        }
        return new ArrayList<JComponent>();
    }

    protected void init() {
    }

    @Override
    @Deprecated
    public List<Variable> getInputParameters() {
        return this.myInputVariables;
    }

    public Variable getVariableByLable(String label) {
        Variable var = VarListUtil.getVariableForName(this.getAllOutputParameters(), label);
        if (var == null && (var = VarListUtil.getVariableForName(this.getAllInputParameters(), label)) == null) {
            var = VarListUtil.getVariableForName(this.getCommonParameters(), label);
        }
        return var;
    }

    public void setVariableSelected(String lable, boolean selected) {
        Variable var = this.getVariableByLable(lable);
        if (var != null) {
            var.setSelected(selected);
        }
    }

    @Override
    public List<Variable> getAllInputParameters() {
        ArrayList<Variable> allVariables = new ArrayList<Variable>();
        allVariables.addAll(this.myInputVariables);
        if (this.hasContextParameters()) {
            allVariables.add(this.myContextIdentifierVariable);
            for (ContextData contextData : this.myContextData.values()) {
                allVariables.addAll(contextData.myInputVars);
            }
        }
        return allVariables;
    }

    protected final boolean hasContextParameters() {
        return this.myContextIdentifierVariable != null;
    }

    @Override
    public List<Variable> getInputParametersForSimulation() {
        ArrayList<Variable> allVariables = new ArrayList<Variable>();
        allVariables.addAll(this.myInputVariables);
        if (this.hasContextParameters()) {
            allVariables.addAll(this.getInputParametersForSelectedContext(true));
        }
        return allVariables;
    }

    public List<Variable> getInputParametersForSelectedContext(boolean includeContextIdentifier) {
        String context;
        ContextData contextData;
        if (!this.hasContextParameters()) {
            throw new IllegalStateException("No contexts defined in the service for this panel.");
        }
        ArrayList<Variable> variables = new ArrayList<Variable>();
        if (includeContextIdentifier) {
            variables.add(this.myContextIdentifierVariable);
        }
        if ((contextData = this.myContextData.get(context = this.getSelectedContext())) != null) {
            variables.addAll(contextData.myInputVars);
        }
        return variables;
    }

    public List<Variable> getOutputParametersForSelectedContext() {
        if (!this.hasContextParameters()) {
            throw new IllegalStateException("No contexts defined in the service for this panel.");
        }
        ArrayList<Variable> variables = new ArrayList<Variable>();
        String context = this.getSelectedContext();
        ContextData contextData = this.myContextData.get(context);
        if (contextData != null) {
            variables.addAll(contextData.myOutputVars);
        }
        return variables;
    }

    public String getSelectedContext() {
        if (!this.hasContextParameters()) {
            throw new IllegalStateException("No contexts defined in the service for this panel.");
        }
        return this.myContextIdentifierVariable.getValueString();
    }

    public void selectContext(String context) {
        if (!this.hasContextParameters()) {
            throw new IllegalStateException("No contexts defined in the service for this panel.");
        }
        if (!this.myContextData.containsKey(context)) {
            throw new IllegalArgumentException("Unknown context: " + context);
        }
        this.myContextPanel.setSelectedVarList(context);
    }

    @Override
    @Deprecated
    public List<Variable> getOutputParameters() {
        return this.myOutputVariables;
    }

    @Override
    public List<Variable> getAllOutputParameters() {
        ArrayList<Variable> allVariables = new ArrayList<Variable>();
        allVariables.addAll(this.myOutputVariables);
        if (this.hasContextParameters()) {
            for (ContextData contextData : this.myContextData.values()) {
                allVariables.addAll(contextData.myOutputVars);
            }
        }
        return allVariables;
    }

    @Override
    public List<Variable> getOutputParametersForSimulation() {
        ArrayList<Variable> allVariables = new ArrayList<Variable>();
        allVariables.addAll(this.myOutputVariables);
        if (this.hasContextParameters()) {
            allVariables.addAll(this.getOutputParametersForSelectedContext());
        }
        return allVariables;
    }

    @Override
    public abstract List<Variable> getCommonParameters();

    @Override
    public List<SimulationField> getSimulationDataVariables() {
        return this.getSimulationFields();
    }

    @Override
    public List<SimulationField> getDatabaseSimulationFields() {
        return this.getSimulationFields();
    }

    @Override
    public List<SimulationField> getGroupedDatabaseFields() {
        ArrayList<SimulationField> contextFields = new ArrayList<SimulationField>();
        if (this.myContextData != null) {
            for (Map.Entry<String, ContextData> entry : this.myContextData.entrySet()) {
                ContextSimulationField contextSimulationField;
                String contextName = entry.getKey();
                ContextData contextData = entry.getValue();
                for (Variable var : contextData.myInputVars) {
                    contextSimulationField = new ContextSimulationField(contextName, var.getKey(), var.getValueObject(), var.isSelected());
                    contextFields.add(contextSimulationField);
                }
                for (Variable var : contextData.myOutputVars) {
                    contextSimulationField = new ContextSimulationField(contextName, var.getKey(), var.getValueObject(), var.isSelected());
                    contextFields.add(contextSimulationField);
                }
            }
        }
        return contextFields;
    }

    private List<SimulationField> getSimulationFields() {
        SimulationField simulationField;
        ArrayList<SimulationField> list = new ArrayList<SimulationField>();
        ArrayList<SimulationField> tdfINList = new ArrayList<SimulationField>();
        ArrayList<SimulationField> tdfOUTList = new ArrayList<SimulationField>();
        for (Variable var : this.getCommonParameters()) {
            simulationField = this.createSimulationFieldForVariable(var);
            list.add(simulationField);
        }
        for (Variable var : this.getInputParameters()) {
            simulationField = this.createSimulationFieldForVariable(var);
            if (var.getLabel().endsWith(" (IN)")) {
                tdfINList.add(simulationField);
                continue;
            }
            list.add(simulationField);
        }
        for (Variable var : this.getOutputParameters()) {
            simulationField = this.createSimulationFieldForVariable(var);
            if (var.getLabel().endsWith(" (OUT)")) {
                tdfOUTList.add(simulationField);
                continue;
            }
            list.add(simulationField);
        }
        if (this.myContextData != null) {
            SimulationField simulationField2 = new SimulationField(this.myContextIdentifierVariable.getLabel(), this.myContextIdentifierVariable.getValueObject(), this.myContextIdentifierVariable.isSelected());
            list.add(simulationField2);
            list.addAll(this.getGroupedDatabaseFields());
        }
        Collections.sort(tdfINList);
        Collections.sort(tdfOUTList);
        list.addAll(tdfINList);
        list.addAll(tdfOUTList);
        return list;
    }

    private SimulationField createSimulationFieldForVariable(Variable var) {
        return new SimulationField(var.getKey(), var.getValueObject(), var.isSelected());
    }

    @Override
    public abstract DataSet createDataSet();

    public abstract void fillDataSet(DataSet var1, ClassRepository var2);

    public void fillDataSet(DataSet data) {
        this.fillDataSet(data, this.myClassRepository);
        if (this.myFieldContextDataVariable != null) {
            this.myFieldContextDataVariable.fillDataSet(data, this.myClassRepository);
        }
    }

    private JComponent createSimulationDataTables(GroupedPanel panel) {
        JPanel basicPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        basicPanel.add((Component)scrollPane, "Center");
        return basicPanel;
    }

    @Override
    public void save(PrintWriter out) {
        out.println("<ERESimulationDataPanel service=\"" + this.myServiceContainer.getService().getId() + "\">");
        this.writeXMLSection(out, "Common", this.getCommonParameters());
        this.writeXMLSection(out, "Input", this.myInputVariables);
        this.writeXMLSection(out, "Output", this.myOutputVariables);
        if (this.myContextData != null) {
            String selectedContext = this.getSelectedContext();
            out.println("<Context name=\"" + selectedContext + "\">");
            ContextData contextData = this.myContextData.get(selectedContext);
            this.writeXMLSection(out, "Input", contextData.myInputVars);
            this.writeXMLSection(out, "Output", contextData.myOutputVars);
            out.println("</Context>");
        }
        out.println("</ERESimulationDataPanel>");
    }

    private void writeXMLSection(PrintWriter out, String sectionName, List<Variable> variables) {
        out.println("<Section name=\"" + sectionName + "\">");
        for (Variable var : variables) {
            var.writeXML(out);
        }
        out.println("</Section>");
    }

    @Override
    public List<SimulationDataDiff> init(Node iterator) {
        try {
            ArrayList<SimulationDataDiff> diffLists = new ArrayList<SimulationDataDiff>();
            if ("ERESimulationDataPanel".equals(iterator.getNodeName())) {
                boolean button;
                String serviceId = ((Element)iterator).getAttribute("service");
                if (!this.myServiceContainer.getService().getId().equals(serviceId) && !(button = DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Wrong service", "The selected file do not contain simulation data for this service.\nService Id == " + serviceId + ".\nContinue loading?"))) {
                    return null;
                }
                for (Element element : new ElementIterator(iterator.getChildNodes())) {
                    if (element.getNodeName().equals("Section")) {
                        this.updateSectionFromXML(element, diffLists);
                        continue;
                    }
                    if (!"Context".equals(element.getNodeName())) continue;
                    String contextName = element.getAttribute("name");
                    if (this.myContextData != null && this.myContextData.get(contextName) != null) {
                        ContextData data = this.myContextData.get(contextName);
                        NodeList sectionNodeList = element.getElementsByTagName("Section");
                        for (int ii = 0; ii < sectionNodeList.getLength(); ++ii) {
                            Collection<Variable> variables = CollectionUtils.combineCollections(data.myInputVars, data.myOutputVars);
                            this.updateSectionFromXML((Element)sectionNodeList.item(ii), variables, diffLists);
                        }
                        if (!this.hasContextParameters()) continue;
                        this.selectContext(contextName);
                        continue;
                    }
                    this.updateSectionFromXML(element, diffLists);
                }
            } else if ("RatingDataPanel".equals(iterator.getNodeName())) {
                NodeList children = iterator.getChildNodes();
                int childcount = children.getLength();
                if (childcount < 3) {
                    throw new IllegalArgumentException("Not enough data for RatingDataPanel, childCount = " + Integer.valueOf(childcount));
                }
                Node basicNode = null;
                Node inputNode = null;
                Node outputNode = null;
                for (int i = 0; i < childcount; ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    if (basicNode == null) {
                        basicNode = node;
                        continue;
                    }
                    if (inputNode == null) {
                        inputNode = node;
                        continue;
                    }
                    if (outputNode == null) {
                        outputNode = node;
                        continue;
                    }
                    RmaDefs.loggerSimulator.warning("Unknown node: " + node.getNodeName());
                }
                this.updateVariablesFromXML((Element)basicNode, diffLists);
                this.updateVariablesFromXML((Element)inputNode, diffLists);
                this.updateVariablesFromXML((Element)outputNode, diffLists);
            }
            return diffLists;
        }
        catch (Exception x) {
            x.printStackTrace();
            String msg = "Failed to open simulator data\nDetails: " + x.toString();
            DialogFactory.getErrorDialog("Failed reading simulator data", msg);
            return null;
        }
    }

    @Override
    public void init(Object[] columns, Object[] values) {
        Map<String, Variable> variables = AbstractGroupedSimulationDataPanel.getVariableByKeyMap(null, this.getCommonParameters(), this.myInputVariables, this.myOutputVariables);
        for (int i = 0; i < columns.length; ++i) {
            Variable var = variables.get(columns[i]);
            if (var instanceof GroupedArrayVariable) continue;
            var.setValue(values[i]);
        }
    }

    @Override
    public void init(Object[] columns, Object[] values, Boolean[] isSelected) {
        String contextValue = null;
        String contextFieldIdentifier = this.myClassRepository.getContextFieldIdentifier();
        if (contextFieldIdentifier != null) {
            int contextColId = -1;
            for (int ii = 0; ii < columns.length; ++ii) {
                if (!columns[ii].equals(contextFieldIdentifier)) continue;
                contextColId = ii;
                break;
            }
            if (contextColId > -1 && values[contextColId] instanceof String) {
                contextValue = (String)values[contextColId];
                this.selectContext(contextValue);
            }
        }
        Map<String, List<Variable>> listMap = AbstractGroupedSimulationDataPanel.getVariableByKeyListMap(null, this.myCommonVars, this.myInputVariables, this.myOutputVariables);
        if (this.myContextData != null) {
            for (Map.Entry<String, ContextData> entry : this.myContextData.entrySet()) {
                String contextName = entry.getKey();
                ContextData contextData = entry.getValue();
                listMap.putAll(AbstractGroupedSimulationDataPanel.getVariableByKeyListMap(contextName, contextData.myInputVars, contextData.myOutputVars));
            }
        }
        int counter = 0;
        for (int i = 0; i < columns.length; ++i) {
            Variable var;
            List<Variable> vars = listMap.get(columns[i]);
            if (vars == null) continue;
            int listSize = vars.size();
            if (listSize == 1) {
                var = vars.get(0);
            } else {
                var = vars.get(counter);
                ++counter;
            }
            counter = listSize == counter ? 0 : counter;
            var.setValue(values[i]);
            var.setSelected(i < isSelected.length ? isSelected[i] : false);
        }
    }

    public static Map<String, List<Variable>> getVariableByKeyListMap(String contextName, List<Variable> ... varLists) {
        HashMap<String, List<Variable>> map = new HashMap<String, List<Variable>>();
        Variable prevVar = null;
        ArrayList<Variable> varList = null;
        for (List<Variable> list : varLists) {
            for (Variable var : list) {
                if (prevVar == null || !prevVar.getKey().equals(var.getKey())) {
                    varList = new ArrayList<Variable>();
                }
                varList.add(var);
                String key = contextName == null ? var.getKey() : contextName + CONTEXT_DELIMITER + var.getKey();
                map.put(key, varList);
                prevVar = var;
            }
        }
        return map;
    }

    public static Map<String, Variable> getVariableByKeyMap(String contextName, List<Variable> ... varLists) {
        HashMap<String, Variable> map = new HashMap<String, Variable>();
        for (List<Variable> list : varLists) {
            for (Variable var : list) {
                String key = contextName == null ? var.getKey() : contextName + CONTEXT_DELIMITER + var.getKey();
                map.put(key, var);
            }
        }
        return map;
    }

    @Override
    public List<SimulationDataDiff> compareFields(List<SimulationField> fields) {
        ArrayList<SimulationDataDiff> diffList = new ArrayList<SimulationDataDiff>();
        ArrayList<Variable> vars = new ArrayList<Variable>(this.myInputVariables.size() + this.myOutputVariables.size() + 10);
        vars.addAll(this.getCommonParameters());
        vars.addAll(this.myInputVariables);
        vars.addAll(this.myOutputVariables);
        HashMap<String, Variable> varsHash = new HashMap<String, Variable>();
        for (Variable variable : vars) {
            varsHash.put(variable.getKey().toUpperCase(), variable);
        }
        if (this.myContextData != null) {
            varsHash.put(this.myContextIdentifierVariable.getLabel().toUpperCase(), this.myContextIdentifierVariable);
            for (Map.Entry entry : this.myContextData.entrySet()) {
                ContextData contextData = (ContextData)entry.getValue();
                for (Variable inputVar : contextData.myInputVars) {
                    varsHash.put(((String)entry.getKey()).toUpperCase() + CONTEXT_DELIMITER + inputVar.getKey().toUpperCase(), inputVar);
                }
                for (Variable outputVar : contextData.myOutputVars) {
                    varsHash.put(((String)entry.getKey()).toUpperCase() + CONTEXT_DELIMITER + outputVar.getKey().toUpperCase(), outputVar);
                }
            }
        }
        HashMap<String, SimulationField> fieldsHash = new HashMap<String, SimulationField>();
        for (SimulationField field : fields) {
            fieldsHash.put(field.getName().toUpperCase(), field);
        }
        for (SimulationField field : fields) {
            Variable var = (Variable)varsHash.get(field.getName().toUpperCase());
            if (var != null) continue;
            diffList.add(new SimulationDataDiff(1, field.getName(), null));
        }
        for (Variable var : vars) {
            SimulationField field = (SimulationField)fieldsHash.get(var.getKey().toUpperCase());
            if (field != null) continue;
            diffList.add(new SimulationDataDiff(2, var.getKey(), null));
        }
        return diffList;
    }

    private void updateSectionFromXML(Element parent, List<SimulationDataDiff> diffList) {
        Collection<Variable> variables = CollectionUtils.combineCollections(this.getCommonParameters(), this.myInputVariables, this.myOutputVariables);
        this.updateSectionFromXML(parent, variables, diffList);
    }

    private String trimLeadingAndTrailingNewLines(String value) {
        String v = value;
        if (v.startsWith("\n")) {
            v = v.substring(1);
        }
        if (v.endsWith("\n")) {
            v = v.substring(0, v.length() - 1);
        }
        return v;
    }

    private void updateSectionFromXML(Element parent, Collection<Variable> variables, List<SimulationDataDiff> diffList) {
        HashMap varsHash = new HashMap();
        Variable prevVar = null;
        ArrayList<Variable> list = null;
        for (Variable var : variables) {
            if (prevVar == null || !prevVar.getKey().equals(var.getKey())) {
                list = new ArrayList<Variable>();
            }
            list.add(var);
            varsHash.put(var.getKey(), list);
            prevVar = var;
        }
        NodeList varList = parent.getElementsByTagName("Variable");
        int counter = 0;
        int len = varList.getLength();
        for (int i = 0; i < len; ++i) {
            List vars;
            Element element = (Element)varList.item(i);
            String key = element.getAttribute("key");
            String label = element.getAttribute("label");
            String value = element.getAttribute("value");
            boolean isSelected = Boolean.parseBoolean(element.getAttribute("selected"));
            if (key.length() == 0) {
                key = label;
            }
            if ((vars = (List)varsHash.get(key)) != null) {
                int listSize = vars.size();
                if (listSize == 1) {
                    this.updateVariable((Variable)vars.get(0), element, value, key, isSelected);
                } else {
                    this.updateVariable((Variable)vars.get(counter), element, value, key, isSelected);
                    ++counter;
                }
                counter = listSize == counter ? 0 : counter;
                continue;
            }
            if (this.checkForKnownDiff(label, value, isSelected)) continue;
            diffList.add(new SimulationDataDiff(1, label, value));
        }
    }

    private void updateVariable(Variable var, Element element, String value, String key, boolean isSelected) {
        if (var instanceof MultilineStringVariable) {
            String trimmed = this.trimLeadingAndTrailingNewLines(element.getTextContent());
            var.setValue(trimmed);
        } else if (this.shouldInitVariableFromXML(var)) {
            try {
                ((BaseVariable)var).initFromXml(element, value, key, -1);
            }
            catch (UnsupportedOperationException ex) {
                var.setValue(value);
            }
        } else {
            var.setValue(value);
        }
        var.setSelected(isSelected);
    }

    private boolean shouldInitVariableFromXML(Variable var) {
        return var instanceof PanelVariable || var instanceof ArrayVariable || var instanceof GroupedArrayVariable;
    }

    private void updateVariablesFromXML(Element parent, List<SimulationDataDiff> diffList) {
        NodeList selected = parent.getElementsByTagName("Boolean");
        NodeList varList = parent.getElementsByTagName("Variable");
        int len = varList.getLength();
        for (int i = 0; i < len; ++i) {
            Element element = (Element)varList.item(i);
            boolean isSelected = XMLUtil.getFirstTextContent(selected.item(i)).equalsIgnoreCase("true");
            String label = element.getAttribute("label");
            String format = element.getAttribute("format");
            String value = element.getAttribute("value");
            if ("5000".equals(format)) {
                NodeList valueList = element.getElementsByTagName("value");
                value = "";
                for (int ii = 0; ii < valueList.getLength(); ++ii) {
                    value = value + XMLUtil.getFirstTextContent(valueList.item(ii)) + (ii < valueList.getLength() - 1 ? "," : "");
                }
            }
            Variable temp = null;
            temp = VarListUtil.getVariableForKey(this.getCommonParameters(), label);
            if (temp == null) {
                temp = VarListUtil.getVariableForKey(this.myInputVariables, label);
            }
            if (temp == null) {
                temp = VarListUtil.getVariableForKey(this.myOutputVariables, label);
            }
            if (temp != null && temp instanceof BaseVariable && !(temp instanceof GroupedArrayVariable)) {
                if (temp instanceof ArrayVariable) {
                    ((ArrayVariable)temp).initFromXml(element, value, label, 5000);
                } else if (temp instanceof MultilineStringVariable) {
                    ((MultilineStringVariable)temp).setValue(XMLUtil.getFirstTextContent(element));
                } else {
                    ((BaseVariable)temp).setValue(value);
                }
                temp.setSelected(isSelected);
                continue;
            }
            if (this.checkForKnownDiff(label, value, isSelected)) continue;
            diffList.add(new SimulationDataDiff(1, label, value));
        }
    }

    private boolean checkForKnownDiff(String label, String value, boolean isSelected) {
        if ("Duration".equals(label) || "Start time".equals(label) || "Expected duration".equals(label) || "Expected cost".equals(label)) {
            return true;
        }
        if ("Call event".equals(label)) {
            if ("Unsuccessful Call Setup (Final Report)".equals(value)) {
                Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Session setup result");
                ((DropDownVariable)temp).setSelectedItem("Unsuccessful");
            }
            return true;
        }
        if ("Selected Accumulator".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Selected accumulator");
            String tempValue = "0".equals(value) ? "None" : "ID " + value;
            ((BaseVariable)temp).setValue(tempValue);
            return true;
        }
        if ("Selected accumulator".equals(label)) {
            return true;
        }
        if ("Selected dedicated account".equals(label)) {
            StringTokenizer token = new StringTokenizer(value, ",");
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Selected dedicated account ID");
            int cnter = 0;
            while (token.hasMoreElements()) {
                AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(++cnter, (GroupedArrayVariable)temp, token.nextToken(), isSelected);
            }
            return true;
        }
        if ("Selected dedicated account ID".equals(label)) {
            StringTokenizer token = new StringTokenizer(value, ",");
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Selected dedicated account ID");
            int cnter = 0;
            while (token.hasMoreElements()) {
                AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(++cnter, (GroupedArrayVariable)temp, token.nextToken(), isSelected);
            }
            return true;
        }
        if ("Affected dedicated account ID".equals(label)) {
            StringTokenizer token = new StringTokenizer(value, ",");
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Affected dedicated accounts");
            int cnter = 0;
            while (token.hasMoreElements()) {
                AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(++cnter, (GroupedArrayVariable)temp, token.nextToken(), isSelected);
            }
            return true;
        }
        if ("Max cost".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Main account");
            if (temp != null) {
                ((BaseVariable)temp).setValue(value);
                temp.setSelected(isSelected);
            }
            return true;
        }
        if ("Bonus dedicated account 1".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Bonus dedicated account");
            AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(1, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Bonus dedicated account 2".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Bonus dedicated account");
            AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(2, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Bonus dedicated account 3".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Bonus dedicated account");
            AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(3, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Bonus dedicated account 4".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Bonus dedicated account");
            AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(4, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Bonus dedicated account 5".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Bonus dedicated account");
            AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(5, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Bonus dedicated account 6".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Bonus dedicated account");
            AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(6, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Bonus dedicated account 7".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Bonus dedicated account");
            AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(7, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Bonus dedicated account 8".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Bonus dedicated account");
            AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(8, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Bonus dedicated account 9".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Bonus dedicated account");
            AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(9, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Bonus dedicated account 10".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Bonus dedicated account");
            AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(10, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Expiry date dedicated account 1".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account expiry date");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDateGroupedArrayVariable(1, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Expiry date dedicated account 2".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account expiry date");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDateGroupedArrayVariable(2, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Expiry date dedicated account 3".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account expiry date");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDateGroupedArrayVariable(3, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Expiry date dedicated account 4".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account expiry date");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDateGroupedArrayVariable(4, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Expiry date dedicated account 5".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account expiry date");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDateGroupedArrayVariable(5, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Expiry date dedicated account 6".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account expiry date");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDateGroupedArrayVariable(6, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Expiry date dedicated account 7".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account expiry date");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDateGroupedArrayVariable(7, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Expiry date dedicated account 8".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account expiry date");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDateGroupedArrayVariable(8, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Expiry date dedicated account 9".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account expiry date");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDateGroupedArrayVariable(9, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Expiry date dedicated account 10".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account expiry date");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDateGroupedArrayVariable(10, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 1 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(1, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 2 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(2, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 3 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(3, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 4 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(4, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 5 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(5, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 6 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(6, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 7 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(7, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 8 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(8, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 9 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(9, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 10 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(10, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 1".equals(label) || "Balance dedicated account 1".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(1, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 2".equals(label) || "Balance dedicated account 2".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(2, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 3".equals(label) || "Balance dedicated account 3".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(3, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 4".equals(label) || "Balance dedicated account 4".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(4, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 5".equals(label) || "Balance dedicated account 5".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(5, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 6".equals(label) || "Balance dedicated account 6".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(6, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 7".equals(label) || "Balance dedicated account 7".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(7, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 8".equals(label) || "Balance dedicated account 8".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(8, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 9".equals(label) || "Balance dedicated account 9".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(9, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Dedicated account 10".equals(label) || "Balance dedicated account 10".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Dedicated account value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateDoubleGroupedArrayVariable(10, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator 1 value".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Accumulator value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(1, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator 2 value".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Accumulator value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(2, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator 3 value".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Accumulator value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(3, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator 4 value".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Accumulator value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(4, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator 5 value".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Accumulator value");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(5, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator 1 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Accumulator activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(1, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator 2 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Accumulator activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(2, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator 3 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Accumulator activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(3, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator 4 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Accumulator activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(4, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator 5 activated".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myInputVariables, "Accumulator activated");
            if (temp != null) {
                AbstractGroupedSimulationDataPanel.updateBooleanGroupedArrayVariable(5, (GroupedArrayVariable)temp, value, isSelected);
            }
            return true;
        }
        if ("Accumulator delta 1".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Accumulator delta");
            AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(1, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Accumulator delta 2".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Accumulator delta");
            AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(2, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Accumulator delta 3".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Accumulator delta");
            AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(3, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Accumulator delta 4".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Accumulator delta");
            AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(4, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        if ("Accumulator delta 5".equals(label)) {
            Variable temp = VarListUtil.getVariableForKey(this.myOutputVariables, "Accumulator delta");
            AbstractGroupedSimulationDataPanel.updateIntegerGroupedArrayVariable(5, (GroupedArrayVariable)temp, value, isSelected);
            return true;
        }
        return false;
    }

    private static void updateDateGroupedArrayVariable(int index, GroupedArrayVariable var, String value, boolean isSelected) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'hhmmssSSS");
        Date[] arr = (Date[])var.getValueObject();
        Object[] values = new Date[index];
        Arrays.fill(values, new Date());
        for (int ii = 0; ii < arr.length; ++ii) {
            values[ii] = arr[ii];
        }
        try {
            values[index - 1] = sdf.parse(value);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        var.setValue(values);
        var.setSelected(isSelected);
    }

    private static void updateBooleanGroupedArrayVariable(int index, GroupedArrayVariable var, String value, boolean isSelected) {
        Boolean[] arr = (Boolean[])var.getValueObject();
        Object[] values = new Boolean[index];
        Arrays.fill(values, (Object)false);
        for (int ii = 0; ii < arr.length; ++ii) {
            values[ii] = arr[ii];
        }
        values[index - 1] = Boolean.valueOf(value);
        var.setValue(values);
        var.setSelected(isSelected);
    }

    private static void updateIntegerGroupedArrayVariable(int index, GroupedArrayVariable var, String value, boolean isSelected) {
        Integer[] arr = (Integer[])var.getValueObject();
        Object[] values = new Integer[index];
        Arrays.fill(values, (Object)0);
        for (int ii = 0; ii < arr.length; ++ii) {
            values[ii] = arr[ii];
        }
        values[index - 1] = Integer.valueOf(value);
        var.setValue(values);
        var.setSelected(isSelected);
    }

    private static void updateDoubleGroupedArrayVariable(int index, GroupedArrayVariable var, String value, boolean isSelected) {
        Double[] arr = (Double[])var.getValueObject();
        Object[] values = new Double[index];
        Arrays.fill(values, (Object)0.0);
        for (int ii = 0; ii < arr.length; ++ii) {
            values[ii] = arr[ii];
        }
        values[index - 1] = Double.valueOf(value);
        var.setValue(values);
        var.setSelected(isSelected);
    }

    @Override
    public boolean isModified() {
        for (Variable inputVar : this.myInputVariables) {
            if (!inputVar.isModified()) continue;
            return true;
        }
        for (Variable outputVar : this.myOutputVariables) {
            if (!outputVar.isModified()) continue;
            return true;
        }
        for (Variable commonVar : this.myCommonVars) {
            if (!commonVar.isModified()) continue;
            return true;
        }
        for (ContextData contextData : this.myContextData.values()) {
            for (Variable var : contextData.myInputVars) {
                if (!var.isModified()) continue;
                return true;
            }
            for (Variable var : contextData.myOutputVars) {
                if (!var.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void resetModified() {
        for (Variable inputVar : this.myInputVariables) {
            if (!inputVar.isModified()) continue;
            inputVar.resetModified();
        }
        for (Variable outputVar : this.myOutputVariables) {
            if (!outputVar.isModified()) continue;
            outputVar.resetModified();
        }
        for (Variable commonVar : this.myCommonVars) {
            if (!commonVar.isModified()) continue;
            commonVar.resetModified();
        }
        for (ContextData contextData : this.myContextData.values()) {
            for (Variable var : contextData.myInputVars) {
                var.resetModified();
            }
            for (Variable var : contextData.myOutputVars) {
                var.resetModified();
            }
        }
    }

    public void setTitleVariable(Variable title) {
        this.myTitleVariable = title;
    }

    @Override
    public void setSimulationPanelChangedCallback(SimulationDataPanelChangeListener listener) {
        this.myPanelChangeHandler = listener;
    }

    @Override
    public String getTitle() {
        return this.myTitleVariable.getValueString();
    }

    @Override
    public Object getDataItem() {
        return null;
    }

    @Override
    public Object getDataItem(Object reference) {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public void setDataItem(Object reference, Object object) {
        if (this.myPanelChangeHandler != null) {
            String fieldName = (String)reference;
            if (!(this.myContextData == null || this.myContextIdentifierVariable == object || this.myInputVariables.contains(object) || this.myOutputVariables.contains(object) || this.myCommonVars.contains(object))) {
                fieldName = this.getSelectedContext() + CONTEXT_DELIMITER + fieldName;
            }
            Object panelData = ((Variable)object).getValueObject();
            this.myPanelChangeHandler.simulationDataPanelChanged(this, fieldName, panelData);
        }
    }

    @Override
    public boolean isSimulationDataValid() {
        return this.myVariableList.isValid();
    }

    @Override
    public void setDataItem(Object object) {
    }

    @Override
    public void postProcessDataSet(DataSet dataSet) {
    }

    @Override
    public void preProcessDataSet(DataSet dataSet) {
    }

    @Override
    public boolean validate(DataSet dataSet, List<String> info) {
        return true;
    }

    private List<Variable> buildTreeDefinedFieldsFromRepository(List<FieldDefinition> intvarFieldDefList, String type, SimulationPanelHelper simPanelHelper) {
        ArrayList<Variable> varList = new ArrayList<Variable>();
        for (FieldDefinition def : intvarFieldDefList) {
            Variable var = simPanelHelper.createVariableFromField(def);
            if ("IN".equals(type)) {
                var.setLabel(var.getLabel() + " (IN)");
                var.myIcon = RmaDefs.getImageIcon("field_in.png");
            } else if ("OUT".equals(type)) {
                var.setLabel(var.getLabel() + " (OUT)");
                var.myIcon = RmaDefs.getImageIcon("field_out.png");
            }
            varList.add(var);
        }
        return varList;
    }

    private JComponent buildClosableTreeDefinedFieldVarComponent(SimulationPanelHelper simPanelHelper2) {
        this.myTreeDefinedFieldDefs = this.getTreeDefinedFieldDefinitionList();
        List<Variable> treeDefinedFieldVarListIn = this.buildTreeDefinedFieldsFromRepository(this.myTreeDefinedFieldDefs, "IN", simPanelHelper2);
        List<Variable> treeDefinedFieldVarListOut = this.buildTreeDefinedFieldsFromRepository(this.myTreeDefinedFieldDefs, "OUT", simPanelHelper2);
        ArrayList<JPanel> compList = new ArrayList<JPanel>();
        this.myInputVariables.addAll(treeDefinedFieldVarListIn);
        this.myOutputVariables.addAll(treeDefinedFieldVarListOut);
        ArrayList<Variable> allTDFs = new ArrayList<Variable>();
        allTDFs.addAll(treeDefinedFieldVarListIn);
        allTDFs.addAll(treeDefinedFieldVarListOut);
        JPanel TDFPanel = simPanelHelper2.createVarTable(allTDFs);
        if (TDFPanel != null) {
            compList.add(TDFPanel);
        }
        if (compList.size() > 0) {
            ClosableVarPanel panel = new ClosableVarPanel(LBL_TREE_DEFINED_FIELDS, true, compList);
            return panel;
        }
        return null;
    }

    private boolean areTDFFieldDefinitionsEquals(FieldDefinition def1, FieldDefinition def2) {
        if (def1.getTypedDataType() != def2.getTypedDataType()) {
            return false;
        }
        if (!def1.getDefaultValue().equals(def2.getDefaultValue())) {
            return false;
        }
        Element firstDefEditComponent = TreeDefinedFieldXmlUtil.getEditComponent((Element)def1.getDefinitionNode());
        Element secondDefEditComponent = TreeDefinedFieldXmlUtil.getEditComponent((Element)def2.getDefinitionNode());
        if (firstDefEditComponent == null && secondDefEditComponent == null) {
            return true;
        }
        if (this.isRange(firstDefEditComponent) && this.isRange(secondDefEditComponent)) {
            String min2;
            String min = TreeDefinedFieldXmlUtil.getMinValueForRangeEditor(firstDefEditComponent);
            if (!min.equals(min2 = TreeDefinedFieldXmlUtil.getMinValueForRangeEditor(secondDefEditComponent))) {
                return false;
            }
            String max = TreeDefinedFieldXmlUtil.getMaxValueForRangeEditor(firstDefEditComponent);
            String max2 = TreeDefinedFieldXmlUtil.getMaxValueForRangeEditor(secondDefEditComponent);
            return max.equals(max2);
        }
        if (this.isEnumeration(firstDefEditComponent) && this.isEnumeration(secondDefEditComponent)) {
            ArrayModel enumModel1 = TreeDefinedFieldXmlUtil.getEnumArrayForEditor(firstDefEditComponent, def1.getTypedDataType());
            ArrayModel enumModel2 = TreeDefinedFieldXmlUtil.getEnumArrayForEditor(secondDefEditComponent, def2.getTypedDataType());
            return enumModel1.toMap().equals(enumModel2.toMap());
        }
        return false;
    }

    private boolean isRange(Element e) {
        return e == null ? false : e.getAttribute("class").equals("ericsson.ere.gui.util.NumberRangeEditor") || e.getAttribute("Type").equals("Range");
    }

    private boolean isEnumeration(Element e) {
        return e == null ? false : e.getAttribute("class").equals("ericsson.ere.gui.util.EnumEditor") || e.getAttribute("Type").equals("Enum");
    }

    @Override
    public List<FieldDefinition> getTreeDefinedFieldDefinitionList() {
        ArrayList<FieldDefinition> treeDefinedFieldDefList = new ArrayList<FieldDefinition>();
        List<FieldDefinition> allFields = this.myClassRepository.getFieldDefinitions();
        for (FieldDefinition def : allFields) {
            if (!"INTERNAL".equals(def.getParameterType())) continue;
            treeDefinedFieldDefList.add(def);
        }
        Collections.sort(treeDefinedFieldDefList);
        return treeDefinedFieldDefList;
    }

    @Override
    public List<SimulationDataDiff> getTDFUpdates() {
        boolean found;
        ArrayList<SimulationDataDiff> diffList = new ArrayList<SimulationDataDiff>();
        List<FieldDefinition> intFieldDefList = this.getTreeDefinedFieldDefinitionList();
        for (FieldDefinition newdef : intFieldDefList) {
            found = false;
            for (FieldDefinition currentDef : this.myTreeDefinedFieldDefs) {
                if (!newdef.getFieldName().equals(currentDef.getFieldName())) continue;
                found = true;
                if (this.areTDFFieldDefinitionsEquals(newdef, currentDef)) continue;
                diffList.add(new SimulationDataDiff(3, newdef.getFieldName(), newdef.getDefaultValue()));
                break;
            }
            if (found) continue;
            diffList.add(new SimulationDataDiff(2, newdef.getFieldName(), newdef.getDefaultValue()));
        }
        for (FieldDefinition currentDef : this.myTreeDefinedFieldDefs) {
            found = false;
            for (FieldDefinition newDef : intFieldDefList) {
                if (!newDef.getFieldName().equals(currentDef.getFieldName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            diffList.add(new SimulationDataDiff(1, currentDef.getFieldName(), currentDef.getDefaultValue()));
        }
        return diffList;
    }

    @Override
    public boolean needsTDFUpdate() {
        return this.getTDFUpdates().size() > 0;
    }

    @Override
    public void updateTDFsInPanel() {
    }

    @Override
    public void addVariableSelectionListener(ChangeListener listener) {
        if (!this.myVariableSelectionListeners.contains(listener)) {
            this.myVariableSelectionListeners.add(listener);
        }
    }

    @Override
    public List<TDFAdditionalObject> getAdditionalTDFVariables() {
        ArrayList<TDFAdditionalObject> varList = new ArrayList<TDFAdditionalObject>();
        TDFAdditionalObject writeToCDRVar = new TDFAdditionalObject();
        writeToCDRVar.createBooleanAdditionalVar("Write to CDR", true);
        TDFAdditionalObject sessionWide = new TDFAdditionalObject();
        writeToCDRVar.createBooleanAdditionalVar("Session wide", false);
        varList.add(writeToCDRVar);
        varList.add(sessionWide);
        return varList;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Variable var = (Variable)e.getSource();
        String fieldName = this.getUniqueName(var);
        SimulationField field = new SimulationField(fieldName, var.getValueObject(), var.isSelected());
        ChangeEvent changeEvent = new ChangeEvent(field);
        for (ChangeListener listener : this.myVariableSelectionListeners) {
            listener.stateChanged(changeEvent);
        }
    }

    private String getUniqueName(Variable variable) {
        String name = variable.getKey();
        if (!(this.myContextData == null || this.myContextIdentifierVariable == variable || this.myInputVariables.contains(variable) || this.myOutputVariables.contains(variable) || this.myCommonVars != null && this.myCommonVars.contains(variable))) {
            name = this.getSelectedContext() + CONTEXT_DELIMITER + name;
        }
        return name;
    }

    public List<JComponent> getComponentList() {
        return this.myComponentList;
    }

    public String convertSimulationDataObjectToString(Object o) {
        return this.convertSimulationDataObjectToString(o, null);
    }

    protected String convertSimulationDataObjectToString(Object o, DataType dataType) {
        if (o == null) {
            return "";
        }
        if (dataType == null) {
            return DataType.valueToString(o);
        }
        return dataType.makeDisplayString(o);
    }

    protected String describeObject(Object object, DataType dataType) {
        return this.myDataDescriber.describeObject(object, dataType);
    }

    protected String describeObject(Object object, FieldDefinition fd) {
        return this.myDataDescriber.describeObject(object, fd);
    }

    private class VariableChangeHandler
    implements VariableChangeListener {
        private VariableChangeHandler() {
        }

        @Override
        public void valueChanged(VariableChangeEvent event) {
            AbstractGroupedSimulationDataPanel.this.setDataItem(event.getVariable().getKey(), event.getVariable());
        }
    }

    private static class GroupComponentNamer
    extends AbstractSwingComponentNamer {
        public GroupComponentNamer(NamingStrategy strategy) {
            super(strategy);
        }

        @Override
        protected boolean shouldTraverseComponentChildren(Component c) {
            return true;
        }
    }

    protected static class ContextData {
        public String myName;
        public List<Variable> myInputVars = new ArrayList<Variable>();
        public List<Variable> myOutputVars = new ArrayList<Variable>();
        public List<JComponent> myPanels = null;

        public ContextData(String name) {
            this.myName = name;
        }
    }
}

