/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DataDescriber;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetAccessor;
import com.ericsson.ere.dataset.DefaultDataSetAccessor;
import com.ericsson.ere.dataset.DefaultValueContainer;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.dataset.ValueContainer;
import com.ericsson.ere.dataset.task.DefaultTask;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.LazyEvaluatedValue;
import com.ericsson.ere.gui.simulator.AbstractGroupedSimulationDataPanel;
import com.ericsson.ere.gui.simulator.DefaultSimulationDataPanelValidator;
import com.ericsson.ere.gui.simulator.SimulationPanelHelper;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.GroupedArrayVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.GroupedObjectArrayVariable;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import ericsson.vareditor.variable.array.ObjectMapModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

public class GroupedDataSetSimulationPanel
extends AbstractGroupedSimulationDataPanel {
    protected static final String LABEL_DESCRIPTION = "Description";
    protected static final String LABEL_START_TIME = "Start time";
    protected String myDescription;
    protected StringVariable myDescriptionVariable;

    public GroupedDataSetSimulationPanel(Service service) {
        super(service);
    }

    public GroupedDataSetSimulationPanel(ContextAwareServiceContainer serviceContainer) {
        super(serviceContainer);
    }

    @Override
    public DataSet createDataSet() {
        DataSet set = this.myServiceContainer.getService().getDataSet();
        this.fillDataSet(set);
        String rpName = this.myServiceContainer.getFieldContext().getRatingPlanName();
        String spName = this.myServiceContainer.getFieldContext().getServiceProviderStringKey();
        String serviceName = this.myServiceContainer.getService().getId();
        RatingPlan ratingPlan = this.createRatingPlanWithoutRatingPeriods(rpName, spName, serviceName);
        set.setCurrentRatingPlan(ratingPlan);
        return set;
    }

    protected RatingPlan createRatingPlanWithoutRatingPeriods(String ratingPlanName, String serviceProviderName, String serviceName) {
        ServiceProvider provider = new ServiceProvider(serviceProviderName);
        RatingPlan plan = new RatingPlan(provider, ratingPlanName, ratingPlanName, serviceName);
        return plan;
    }

    @Override
    public void fillDataSet(DataSet theSet, ClassRepository repository) {
        theSet.setTreeTask(new DefaultTask());
        for (Variable var : this.getCommonParameters()) {
            if (!var.getLabel().equals(LABEL_START_TIME) || !var.isSelected()) continue;
            Calendar startTime = ((ERETime)var.getValueObject()).asCalendar();
            ((AbstractDataSet)theSet).setStartTime(startTime);
        }
        this.initDatasetFromInputPanel(theSet, this.getAllInputParameters());
    }

    private void setVariableValueInDataSet(DataSet ds, DataSetAccessor anAcc, Variable aVariable, FieldHierarchyNode parent) {
        if (aVariable instanceof GroupedObjectArrayVariable) {
            ObjectArrayModel model = (ObjectArrayModel)((GroupedObjectArrayVariable)aVariable).getModel();
            if (parent == null) {
                this.initDataSetWithObjectArrayModelValues(model, anAcc);
            } else {
                this.initDataSetWithFieldHierarchyObjectArrayModelValues(model, anAcc, (FieldStructure)parent);
            }
        } else {
            Object valueObject = this.getValueFromVariable(ds, aVariable, parent);
            anAcc.setValue(parent, null, null, valueObject);
        }
    }

    private void initDataSetWithFieldHierarchyObjectArrayModelValues(ObjectArrayModel model, DataSetAccessor anAcc, FieldStructure parent) {
        Object valueObject = null;
        switch (parent.getComplexType()) {
            case SET: {
                valueObject = this.modelToHierarchicalSet(model, parent);
                break;
            }
            case MAP: 
            case ARRAY: {
                valueObject = this.modelToHierarchicalMap(model, parent, anAcc);
                break;
            }
        }
        anAcc.setValue(parent, null, null, valueObject);
    }

    private Object getValueFromVariable(DataSet ds, Variable aVariable, FieldHierarchyNode field) {
        Object valueObject;
        if (aVariable instanceof DropDownVariable) {
            valueObject = SimulationPanelHelper.convertToCorrectDataType((DropDownVariable)aVariable, this.myClassRepository);
        } else if (aVariable instanceof GroupedArrayVariable) {
            valueObject = this.convertArrayModelToDataSetValue((ArrayModel)aVariable.getValueObject(), field);
        } else {
            valueObject = aVariable.getValueObject();
            if (valueObject instanceof LazyEvaluatedValue) {
                valueObject = ((LazyEvaluatedValue)valueObject).evaluate(ds);
            }
        }
        return valueObject;
    }

    private Object convertArrayModelToDataSetValue(ArrayModel model, FieldHierarchyNode field) {
        Object valueObject;
        if (model.possibleToConvertToOneDimensionalArray()) {
            valueObject = model.toOneDimensionalArray();
            if (field.getComplexType() == FieldHierarchyNode.ComplexType.SET) {
                valueObject = new LinkedHashSet<Object>(Arrays.asList(valueObject));
            }
        } else {
            valueObject = model.toMap();
        }
        return valueObject;
    }

    protected void initDatasetFromInputPanel(DataSet theSet, List<Variable> fields) {
        DefaultDataSetAccessor dataSetAccessor = new DefaultDataSetAccessor((AbstractDataSet)theSet);
        for (Variable var : fields) {
            if (!var.isSelected()) continue;
            String label = var.getKey();
            label = label.replaceAll(" \\(?(IN|OUT)\\)?$", "");
            FieldHierarchyNode field = this.myClassRepository.getFieldRepository().getFieldByName(label);
            if (field != null && dataSetAccessor.hasValue(field, null)) continue;
            this.setVariableValueInDataSet(theSet, dataSetAccessor, var, field);
        }
    }

    private void initDataSetWithObjectArrayModelValues(ObjectArrayModel model, DataSetAccessor anAcc) {
        for (int col = 0; col < model.getColumnCount(); ++col) {
            Object valueObject = model instanceof ObjectMapModel ? ((ObjectMapModel)model).getColumnMap(col) : model.getColumnArray(col);
            String columnName = model.getColumnName(col);
            FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(columnName);
            if (anAcc.hasValue(field, null)) continue;
            anAcc.setValue(field, null, null, valueObject);
        }
    }

    private Set<ValueContainer> modelToHierarchicalSet(ObjectArrayModel model, FieldStructure parent) {
        LinkedHashSet<ValueContainer> set = new LinkedHashSet<ValueContainer>();
        for (int row = 0; row < model.getRowCount(); ++row) {
            DefaultValueContainer cont = new DefaultValueContainer();
            for (int col = 0; col < model.getColumnCount(); ++col) {
                FieldHierarchyNode field = parent.getChildByName(model.getColumnName(col));
                Object value = this.convertValueIfNecessary(model.getValueAt(row, col), field);
                cont.setData(field, value, null);
            }
            set.add(cont);
        }
        return set;
    }

    private Map<Key, ValueContainer> modelToHierarchicalMap(ObjectArrayModel model, FieldStructure parent, DataSetAccessor anAcc) {
        LinkedHashMap<Key, ValueContainer> map = new LinkedHashMap<Key, ValueContainer>();
        List<FieldHierarchyNode> children = parent.getChildren();
        for (int row = 0; row < model.getRowCount(); ++row) {
            ArrayList<Object> keys = new ArrayList<Object>();
            ArrayList<Object> values = new ArrayList<Object>();
            for (int col = 0; col < model.getColumnCount(); ++col) {
                FieldHierarchyNode child = children.get(col);
                if (child.isKey()) {
                    keys.add(model.getValueAt(row, col));
                    continue;
                }
                values.add(this.convertValueIfNecessary(model.getValueAt(row, col), child));
            }
            ValueContainer cont = anAcc.entryOf(parent, values.toArray());
            Key key = keys.size() == 0 ? Key.asIndex(row) : (keys.size() == 1 ? Key.asKey(keys.get(0)) : Key.asKey(keys.toArray()));
            map.put(key, cont);
        }
        return map;
    }

    private Object convertValueIfNecessary(Object value, FieldHierarchyNode field) {
        Object convertedValue = value;
        if (value instanceof ArrayModel) {
            convertedValue = this.convertArrayModelToDataSetValue((ArrayModel)value, field);
        }
        return convertedValue;
    }

    @Override
    public Variable getTitleVariable() {
        return this.myDescriptionVariable;
    }

    @Override
    public List<Variable> getCommonParameters() {
        if (this.myCommonVars == null) {
            this.myCommonVars = new ArrayList();
            this.myDescription = "A descriptive text";
            this.myDescriptionVariable = new StringVariable(LABEL_DESCRIPTION, this.myDescription);
            this.myDescriptionVariable.setSelected(true);
            this.myCommonVars.add(this.myDescriptionVariable);
            this.myCommonVars.add(new DateAndTimeVariable(LABEL_START_TIME, DateAndTimeVariable.Content.DATE_TIME).setSelected(true));
            this.myCommonVars.add(new MultilineStringVariable("Comment", "").setSelected(true));
            this.addFieldContextDataVariableToCommonVariables(null);
        }
        return this.myCommonVars;
    }

    private DefaultSimulationDataPanelValidator createPanelValidator() {
        return new DefaultSimulationDataPanelValidator(this.myClassRepository, new DataDescriberProxy());
    }

    public boolean validate(DataSet dataset, List<String> info, List<Variable> varList) {
        return this.createPanelValidator().validate(dataset, info, varList);
    }

    @Override
    public boolean validate(DataSet dataset, List<String> info) {
        return this.createPanelValidator().validate(this, dataset, info);
    }

    @Deprecated
    protected void printFieldDiff(Variable variable, Object varToCompare, List<String> info) {
        this.printFieldDiff(variable.getLabel(), null, variable.getValueObject(), varToCompare, info);
    }

    @Deprecated
    protected void printFieldDiff(String label, DataType dataType, Object variableValue, Object dataSetValue, List<String> info) {
        this.createPanelValidator().printFieldDiff(label, dataType, variableValue, dataSetValue, info);
    }

    @Deprecated
    protected void printFieldDiff(FieldDefinition fd, Object variableValue, Object dataSetValue, List<String> info) {
        this.createPanelValidator().printFieldDiff(fd, variableValue, dataSetValue, info);
    }

    protected boolean compare(Object first, Object second) {
        boolean firstIsEREDate = first instanceof EREDate;
        boolean secondIsEREDate = second instanceof EREDate;
        if (firstIsEREDate || secondIsEREDate) {
            EREDate edate = firstIsEREDate ? (EREDate)first : (EREDate)second;
            Object other = firstIsEREDate ? second : first;
            return edate.equals(other);
        }
        if (first instanceof Date && second instanceof Date) {
            return DateUtil.areDatesEqual((Date)first, (Date)second);
        }
        if (first instanceof Amount && second instanceof Amount) {
            return ((Amount)first).isEqualTo((Amount)second);
        }
        return first.equals(second);
    }

    @Deprecated
    protected boolean compare(Object actualValue, ArrayModel expectedModel, FieldDefinition fieldDef) {
        return this.createPanelValidator().compare(actualValue, expectedModel);
    }

    @Override
    public void updateClassRepository(Node iterator) {
    }

    private class DataDescriberProxy
    implements DataDescriber {
        private DataDescriberProxy() {
        }

        @Override
        public String describeObject(Object object, FieldDefinition field) {
            return GroupedDataSetSimulationPanel.super.describeObject(object, field);
        }

        @Override
        public String describeObject(Object object, DataType dataType) {
            return GroupedDataSetSimulationPanel.super.describeObject(object, dataType);
        }
    }
}

