/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.ComplexKey;
import com.ericsson.ere.dataset.DataDescriber;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.gui.simulator.AbstractVariableValidator;
import com.ericsson.ere.gui.simulator.FieldBasedVariableProducerWrapper;
import com.ericsson.ere.selectiontree.util.FieldIndexFormatter;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.GroupedObjectArrayVariable;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import ericsson.vareditor.variable.array.ObjectMapModel;
import java.util.ArrayList;
import java.util.List;

public class GroupedObjectArrayVariableValidator
extends AbstractVariableValidator {
    public GroupedObjectArrayVariableValidator(ClassRepository repository, DataDescriber describer) {
        super(repository, describer);
    }

    @Override
    public boolean validateVariable(Variable variable, DataSet dataset, List<String> info) {
        ObjectArrayModel arrayModel = (ObjectArrayModel)((GroupedObjectArrayVariable)variable).getObjectArrayModel();
        List<String> validationInfo = this.performGroupedObjectArrayValidation(dataset, arrayModel, this.extractColumnDataList((GroupedObjectArrayVariable)variable));
        if (!validationInfo.isEmpty()) {
            info.add(this.removeSuffixFromLabel(variable.getLabel()) + " ---> comparing rows => false");
            info.addAll(validationInfo);
        }
        return validationInfo.isEmpty();
    }

    private List<String> performGroupedObjectArrayValidation(DataSet dataset, ObjectArrayModel model, List<DataSetField> columnList) {
        ArrayList<String> info = new ArrayList<String>();
        if (model instanceof ObjectMapModel) {
            this.validateObjectMapModel(dataset, (ObjectMapModel)model, columnList, info);
        } else {
            this.validateObjectArrayModel(dataset, model, columnList, info);
        }
        return info;
    }

    private void validateObjectArrayModel(DataSet dataset, ObjectArrayModel model, List<DataSetField> columns, List<String> info) {
        for (int rowIndex = 0; rowIndex < model.getRowCount(); ++rowIndex) {
            Object[] rowData = model.getRow(rowIndex);
            Key key = Key.asIndex(rowIndex);
            this.validateRowData(dataset, columns, info, rowData, key, rowIndex);
        }
    }

    private void validateObjectMapModel(DataSet dataset, ObjectMapModel model, List<DataSetField> columns, List<String> info) {
        int[] keyColumns;
        String fn = columns.get(0).getFieldName();
        for (int keyColumnIndex : keyColumns = model.getKeyColumns()) {
            columns.set(keyColumnIndex, null);
        }
        for (int rowIndex = 0; rowIndex < model.getRowCount(); ++rowIndex) {
            Object[] rowData = model.getRow(rowIndex);
            Object keyObject = this.extractKeyObject(keyColumns, rowData);
            Key key = Key.asKey(keyObject);
            FormattableKey formattableKey = new FormattableKey(fn, key, dataset);
            this.validateRowData(dataset, columns, info, rowData, key, formattableKey);
        }
    }

    private void validateRowData(DataSet dataset, List<DataSetField> columns, List<String> info, Object[] rowData, Key key, Object formattableKey) {
        String keyDesc = key.containsKey() ? "with key" : "index";
        for (int i = 0; i < columns.size(); ++i) {
            DataSetField dataSetField = columns.get(i);
            if (dataSetField == null) continue;
            Object expectedValue = rowData[i];
            try {
                Object actualValue = dataSetField.getValueFromDataSet(dataset, key);
                if (dataSetField.getDataType().areObjectsEqual(expectedValue, actualValue)) continue;
                String s = this.createRowDifferenceMessage(dataSetField, keyDesc, formattableKey, "differs");
                info.add(s);
            }
            catch (DataSetValueNotFoundException e) {
                String s = this.createRowDifferenceMessage(dataSetField, keyDesc, formattableKey, "not found in data set");
                info.add(s);
            }
            break;
        }
    }

    private String createRowDifferenceMessage(DataSetField dataSetField, String keyDesc, Object keyObject, String reason) {
        StringBuilder b = new StringBuilder("  - Row ");
        b.append(keyDesc);
        b.append(": ");
        b.append(keyObject);
        b.append(" => Value for '");
        b.append(dataSetField.getFieldName());
        b.append("' ");
        b.append(reason);
        return b.toString();
    }

    private Object extractKeyObject(int[] keyColumnIndices, Object[] rowData) {
        if (keyColumnIndices.length > 1) {
            Object[] keyObjects = new Object[keyColumnIndices.length];
            for (int i = 0; i < keyColumnIndices.length; ++i) {
                keyObjects[i] = rowData[keyColumnIndices[i]];
            }
            return ComplexKey.createComplexKeyWithValues(keyObjects);
        }
        if (keyColumnIndices.length == 1) {
            return rowData[keyColumnIndices[0]];
        }
        return null;
    }

    private List<DataSetField> extractColumnDataList(GroupedObjectArrayVariable variable) {
        FieldDefinition[] fields = variable.getInfo(FieldBasedVariableProducerWrapper.SOURCE_FIELDS);
        ArrayList<DataSetField> columnList = new ArrayList<DataSetField>();
        if (fields == null) {
            ObjectArrayModel arrayModel = (ObjectArrayModel)variable.getObjectArrayModel();
            for (int i = 0; i < arrayModel.getColumnCount(); ++i) {
                FieldDefinition fieldDefinition = this.myClassRepository.getFieldDefinitionByName(arrayModel.getColumnName(i));
                columnList.add(new DataSetField(fieldDefinition));
            }
        } else {
            for (FieldDefinition fd : fields) {
                columnList.add(new DataSetField(fd));
            }
        }
        return columnList;
    }

    private class FormattableKey {
        private final Key myKey;
        private final String myFieldName;
        private final DataSet myDataSet;

        FormattableKey(String fieldName, Key key, DataSet dataset) {
            this.myFieldName = fieldName;
            this.myKey = key;
            this.myDataSet = dataset;
        }

        public String toString() {
            FieldIndexFormatter formatter = new FieldIndexFormatter(this.myFieldName);
            formatter.setDataDescriber(GroupedObjectArrayVariableValidator.this.myDataDescriber);
            formatter.setExcludeMainFieldName(true);
            String keyString = formatter.format(this.myKey, null, this.myDataSet);
            boolean useBrackets = this.containsComplexKey();
            return useBrackets ? "[" + keyString + "]" : keyString;
        }

        private boolean containsComplexKey() {
            return this.myKey.containsKey() && this.myKey.getKey() instanceof ComplexKey;
        }
    }
}

