/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.RatingDataSet;
import com.ericsson.ere.dataset.task.AbstractTimeBasedTreeTask;
import com.ericsson.ere.dataset.task.ActiveTimeTask;
import com.ericsson.ere.dataset.task.ContinuousTimeTask;
import com.ericsson.ere.dataset.task.TimeBasedTask;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.gui.simulator.GroupedDataSetSimulationPanel;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.Service;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class GroupedRatingDataSetSimulationPanel
extends GroupedDataSetSimulationPanel {
    public static final String LABEL_DURATION = "Duration";
    public static final String LABEL_MAX_COST = "Max cost";
    public static final String LABEL_EXPECTED_COST = "Expected cost";
    public static final String LABEL_EXPECTED_DURATION = "Expected duration";
    public static final String TAG_EXPECTED_DURATION = "\u000bExpected duration\u000b";
    public static final String TAG_EXPECTED_COST = "\u000bExpected cost\u000b";
    protected static final int INITIAL_DURATION = 60;
    protected static final int INITIAL_EXPECTED_DURATION = 0;

    public GroupedRatingDataSetSimulationPanel(Service service) {
        super(service);
    }

    public GroupedRatingDataSetSimulationPanel(ContextAwareServiceContainer serviceContainer) {
        super(serviceContainer);
    }

    @Override
    public List<Variable> getCommonParameters() {
        if (this.myCommonVars == null) {
            this.myCommonVars = new ArrayList(7);
            this.myDescription = "A descriptive text";
            this.myDescriptionVariable = new StringVariable("Description", this.myDescription);
            this.myDescriptionVariable.setSelected(true);
            this.myCommonVars.add(this.myDescriptionVariable);
            this.myCommonVars.add(this.createDurationVariable().setSelected(true));
            this.myCommonVars.add(new DoubleVariable(LABEL_MAX_COST, 100.0).setSelected(true));
            this.myCommonVars.add(new DateAndTimeVariable("Start time", DateAndTimeVariable.Content.DATE_TIME).setSelected(true));
            this.myCommonVars.add(this.createExpectedDurationVariable().setSelected(false));
            this.myCommonVars.add(new DoubleVariable(LABEL_EXPECTED_COST, 0.0).setSelected(false));
            this.myCommonVars.add(new MultilineStringVariable("Comment", "").setSelected(true));
        }
        return this.myCommonVars;
    }

    protected Variable createDurationVariable() {
        return new IntegerVariable(LABEL_DURATION, 60);
    }

    protected Variable createExpectedDurationVariable() {
        return new LongVariable(LABEL_EXPECTED_DURATION, 0L);
    }

    @Override
    public void fillDataSet(DataSet theSet, ClassRepository repository) {
        RatingDataSet set = (RatingDataSet)theSet;
        set.setCurrentPriceFactor(new RatingDecimal(1L, 1L));
        boolean activeTime = false;
        for (Variable var : this.getCommonParameters()) {
            if (var.getLabel().equals("Description") && var.isSelected()) {
                String timeType = var.getValueString();
                if (timeType.equalsIgnoreCase("active")) {
                    activeTime = true;
                    continue;
                }
                activeTime = false;
                continue;
            }
            if (var.getLabel().equals("Start time") && var.isSelected()) {
                Calendar startTime = ((ERETime)var.getValueObject()).asCalendar();
                ((AbstractDataSet)theSet).setStartTime(startTime);
                continue;
            }
            if (var.getLabel().equals(LABEL_DURATION) && var.isSelected()) {
                AbstractTimeBasedTreeTask task = activeTime ? new ActiveTimeTask(((Integer)var.getValueObject()).intValue()) : this.createContinuousTimeTask(var);
                set.setTreeTask(task);
                continue;
            }
            if (!var.getLabel().equals(LABEL_MAX_COST) || !var.isSelected()) continue;
            String c = var.getValueString();
            set.setMaxCost(new RatingDecimal(c));
        }
        this.initDatasetFromInputPanel(theSet, this.getAllInputParameters());
    }

    protected ContinuousTimeTask createContinuousTimeTask(Variable durationVariable) {
        return new ContinuousTimeTask(((Integer)durationVariable.getValueObject()).intValue());
    }

    @Override
    public boolean validate(DataSet dataset, List<String> info) {
        RatingDataSet ratingDataSet = (RatingDataSet)dataset;
        boolean result = true;
        result = super.validate(dataset, info);
        for (Variable var : this.getCommonParameters()) {
            RatingDecimal realCost;
            RatingDecimal expectedCost;
            if (var.isSelected() && var.getLabel().equals(LABEL_EXPECTED_DURATION)) {
                TimeBasedTask timeTask = (TimeBasedTask)ratingDataSet.getTreeTask();
                Object allocatedDuration = this.getAllocatedDurationFromTimeTask(timeTask);
                if (!var.getValueObject().equals(allocatedDuration)) {
                    result = false;
                    info.add("Expected duration " + var.getValueString() + "s. Real duration " + allocatedDuration);
                }
            }
            if (var.isSelected() && var.getLabel().equals(LABEL_EXPECTED_COST) && !(expectedCost = new RatingDecimal(var.getValueString())).equals(realCost = ratingDataSet.getCost())) {
                result = false;
                info.add("Expected Cost " + var.getValueString() + " Real cost " + ratingDataSet.getCost().toDotString(4, 4));
            }
            if (!var.isSelected() || !var.getLabel().equals(LABEL_MAX_COST)) continue;
            RatingDecimal expectedMaxCost = new RatingDecimal(var.getValueString());
            RatingDecimal realMaxCost = ratingDataSet.getCost();
            if (expectedMaxCost.equals(new RatingDecimal(-1.0))) {
                return result;
            }
            if (expectedMaxCost.compareTo(realMaxCost) >= 0) continue;
            result = false;
            info.add("Max Cost " + var.getValueString() + " NOT enough money for service. Max cost was " + ratingDataSet.getCost().toDotString(4, 4));
        }
        return result;
    }

    protected Object getAllocatedDurationFromTimeTask(TimeBasedTask timeTask) {
        return timeTask.getAllocatedDuration();
    }
}

