/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParameterModel
extends VarTableModel {
    private static final long serialVersionUID = 6279596164709681117L;
    private String myName = "";
    final String[] COLUMN_NAMES = new String[]{"On", "Name", "Value"};
    final Class<?>[] COLUMN_CLASSES = new Class[]{Boolean.class, String.class, Variable.class};

    public ParameterModel(List<Variable> v) {
        super(v);
    }

    public ParameterModel(List<Variable> vars, List<Boolean> bools) {
        super(vars);
        int len = vars.size();
        for (int i = 0; i < len; ++i) {
            Variable v = vars.get(i);
            v.setSelected(bools.get(i));
        }
    }

    @Override
    public Class<?> getColumnClass(int i) {
        if (i < this.COLUMN_CLASSES.length) {
            return this.COLUMN_CLASSES[i];
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int i) {
        if (i < this.COLUMN_NAMES.length) {
            return this.COLUMN_NAMES[i];
        }
        return "???";
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return null;
        }
        if (col >= this.getColumnCount()) {
            return null;
        }
        Variable v = (Variable)this.dataVector.get(row);
        switch (col) {
            case 0: {
                return v.isSelected();
            }
            case 1: {
                return v.getLabel();
            }
            case 2: {
                return v;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 0) {
            return true;
        }
        if (col == 2 && row < this.dataVector.size()) {
            return ((Variable)this.dataVector.get(row)).isAllowEdit();
        }
        return false;
    }

    @Override
    public void setValueAt(Object val, int row, int col) {
        if (col == 2) {
            ((Variable)this.dataVector.get(row)).setValue(val);
            this.fireTableCellUpdated(row, col);
        }
        if (col == 0 && val instanceof Boolean) {
            ((Variable)this.dataVector.get(row)).setSelected((Boolean)val);
            this.fireTableCellUpdated(row, col);
        }
    }

    public void writeXML(PrintWriter out) {
        Variable v;
        int i;
        int len = this.getRowCount();
        out.println("<ParameterModel name= \"" + this.myName + "\" rows=\"" + len + "\">");
        for (i = 0; i < len; ++i) {
            v = (Variable)this.dataVector.get(i);
            v.writeXML(out);
        }
        for (i = 0; i < len; ++i) {
            v = (Variable)this.dataVector.get(i);
            out.println("<Boolean>" + v.isSelected() + "</Boolean>");
        }
        out.println("</ParameterModel>");
    }

    public static ParameterModel create(Node iterator) {
        if ("ParameterModel".equals(iterator.getNodeName())) {
            int rows;
            ArrayList<Variable> variables = new ArrayList<Variable>();
            ArrayList<Boolean> booleans = new ArrayList<Boolean>();
            String name = ((Element)iterator).getAttribute("name");
            NamedNodeMap attr = iterator.getAttributes();
            Node node = attr.getNamedItem("rows");
            if (node != null && (rows = Integer.parseInt(node.getNodeValue())) > 0) {
                variables.ensureCapacity(rows);
                booleans.ensureCapacity(rows);
            }
            NodeList varsAndBools = iterator.getChildNodes();
            for (int i = 0; i < varsAndBools.getLength(); ++i) {
                node = varsAndBools.item(i);
                if (node.getNodeType() != 1) continue;
                if ("Boolean".equals(node.getNodeName())) {
                    Boolean b = Boolean.valueOf(XMLUtil.getFirstTextContent(node));
                    booleans.add(b);
                    continue;
                }
                try {
                    Variable v = Variable.create(node);
                    if (v != null) {
                        variables.add(v);
                        continue;
                    }
                    System.out.println("Unknown node (not a Variable): " + node.getNodeName());
                    continue;
                }
                catch (Exception e) {
                    System.out.println("ERROR creating ParameterModel " + e);
                    e.printStackTrace();
                }
            }
            ParameterModel model = new ParameterModel(variables, booleans);
            model.setName(name);
            return model;
        }
        return null;
    }

    public boolean isModified() {
        for (int ii = 0; ii < this.dataVector.size(); ++ii) {
            if (!((Variable)this.dataVector.get(ii)).isModified()) continue;
            return true;
        }
        return false;
    }

    public void resetModified() {
        for (int ii = 0; ii < this.dataVector.size(); ++ii) {
            ((Variable)this.dataVector.get(ii)).resetModified();
        }
    }

    public List<Variable> getUsedVariableList() {
        ArrayList<Variable> usedVars = new ArrayList<Variable>();
        for (Variable var : this.dataVector) {
            if (!var.isSelected()) continue;
            usedVars.add(var);
        }
        return usedVars;
    }

    public List<?> getVariables() {
        return this.dataVector;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public String getName() {
        return this.myName;
    }
}

