/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.gui.simulator.GroupedDataSetSimulationPanel;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.NoActionStrategy;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.RangeStrategy;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.ThrowStrategy;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.TruncateStrategy;
import com.ericsson.ere.selectiontree.modifiers.operation.strategy.WrapAroundStrategy;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.Service;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.List;

public class RangeStrategyGroupedDataSetSimulationPanel
extends GroupedDataSetSimulationPanel {
    private static final String LBL_FO_STRATEGY = "FieldOperation range strategy";
    private static final String LBL_SF_STRATEGY = "SetField range strategy";
    private List<Variable> myCommonParams;

    public RangeStrategyGroupedDataSetSimulationPanel(ContextAwareServiceContainer serviceContainer) {
        super(serviceContainer);
    }

    public RangeStrategyGroupedDataSetSimulationPanel(Service service) {
        super(service);
    }

    @Override
    public List<Variable> getCommonParameters() {
        if (this.myCommonParams != null) {
            return this.myCommonParams;
        }
        ArrayList<Variable> params = new ArrayList<Variable>(super.getCommonParameters());
        RangeStrategy[] strategies = new RangeStrategy[]{new NoActionStrategy(), new TruncateStrategy(), new WrapAroundStrategy(), new ThrowStrategy()};
        StrategyLabeler strategyLabeler = new StrategyLabeler();
        TypedDropDownVariable<RangeStrategy> foStrategy = new TypedDropDownVariable<RangeStrategy>(LBL_FO_STRATEGY, strategies, strategyLabeler);
        TypedDropDownVariable<RangeStrategy> sfStrategy = new TypedDropDownVariable<RangeStrategy>(LBL_SF_STRATEGY, strategies, strategyLabeler);
        params.add(foStrategy);
        params.add(sfStrategy);
        this.myCommonParams = params;
        return this.myCommonParams;
    }

    @Override
    public void fillDataSet(DataSet theSet, ClassRepository repository) {
        super.fillDataSet(theSet, repository);
        for (Variable var : this.getCommonParameters()) {
            if (var.getLabel().equals(LBL_FO_STRATEGY) && var.isSelected()) {
                this.setFieldOperationStrategy(theSet, var);
                continue;
            }
            if (!var.getLabel().equals(LBL_SF_STRATEGY) || !var.isSelected()) continue;
            this.setSetFieldStrategy(theSet, var);
        }
    }

    private void setFieldOperationStrategy(DataSet theSet, Variable var) {
        if (theSet instanceof AbstractDataSet) {
            ((AbstractDataSet)theSet).setFieldOperationRangeStrategy(this.getRangeStrategy(var));
        }
    }

    private void setSetFieldStrategy(DataSet theSet, Variable var) {
        if (theSet instanceof AbstractDataSet) {
            ((AbstractDataSet)theSet).setSetFieldRangeStrategy(this.getRangeStrategy(var));
        }
    }

    private RangeStrategy getRangeStrategy(Variable var) {
        TypedDropDownVariable ddVar = (TypedDropDownVariable)var;
        return (RangeStrategy)ddVar.getSelectedItem();
    }

    private static class StrategyLabeler
    implements TypedDropDownVariable.ItemLabeler<RangeStrategy> {
        private StrategyLabeler() {
        }

        @Override
        public String getDisplayStringFor(RangeStrategy object, int index) {
            String name = object.getClass().getSimpleName();
            name = name.replaceAll("Strategy$", "");
            name = name.replaceAll("\\B([A-Z])", " $1");
            return name;
        }
    }
}

