/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.gui.simulator.SimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationField;
import java.util.List;

public class SimulationCaseSelectedFields {
    public static final int FIELD_ADDED = 0;
    public static final int FIELD_REMOVED = 1;
    String myFields;

    public SimulationCaseSelectedFields(String fields) {
        if (fields.contains(",")) {
            String[] selectedFields = fields.split(",");
            StringBuilder fieldsBuilder = new StringBuilder(selectedFields.length);
            for (int i = 0; i < selectedFields.length; ++i) {
                boolean boolValue = Boolean.parseBoolean(selectedFields[i]);
                fieldsBuilder.append(this.bitString(boolValue));
            }
            this.myFields = fieldsBuilder.toString();
        } else {
            this.myFields = fields;
        }
    }

    public SimulationCaseSelectedFields(Boolean[] selectedFields) {
        StringBuilder fieldsBuilder = new StringBuilder(selectedFields.length);
        for (Boolean boolValue : selectedFields) {
            fieldsBuilder.append(this.bitString(boolValue));
        }
        this.myFields = fieldsBuilder.toString();
    }

    public SimulationCaseSelectedFields(SimulationDataPanel panel) {
        List<SimulationField> fields = panel.getSimulationDataVariables();
        StringBuilder fieldsBuilder = new StringBuilder(fields.size());
        for (SimulationField field : fields) {
            fieldsBuilder.append(this.bitString(field.getSelected()));
        }
        this.myFields = fieldsBuilder.toString();
    }

    public void removeField(int index) {
        String first = this.myFields.substring(0, index);
        String second = this.myFields.substring(index + 1, this.myFields.length());
        this.myFields = first + second;
    }

    public void addField(int index, boolean defaultSelected) {
        String newSelection = this.bitString(defaultSelected);
        String first = this.myFields.substring(0, index);
        String second = this.myFields.substring(index, this.myFields.length());
        this.myFields = first + newSelection + second;
    }

    public void setFieldSelected(int index, boolean selected) {
        String first = this.myFields.substring(0, index);
        String second = this.myFields.substring(Math.min(index + 1, this.myFields.length()), this.myFields.length());
        this.myFields = first + this.bitString(selected) + second;
    }

    public Boolean[] getFields() {
        Boolean[] fieldsArray = new Boolean[this.myFields.length()];
        for (int i = 0; i < this.myFields.length(); ++i) {
            fieldsArray[i] = this.myFields.charAt(i) == '1';
        }
        return fieldsArray;
    }

    public String getFieldsString() {
        return this.myFields;
    }

    public String toString() {
        return this.getFieldsString();
    }

    private String bitString(boolean b) {
        return b ? "1" : "0";
    }
}

