/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.gui.simulator.SimulationDataTable;
import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class SimulationDataFilter
implements TableModelListener {
    protected Vector<Vector<Object>> myCompleteData;
    protected HashMap<String, SimulationDataTableModel.ModifiedStatus> myModifiedRows = new HashMap();
    protected boolean isFilterActive = false;
    protected SimulationDataTableModel myModel;
    protected SimulationDataTable myTable;

    public SimulationDataFilter(SimulationDataTable table, SimulationDataTableModel model) {
        this.myTable = table;
        this.myModel = model;
        this.myModel.addTableModelListener(this);
    }

    public boolean isFilterActive() {
        return this.isFilterActive;
    }

    public void setFilterActive(boolean active) {
        if (active && !this.isFilterActive) {
            this.myCompleteData = this.myModel.getDataVector();
            this.myModel.setDataVector(new Vector());
            for (int row = 0; row < this.myCompleteData.size(); ++row) {
                if (!this.filterRow(row)) continue;
                this.myModel.getDataVector().add(this.myCompleteData.get(row));
            }
            this.myModel.fireTableDataChanged();
            this.isFilterActive = active;
        } else if (!active && this.isFilterActive) {
            if (this.myModifiedRows.size() > 0) {
                for (String rowId : this.myModifiedRows.keySet()) {
                    if (this.myModifiedRows.get(rowId) == SimulationDataTableModel.ModifiedStatus.ROW_ADDED) {
                        Object[] rowData = this.myModel.getRowData(rowId);
                        Vector<Object> rowVector = new Vector<Object>(rowData.length);
                        for (Object o : rowData) {
                            rowVector.add(o);
                        }
                        this.myCompleteData.add(rowVector);
                        continue;
                    }
                    if (this.myModifiedRows.get(rowId) != SimulationDataTableModel.ModifiedStatus.ROW_REMOVED) continue;
                    int index = this.myModel.getRowForId(rowId, this.myCompleteData);
                    this.myCompleteData.removeElementAt(index);
                }
                this.myModifiedRows.clear();
            }
            this.myModel.setDataVector(this.myCompleteData);
            this.isFilterActive = active;
            this.myModel.fireTableDataChanged();
        }
    }

    public void removeRow(String rowId) {
        if (this.isFilterActive) {
            if (this.myModifiedRows.get(rowId) == null) {
                this.myModifiedRows.put(rowId, SimulationDataTableModel.ModifiedStatus.ROW_REMOVED);
            } else {
                this.myModifiedRows.remove(rowId);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.isFilterActive && e.getType() == 1) {
            this.myModifiedRows.put(this.myModel.getIdForRow(this.myTable.convertRowIndexToModel(e.getFirstRow())), SimulationDataTableModel.ModifiedStatus.ROW_ADDED);
        }
    }

    protected abstract boolean filterRow(int var1);
}

