/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.simulator.SearchableSimulationPanel;
import com.ericsson.ere.gui.simulator.SimulationCaseSelectedFields;
import com.ericsson.ere.gui.simulator.SimulationDataDiff;
import com.ericsson.ere.gui.simulator.SimulationDataFilter;
import com.ericsson.ere.gui.simulator.SimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationDataTable;
import com.ericsson.ere.gui.simulator.SimulationFactory;
import com.ericsson.ere.gui.simulator.SimulationField;
import com.ericsson.ere.gui.simulator.SimulationSet;
import com.ericsson.ere.gui.util.UniqueId;
import com.ericsson.ere.util.DefaultRMAObjectCloner;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldRepository;
import ericsson.ere.exception.NotImplementedException;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.Service;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldPanelSupport;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class SimulationDataTableModel
extends DefaultTableModel {
    private HashMap<String, SimulationStatus> mySimulationStatus = new HashMap();
    private HashMap<String, Boolean> myDataValidityStatus = new HashMap();
    private SimulationFactory myFactory;
    private ContextAwareServiceContainer myServiceContainer;
    private SimulationSet mySimulationSet;
    private SimulationDataPanel myTemplateSimulationDataPanel;
    private HashMap<String, SimulationDataPanel> myViewedSimulationDataPanels;
    private String myTitleColumn;
    private SimulationCaseSelectedFields myDefaultSelectedFields;
    public static final String FIELD_ROW_ID = "ROWID";
    public static final String FIELD_SELECTED = "SELECTED_FIELDS";
    public static final String[] SPECIAL_FIELDS = new String[]{"ROWID", "SELECTED_FIELDS"};
    public static final int INDEX_OF_ROW_ID = Arrays.asList(SPECIAL_FIELDS).indexOf("ROWID");
    public static final int INDEX_OF_SELECTED = Arrays.asList(SPECIAL_FIELDS).indexOf("SELECTED_FIELDS");
    private HashMap<String, ModifiedStatus> myModifiedRows = new HashMap();
    private SimulationDataFailedFilter myFailedCasesFilter;

    public SimulationDataTableModel(SimulationFactory factory, ContextAwareServiceContainer serviceContainer, SimulationSet simulationSet) {
        this.myFactory = factory;
        this.myServiceContainer = serviceContainer;
        this.myViewedSimulationDataPanels = new HashMap();
        this.mySimulationSet = simulationSet;
        this.myTemplateSimulationDataPanel = this.getTemporarySimulationDataPanel();
        this.myTitleColumn = this.myTemplateSimulationDataPanel.getTitleVariable().getLabel();
        for (String specialField : SPECIAL_FIELDS) {
            this.addColumn(specialField);
        }
        ArrayList<Boolean> selectedFields = new ArrayList<Boolean>();
        List<SimulationField> initialPanelData = this.myTemplateSimulationDataPanel.getSimulationDataVariables();
        for (int i = 0; i < initialPanelData.size(); ++i) {
            SimulationField simulationField = initialPanelData.get(i);
            selectedFields.add(simulationField.getSelected());
            this.addColumn(simulationField.getName());
        }
        this.myDefaultSelectedFields = new SimulationCaseSelectedFields(selectedFields.toArray(new Boolean[0]));
    }

    public void init(List<Object[]> data) {
        this.removeAll();
        for (Object[] row : data) {
            this.addRow(row);
        }
        this.resetModified();
    }

    public void init(SimulationDataPanel panel) {
        this.removeAll();
        this.addRow(panel);
        this.resetModified();
    }

    public boolean updateTreeDefinedFields() {
        boolean changedFields = false;
        List<SimulationDataDiff> diffList = null;
        if (this.myTemplateSimulationDataPanel instanceof TreeDefinedFieldPanelSupport && (diffList = ((TreeDefinedFieldPanelSupport)((Object)this.myTemplateSimulationDataPanel)).getTDFUpdates()).size() > 0) {
            this.myViewedSimulationDataPanels.clear();
        }
        if (diffList != null) {
            for (SimulationDataDiff diff : diffList) {
                String fieldNameIN = diff.getLabel() + " (IN)";
                String fieldNameOUT = diff.getLabel() + " (OUT)";
                int index = this.columnIdentifiers.indexOf(fieldNameIN);
                switch (diff.getDiffType()) {
                    case 2: {
                        changedFields = true;
                        this.addTDFColumns(diff, fieldNameIN, fieldNameOUT);
                        break;
                    }
                    case 1: {
                        if (index == -1) break;
                        changedFields = true;
                        this.removeTDFColumns(index, fieldNameIN, fieldNameOUT);
                        break;
                    }
                    case 3: {
                        if (index == -1) break;
                        changedFields = true;
                        this.removeTDFColumns(index, fieldNameIN, fieldNameOUT);
                        this.addTDFColumns(diff, fieldNameIN, fieldNameOUT);
                    }
                }
                this.myTemplateSimulationDataPanel = this.getTemporarySimulationDataPanel();
                if (!changedFields) continue;
                this.mySimulationSet.getSimulationDataTable().simulationDataChanged(this.getColumnNames(false));
                SimulationDataTableModel simModel = this.mySimulationSet.getSimulationModel();
                for (int i = 0; i < simModel.getRowCount(); ++i) {
                    this.mySimulationSet.simulationDataPanelChanged(simModel.getSimulationDataPanel(i), diff.getLabel(), diff.getValue());
                }
            }
        }
        return changedFields;
    }

    private void removeTDFColumns(int index, String fieldNameIN, String fieldNameOUT) {
        this.updateSelectionModel(fieldNameIN, 1);
        this.removeColumnAndDataForLabel(index);
        this.updateSelectionModel(fieldNameOUT, 1);
        int nextIndex = this.columnIdentifiers.indexOf(fieldNameOUT);
        this.removeColumnAndDataForLabel(nextIndex);
    }

    private void addTDFColumns(SimulationDataDiff diff, String fieldNameIN, String fieldNameOUT) {
        Object[] data1 = new Object[this.getRowCount()];
        Arrays.fill(data1, diff.getValue());
        this.addINColumn(fieldNameIN, data1);
        this.addColumn((Object)fieldNameOUT, data1);
        this.updateSelectionModel(fieldNameIN, 0);
        this.updateSelectionModel(fieldNameOUT, 0);
    }

    private void removeColumnAndDataForLabel(int vColIndex) {
        SimulationDataTable table = this.mySimulationSet.getSimulationDataTable();
        TableColumn col = table.getColumnModel().getColumn(vColIndex);
        int columnModelIndex = col.getModelIndex();
        Vector<Vector> data = this.getDataVector();
        table.removeColumn(col);
        this.columnIdentifiers.removeElementAt(columnModelIndex);
        for (int r = 0; r < data.size(); ++r) {
            Vector row = data.get(r);
            row.removeElementAt(columnModelIndex);
        }
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn c = columns.nextElement();
            if (c.getModelIndex() < columnModelIndex) continue;
            c.setModelIndex(c.getModelIndex() - 1);
        }
        this.fireTableStructureChanged();
    }

    public List<SimulationDataDiff> compareFields(List<SimulationField> fields) {
        SimulationDataPanel panel = this.myTemplateSimulationDataPanel;
        for (int i = 0; i < SPECIAL_FIELDS.length; ++i) {
            fields.remove(0);
        }
        return panel.compareFields(fields);
    }

    public SimulationDataPanel getSimulationDataPanel(int row) {
        SimulationDataPanel simulationPanel = null;
        String rowId = this.getIdForRow(row);
        if (this.myViewedSimulationDataPanels.containsKey(rowId)) {
            simulationPanel = this.myViewedSimulationDataPanels.get(rowId);
        } else {
            SimulationDataPanel panel = this.createSimulationPanelHelper();
            int extraFields = SPECIAL_FIELDS.length;
            Object[] rowData = ((Vector)this.dataVector.elementAt(row)).toArray();
            Object[] panelData = new Object[rowData.length - extraFields];
            System.arraycopy(rowData, extraFields, panelData, 0, panelData.length);
            Object[] allColumns = this.getColumnNames(true).toArray();
            Object[] panelColumns = new Object[allColumns.length - extraFields];
            System.arraycopy(allColumns, extraFields, panelColumns, 0, panelColumns.length);
            SimulationCaseSelectedFields selectedFields = new SimulationCaseSelectedFields((String)rowData[INDEX_OF_SELECTED]);
            panel.init(panelColumns, panelData, selectedFields.getFields());
            panel.addVariableSelectionListener(this.mySimulationSet);
            panel.setSimulationPanelChangedCallback(this.mySimulationSet);
            this.myViewedSimulationDataPanels.put(rowId, panel);
            simulationPanel = this.myViewedSimulationDataPanels.get(rowId);
        }
        return simulationPanel;
    }

    public int getDataModelSize() {
        return this.myViewedSimulationDataPanels.size();
    }

    public SimulationDataPanel getTemporarySimulationDataPanel() {
        SimulationDataPanel templateSimulationDataPanel = this.myFactory.createSimulationDataPanel(this.myServiceContainer);
        return templateSimulationDataPanel;
    }

    public static Object[] getPanelData(SimulationDataPanel panel) {
        List<SimulationField> simulationFields = panel.getSimulationDataVariables();
        ArrayList<Object> data = new ArrayList<Object>(simulationFields.size());
        for (int i = 0; i < simulationFields.size(); ++i) {
            SimulationField simulationField = simulationFields.get(i);
            data.add(simulationField.getValueObject());
        }
        return data.toArray();
    }

    public SimulationDataPanel getMultiSimulationDataPanel() {
        SimulationDataPanel panel = this.createSimulationPanelHelper();
        panel.addVariableSelectionListener(this.mySimulationSet);
        panel.setSimulationPanelChangedCallback(this.mySimulationSet);
        return panel;
    }

    public SimulationDataPanel createNewSimulationDataPanel() {
        SimulationDataPanel panel = this.createSimulationPanelHelper();
        panel.setSimulationPanelChangedCallback(this.mySimulationSet);
        panel.addVariableSelectionListener(this.mySimulationSet);
        this.addRow(panel);
        return panel;
    }

    private SimulationDataPanel createSimulationPanelHelper() {
        FunctionState fcnState = this.mySimulationSet.getStateForFunction(FunctionToken.SIMULATION_PANEL_SEARCH, null);
        SimulationDataPanel panel = this.myFactory.createSimulationDataPanel(this.myServiceContainer);
        if (panel instanceof SearchableSimulationPanel && fcnState.getState() == FunctionState.State.ON) {
            ((SearchableSimulationPanel)((Object)panel)).enableSimulationPanelSearch();
        }
        return panel;
    }

    public void cloneSimulationCase(int[] rows) {
        DefaultRMAObjectCloner cloner = new DefaultRMAObjectCloner();
        for (int row : rows) {
            try {
                Object[] data = cloner.cloneObject((Vector)this.dataVector.get(row)).toArray();
                data[SimulationDataTableModel.INDEX_OF_ROW_ID] = UniqueId.generate();
                this.addRow(data);
            }
            catch (CloneNotSupportedException e) {
                throw new NotImplementedException("DefaultRMAObjectCloner is missing support to clone all needed objects. " + e.getMessage());
            }
        }
    }

    public void printData(PrintWriter out) {
        SimulationDataPanel tempPanel = null;
        out.write("<SimulationSuite>");
        Vector<Vector> data = this.getDataVector();
        for (int i = 0; i < data.size(); ++i) {
            String rowId = this.getIdForRow(i);
            SimulationDataPanel simulationPanel = this.myViewedSimulationDataPanels.get(rowId);
            if (simulationPanel == null) {
                if (tempPanel == null) {
                    tempPanel = this.getTemporarySimulationDataPanel();
                }
                Vector row = (Vector)data.elementAt(i).clone();
                SimulationCaseSelectedFields selectedFields = new SimulationCaseSelectedFields((String)this.getValueAt(i, INDEX_OF_SELECTED));
                for (int j = 0; j < SPECIAL_FIELDS.length; ++j) {
                    row.remove(0);
                }
                tempPanel.init(this.getColumnNames(false).toArray(), row.toArray(), selectedFields.getFields());
                simulationPanel = tempPanel;
            }
            simulationPanel.save(out);
            out.flush();
        }
        out.write("</SimulationSuite>");
        out.flush();
    }

    public void update(int[] rows, String fieldName, Object value) {
        for (int i = 0; i < rows.length; ++i) {
            String rowId = this.getIdForRow(rows[i]);
            boolean isPanelValid = true;
            SimulationDataPanel panel = this.myViewedSimulationDataPanels.get(rowId);
            if (panel != null && !panel.isSimulationDataValid()) {
                isPanelValid = false;
            }
            if (rows.length == 1 || isPanelValid) {
                this.setValueAt(value, rows[i], this.getColumnForName(fieldName, true));
            }
            if (rows.length <= 1 || !isPanelValid) continue;
            this.myViewedSimulationDataPanels.remove(rowId);
        }
    }

    public void updateFieldSelection(int[] rows, String fieldName, boolean selected) {
        int column = this.getColumnForName(fieldName, true) - SPECIAL_FIELDS.length;
        for (int i = 0; i < rows.length; ++i) {
            int row = rows[i];
            String rowId = this.getIdForRow(row);
            SimulationCaseSelectedFields selectedFields = new SimulationCaseSelectedFields((String)this.getValueAt(row, INDEX_OF_SELECTED));
            selectedFields.setFieldSelected(column, selected);
            this.setValueAt(selectedFields.getFieldsString(), row, INDEX_OF_SELECTED);
            if (rows.length <= 1) continue;
            this.myViewedSimulationDataPanels.remove(rowId);
        }
    }

    public void setSimulationStatus(int row, SimulationStatus status) {
        String rowId = this.getIdForRow(row);
        this.mySimulationStatus.put(rowId, status);
    }

    public boolean hasSimulated() {
        return this.mySimulationStatus.size() > 0;
    }

    public SimulationStatus getSimulationStatus(int row) {
        String rowId = this.getIdForRow(row);
        SimulationStatus status = this.mySimulationStatus.get(rowId);
        if (status == null) {
            return SimulationStatus.STATUS_NORMAL;
        }
        return status;
    }

    public void setDataValidity(int row, boolean status) {
        String rowId = this.getIdForRow(row);
        this.myDataValidityStatus.put(rowId, status);
    }

    public boolean getDataValidity(int row) {
        String rowId = this.getIdForRow(row);
        Boolean status = this.myDataValidityStatus.get(rowId);
        if (status == null) {
            return true;
        }
        return status;
    }

    int getRowForId(String id, Vector<?> data) {
        Vector actualdata = data != null ? data : this.dataVector;
        for (int i = 0; i < actualdata.size(); ++i) {
            Vector row = (Vector)actualdata.get(i);
            if (!((String)row.get(0)).equals(id)) continue;
            return i;
        }
        return -1;
    }

    public Object[] getRowData(String rowId) {
        int index = this.getRowForId(rowId, this.dataVector);
        Vector dataRow = (Vector)this.dataVector.elementAt(index);
        return dataRow.toArray();
    }

    String getIdForRow(int row) {
        return (String)this.getValueAt(row, INDEX_OF_ROW_ID);
    }

    public Service getService() {
        return this.myServiceContainer.getService();
    }

    public int getColumnForName(String name, boolean includeSpecialFields) {
        return this.getColumnNames(includeSpecialFields).indexOf(name);
    }

    public List<SimulationField> getSimulationData(boolean includeSpecialFields, boolean groupContextFields) {
        SimulationDataPanel panel = this.myTemplateSimulationDataPanel;
        List<SimulationField> data = panel.getSimulationDataVariables();
        if (includeSpecialFields) {
            for (int i = 0; i < SPECIAL_FIELDS.length; ++i) {
                data.add(i, new SimulationField(SPECIAL_FIELDS[i], "", false));
            }
        }
        return data;
    }

    public HashMap<String, SimulationField> getContextFields() {
        SimulationDataPanel panel = this.myTemplateSimulationDataPanel;
        HashMap<String, SimulationField> contextFields = new HashMap<String, SimulationField>();
        for (SimulationField field : panel.getGroupedDatabaseFields()) {
            contextFields.put(field.getName(), field);
        }
        return contextFields;
    }

    public List<String> getColumnNames(boolean includeSpecialFields) {
        ArrayList<String> columns = new ArrayList<String>(this.columnIdentifiers);
        if (!includeSpecialFields) {
            for (int i = 0; i < SPECIAL_FIELDS.length; ++i) {
                columns.remove(0);
            }
        }
        return columns;
    }

    public List<String> getColumnNamesForPrintableFields() {
        ArrayList<String> columns = new ArrayList<String>();
        for (Variable var : this.myTemplateSimulationDataPanel.getCommonParameters()) {
            columns.add(var.getLabel());
        }
        FieldRepository fieldRepository = this.myServiceContainer.getClassRepository().getFieldRepository();
        List<String> fieldNames = this.getColumnNames(false);
        for (String fieldName : fieldNames) {
            FieldHierarchyNode field = fieldRepository.getFieldByName(fieldName);
            if (columns.contains(fieldName) || field == null || !(field instanceof FieldDefinition) || field.getComplexType() != FieldHierarchyNode.ComplexType.NONE) continue;
            columns.add(fieldName);
        }
        return columns;
    }

    public Vector<?> getColumnIdentifiers() {
        return this.columnIdentifiers;
    }

    public String getTitleColumn() {
        return this.myTitleColumn;
    }

    public void addRow(SimulationDataPanel data) {
        Object[] panelData = SimulationDataTableModel.getPanelData(data);
        this.addRow(panelData);
        String rowId = (String)this.getValueAt(this.getRowCount() - 1, 0);
        this.myViewedSimulationDataPanels.put(rowId, data);
        this.myModifiedRows.put(rowId, ModifiedStatus.ROW_ADDED);
        this.myDataValidityStatus.put(rowId, data.isSimulationDataValid());
    }

    @Override
    public void addRow(Object[] data) {
        Object[] actualData = data;
        if (data.length == this.getColumnCount() - SPECIAL_FIELDS.length) {
            actualData = this.addSpecialFields(data, null);
        }
        if (actualData.length != this.getColumnCount()) {
            throw new IllegalArgumentException("Data/column count mismatch.");
        }
        this.myModifiedRows.put((String)actualData[INDEX_OF_ROW_ID], ModifiedStatus.ROW_ADDED);
        super.addRow(actualData);
    }

    public Object[] addSpecialFields(Object[] data, SimulationCaseSelectedFields selectedFields) {
        Object[] rowData = new Object[data.length + SPECIAL_FIELDS.length];
        System.arraycopy(data, 0, rowData, SPECIAL_FIELDS.length, data.length);
        String rowId = UniqueId.generate();
        rowData[SimulationDataTableModel.INDEX_OF_ROW_ID] = rowId;
        String selectedFieldsString = selectedFields == null ? this.myDefaultSelectedFields.getFieldsString() : selectedFields.getFieldsString();
        rowData[SimulationDataTableModel.INDEX_OF_SELECTED] = selectedFieldsString;
        return rowData;
    }

    @Override
    public void removeRow(int i) {
        String rowId = this.getIdForRow(i);
        this.myViewedSimulationDataPanels.remove(rowId);
        ModifiedStatus rowStatus = this.myModifiedRows.get(rowId);
        if (rowStatus == null || rowStatus != ModifiedStatus.ROW_ADDED) {
            this.myModifiedRows.put(rowId, ModifiedStatus.ROW_REMOVED);
        } else {
            this.myModifiedRows.put(rowId, null);
        }
        if (this.myFailedCasesFilter == null) {
            this.myFailedCasesFilter = new SimulationDataFailedFilter(this);
        }
        this.myFailedCasesFilter.removeRow(rowId);
        super.removeRow(i);
    }

    public void removeAll() {
        while (this.getRowCount() > 0) {
            this.removeRow(0);
        }
        this.myViewedSimulationDataPanels.clear();
        this.resetModified();
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        ModifiedStatus rowStatus = this.myModifiedRows.get(this.getIdForRow(row));
        if (rowStatus == null || rowStatus != ModifiedStatus.ROW_ADDED) {
            this.myModifiedRows.put(this.getIdForRow(row), ModifiedStatus.ROW_EDITED);
        }
        super.setValueAt(aValue, row, column);
    }

    public boolean isModified() {
        return this.myModifiedRows.size() > 0;
    }

    public void resetModified() {
        this.myModifiedRows.clear();
    }

    public HashMap<String, ModifiedStatus> getModifiedRows() {
        return this.myModifiedRows;
    }

    private void updateSelectionModel(String fieldName, int updateType) {
        int fieldIndex = this.getColumnForName(fieldName, false);
        if (fieldIndex != -1) {
            switch (updateType) {
                case 0: {
                    this.myDefaultSelectedFields.addField(fieldIndex, false);
                    break;
                }
                case 1: {
                    this.myDefaultSelectedFields.removeField(fieldIndex);
                }
            }
            for (int row = 0; row < this.getRowCount(); ++row) {
                String selectedFields = (String)this.getValueAt(row, INDEX_OF_SELECTED);
                switch (updateType) {
                    case 0: {
                        SimulationCaseSelectedFields fields1 = new SimulationCaseSelectedFields(selectedFields);
                        fields1.addField(fieldIndex, false);
                        selectedFields = fields1.getFieldsString();
                        break;
                    }
                    case 1: {
                        SimulationCaseSelectedFields fields2 = new SimulationCaseSelectedFields(selectedFields);
                        fields2.removeField(fieldIndex);
                        selectedFields = fields2.getFieldsString();
                    }
                }
                this.setValueAt(selectedFields, row, INDEX_OF_SELECTED);
            }
        }
    }

    void setDataVector(Vector<?> data) {
        this.dataVector = data;
    }

    void setFailedFilterActive(boolean active) {
        if (this.myFailedCasesFilter == null) {
            this.myFailedCasesFilter = new SimulationDataFailedFilter(this);
        }
        this.myFailedCasesFilter.setFilterActive(active);
    }

    boolean isFailedFilterActive() {
        if (this.myFailedCasesFilter == null) {
            this.myFailedCasesFilter = new SimulationDataFailedFilter(this);
        }
        return this.myFailedCasesFilter.isFilterActive();
    }

    private void addINColumn(Object columnName, Object[] data) {
        int index = this.columnIdentifiers.size() - 1;
        if (((String)this.columnIdentifiers.get(this.columnIdentifiers.size() - 1)).contains(" (OUT)")) {
            for (int i = this.columnIdentifiers.size() - 1; i >= 0; --i) {
                if (((String)this.columnIdentifiers.get(i)).contains(" (OUT)")) continue;
                index = i + 1;
                break;
            }
            this.addColumn(columnName, data, index);
        } else {
            this.addColumn(columnName, data);
        }
    }

    private void addColumn(Object columnName, Object[] data, int index) {
        Vector<Object> columnData = SimulationDataTableModel.convertToVector(data);
        this.columnIdentifiers.add(index, columnName);
        if (columnData != null) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                Vector row = (Vector)this.dataVector.elementAt(i);
                row.setSize(this.getColumnCount());
                row.add(index, columnData.elementAt(i));
            }
        }
        this.fireTableStructureChanged();
    }

    private class SimulationDataFailedFilter
    extends SimulationDataFilter {
        public SimulationDataFailedFilter(SimulationDataTableModel model) {
            super(SimulationDataTableModel.this.mySimulationSet.getSimulationDataTable(), model);
        }

        @Override
        protected boolean filterRow(int row) {
            Vector rowData = (Vector)this.myCompleteData.get(row);
            String id = (String)rowData.get(0);
            SimulationStatus status = (SimulationStatus)((Object)SimulationDataTableModel.this.mySimulationStatus.get(id));
            return status == SimulationStatus.STATUS_FAILED || status == SimulationStatus.STATUS_ERRONEOUS;
        }
    }

    public static enum ModifiedStatus {
        ROW_EDITED,
        ROW_ADDED,
        ROW_REMOVED;

    }

    static enum SimulationStatus {
        STATUS_NORMAL,
        STATUS_FAILED,
        STATUS_SUCCESS,
        STATUS_ERRONEOUS;

    }
}

