/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dag.DAGVisit;
import com.ericsson.ere.gui.simulator.ParameterModel;
import com.ericsson.ere.gui.simulator.SimulationVariableStructure;
import com.ericsson.ere.gui.simulator.SimulationVariableStructureVisitor;
import com.ericsson.ere.gui.util.ClosableVarPanel;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.GroupedVarTable;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.variable.BitPatternInputVariable;
import ericsson.vareditor.variable.GroupedArrayVariable;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.GroupedObjectArrayVariable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SimulationPanelComponentBuilder
extends SimulationVariableStructureVisitor {
    private static final SimulationVariableStructure.VariableStructureElement ROOT_GROUP = null;
    private static final ImageIcon myHierarchicalFieldIcon = RmaDefs.getImageIcon("hierarchical_field.png");
    private final Component myFocusOwner;
    private final Map<SimulationVariableStructure.VariableStructureElement, GroupComponentBuilder> myGroupMap;

    private SimulationPanelComponentBuilder(Component focusOwner) {
        this.myFocusOwner = focusOwner;
        this.myGroupMap = new IdentityHashMap<SimulationVariableStructure.VariableStructureElement, GroupComponentBuilder>();
        this.myGroupMap.put(ROOT_GROUP, new GroupComponentBuilder(null, null));
    }

    public static SimulationPanelComponentBuilder create(SimulationVariableStructure structure, Component focusOwner) {
        SimulationPanelComponentBuilder b = new SimulationPanelComponentBuilder(focusOwner);
        SimulationVariableStructure.VariableStructureElement root = structure.getRoot();
        DAGVisit.visitPreOrder(root, b);
        return b;
    }

    public List<JComponent> createComponentList() {
        GroupComponentBuilder root = this.myGroupMap.get(ROOT_GROUP);
        return root.createComponentList();
    }

    @Override
    public void visit(SimulationVariableStructure.VariableRootElement element) {
    }

    @Override
    public void visit(SimulationVariableStructure.VariableGroupElement element) {
        GroupComponentBuilder current = this.getGroupForElement(element);
        GroupComponentBuilder newcc = new GroupComponentBuilder(element, null);
        this.myGroupMap.put(element, newcc);
        current.addGroup(newcc, element.getType());
    }

    @Override
    public void visit(SimulationVariableStructure.VariableElement element) {
        GroupComponentBuilder current = this.getGroupForElement(element);
        current.addVariable(element.getVariable(), element.getType());
    }

    @Override
    public void visit(SimulationVariableStructure.VariableHierarchicalElement element) {
        GroupComponentBuilder current = this.getGroupForElement(element);
        Variable variable = element.getVariable();
        variable.setIcon(myHierarchicalFieldIcon);
        current.addVariable(variable, element.getType());
    }

    @Override
    public void visit(SimulationVariableStructure.VariableHierarchicalGroupElement element) {
        GroupComponentBuilder current = this.getGroupForElement(element);
        GroupComponentBuilder newcc = new GroupComponentBuilder(element, myHierarchicalFieldIcon);
        this.myGroupMap.put(element, newcc);
        current.addGroup(newcc, element.getType());
    }

    private GroupComponentBuilder getGroupForElement(SimulationVariableStructure.VariableStructureElement element) {
        GroupComponentBuilder group = this.myGroupMap.get(element.getParent());
        if (group == null) {
            group = this.myGroupMap.get(ROOT_GROUP);
        }
        return group;
    }

    static JPanel createPanelForVariables(List<Variable> varList, Component focusOwner) {
        JPanel outPanel = null;
        if (!varList.isEmpty()) {
            int gridyCount = -1;
            GridBagConstraints constraint = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 14, 2, new Insets(0, 0, 0, 0), 0, 0);
            ArrayList<Variable> simpleVariables = new ArrayList<Variable>();
            outPanel = new JPanel(new GridBagLayout());
            for (Variable var : varList) {
                if (SimulationPanelComponentBuilder.isFoldableVariable(var)) {
                    constraint.gridy = ++gridyCount;
                    outPanel.add(SimulationPanelComponentBuilder.createContainerForVariable(var, focusOwner), constraint);
                    continue;
                }
                simpleVariables.add(var);
            }
            if (!simpleVariables.isEmpty()) {
                constraint.gridy = ++gridyCount;
                outPanel.add(SimulationPanelComponentBuilder.createVariableTableComponent(simpleVariables, focusOwner), constraint);
            }
        }
        return outPanel;
    }

    static JPanel createPanelForVariablesWithLargeVariablesLast(List<Variable> varList, Component focusOwner) {
        JPanel outPanel = null;
        if (!varList.isEmpty()) {
            int gridyCount = -1;
            GridBagConstraints constraint = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 14, 2, new Insets(0, 0, 0, 0), 0, 0);
            ArrayList<Variable> simpleVariables = new ArrayList<Variable>();
            ArrayList<Variable> foldableVariables = new ArrayList<Variable>();
            outPanel = new JPanel(new GridBagLayout());
            for (Variable var : varList) {
                if (SimulationPanelComponentBuilder.isFoldableVariable(var)) {
                    foldableVariables.add(var);
                    continue;
                }
                simpleVariables.add(var);
            }
            if (!simpleVariables.isEmpty()) {
                constraint.gridy = ++gridyCount;
                outPanel.add(SimulationPanelComponentBuilder.createVariableTableComponent(simpleVariables, focusOwner), constraint);
            }
            if (!foldableVariables.isEmpty()) {
                for (Variable var : foldableVariables) {
                    constraint.gridy = ++gridyCount;
                    outPanel.add(SimulationPanelComponentBuilder.createContainerForVariable(var, focusOwner), constraint);
                }
            }
        }
        return outPanel;
    }

    private static boolean isFoldableVariable(Variable var) {
        return var instanceof GroupedArrayVariable || var instanceof BitPatternInputVariable || var instanceof GroupedObjectArrayVariable;
    }

    private static Component createVariableTableComponent(List<Variable> varList, Component focusOwner) {
        VarTable2 table = new VarTable2(new ParameterModel(varList));
        table.setFocusOwner(focusOwner);
        table.setSelectable(true);
        return table;
    }

    private static Component createContainerForVariable(Variable var, Component focusOwner) {
        GroupedVarTable groupedVarTable = new GroupedVarTable(true);
        groupedVarTable.setFocusOwner(focusOwner);
        groupedVarTable.fillTable(var);
        return groupedVarTable;
    }

    private static class GroupComponentBuilderList
    extends StructureEntityList<GroupComponentBuilder> {
        private GroupComponentBuilderList() {
        }

        @Override
        List<JComponent> createComponents() {
            ArrayList<JComponent> components = new ArrayList<JComponent>();
            for (GroupComponentBuilder group : this.myEntities) {
                ClosableVarPanel.DefaultTitleRenderer renderer = new ClosableVarPanel.DefaultTitleRenderer(group.myGroupName);
                if (group.myIcon != null) {
                    renderer.getLabel().setIcon(group.myIcon);
                }
                ClosableVarPanel panel = new ClosableVarPanel(renderer, true, group.createComponentList(), false);
                components.add(panel);
            }
            return components;
        }
    }

    private class VariableList
    extends StructureEntityList<Variable> {
        private VariableList() {
        }

        @Override
        List<JComponent> createComponents() {
            JPanel vt = SimulationPanelComponentBuilder.createPanelForVariables(this.myEntities, SimulationPanelComponentBuilder.this.myFocusOwner);
            return Collections.singletonList(vt);
        }
    }

    private static abstract class StructureEntityList<T> {
        protected List<T> myEntities = new ArrayList<T>();

        private StructureEntityList() {
        }

        abstract List<JComponent> createComponents();

        boolean isEmpty() {
            return this.myEntities.isEmpty();
        }

        void addEntity(T entity) {
            this.myEntities.add(entity);
        }
    }

    private class GroupComponentBuilder {
        private String myGroupName;
        private StructureEntityList[] myStructureEntityLists;
        private ImageIcon myIcon = null;

        GroupComponentBuilder(SimulationVariableStructure.VariableGroupElement element, ImageIcon icon) {
            if (element != null) {
                this.myGroupName = element.getGroupName();
                this.myIcon = icon;
            }
            this.myStructureEntityLists = new StructureEntityList[SimulationVariableStructure.VariableStructureElement.VariableStructureElementType.values().length];
        }

        void addVariable(Variable variable, SimulationVariableStructure.VariableStructureElement.VariableStructureElementType type) {
            StructureEntityList list = this.myStructureEntityLists[type.ordinal()];
            this.addEntityToList(list != null ? list : new VariableList(), variable, type);
        }

        void addGroup(GroupComponentBuilder builder, SimulationVariableStructure.VariableStructureElement.VariableStructureElementType type) {
            StructureEntityList list = this.myStructureEntityLists[type.ordinal()];
            this.addEntityToList(list != null ? list : new GroupComponentBuilderList(), builder, type);
        }

        private <U> void addEntityToList(StructureEntityList<U> list, U entity, SimulationVariableStructure.VariableStructureElement.VariableStructureElementType type) {
            StructureEntityList actual = this.myStructureEntityLists[type.ordinal()];
            if (actual == null) {
                this.myStructureEntityLists[type.ordinal()] = list;
            }
            list.addEntity(entity);
        }

        List<JComponent> createComponentList() {
            ArrayList<JComponent> components = new ArrayList<JComponent>();
            for (StructureEntityList list : this.myStructureEntityLists) {
                if (list == null || list.isEmpty()) continue;
                components.addAll(list.createComponents());
            }
            return components;
        }
    }
}

