/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.DataDescriber;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetArrayHelper;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.IncompatibleDataSetValueException;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.simulator.AbstractVariableValidator;
import com.ericsson.ere.gui.simulator.FieldBasedVariableProducerWrapper;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class StandardVariableValidator
extends AbstractVariableValidator {
    public StandardVariableValidator(ClassRepository repository, DataDescriber describer) {
        super(repository, describer);
    }

    @Override
    public boolean validateVariable(Variable variable, DataSet dataset, List<String> info) {
        FieldDefinition fieldDefinition = this.getFieldFromVariable(variable);
        Object expectedValue = this.getVariableValueObject(variable, fieldDefinition);
        ArrayList<String> validationInfo = new ArrayList<String>();
        if (expectedValue != null) {
            DataSetField field = new DataSetField(fieldDefinition);
            this.performFieldValidation(dataset, expectedValue, field, fieldDefinition, validationInfo);
        } else {
            validationInfo.add(fieldDefinition.getFieldName() + " ---> the expected value could not be extracted ==> false");
        }
        if (!validationInfo.isEmpty()) {
            info.addAll(validationInfo);
        }
        return validationInfo.isEmpty();
    }

    private FieldDefinition getFieldFromVariable(Variable variable) {
        FieldDefinition fieldDefinition = variable.getInfo(FieldBasedVariableProducerWrapper.SOURCE_FIELD);
        if (fieldDefinition == null) {
            fieldDefinition = this.myClassRepository.getFieldDefinitionByName(this.removeSuffixFromLabel(variable.getLabel()));
        }
        return fieldDefinition;
    }

    private Object getVariableValueObject(Variable variable, FieldDefinition fieldDefinition) {
        Object value = variable.getValueObject();
        if (variable instanceof DropDownVariable && value instanceof String) {
            ValueResolver resolver = FieldDefinitionUtil.createValueResolver(this.myClassRepository, fieldDefinition);
            value = resolver.parseValueString((String)value);
        }
        return value;
    }

    private void performFieldValidation(DataSet dataSet, Object expectedValue, DataSetField field, FieldDefinition fieldDef, List<String> info) {
        Object actualValue = this.getDataSetValue(dataSet, field);
        if (actualValue == null) {
            info.add("NO result data produced for  '" + field.getFieldName() + "'");
        } else if (!StandardVariableValidator.classesAreCompatible(actualValue, expectedValue)) {
            if (expectedValue instanceof ArrayModel) {
                if (!this.compare(actualValue, (ArrayModel)expectedValue)) {
                    this.printFieldDiff(fieldDef, expectedValue, actualValue, info);
                }
            } else if (!field.getDataType().areObjectsEqual(actualValue.toString(), expectedValue)) {
                this.printFieldDiff(field.getFieldName(), field.getDataType(), expectedValue, actualValue, info);
            }
        } else if (fieldDef.hasValueClassFactory()) {
            if (!actualValue.equals(expectedValue)) {
                this.printFieldDiff(fieldDef, expectedValue, actualValue, info);
            }
        } else if (!field.getDataType().areObjectsEqual(actualValue, expectedValue)) {
            this.printFieldDiff(fieldDef, expectedValue, actualValue, info);
        }
    }

    void printFieldDiff(String label, DataType dataType, Object variableValue, Object dataSetValue, List<String> info) {
        info.add(label + " ---> comparing '" + this.myDataDescriber.describeObject(variableValue, dataType) + "' and '" + this.myDataDescriber.describeObject(dataSetValue, dataType) + "' ==> false");
    }

    void printFieldDiff(FieldDefinition fd, Object variableValue, Object dataSetValue, List<String> info) {
        info.add(fd.getCanonicalName() + " ---> comparing '" + this.myDataDescriber.describeObject(variableValue, fd) + "' and '" + this.myDataDescriber.describeObject(dataSetValue, fd) + "' ==> false");
    }

    private Object getDataSetValue(DataSet dataSet, DataSetField field) {
        Object actualValue;
        try {
            actualValue = field.getValueFromDataSet(dataSet);
        }
        catch (DataSetValueNotFoundException x) {
            actualValue = null;
        }
        return actualValue;
    }

    boolean compare(Object actualValue, ArrayModel expectedModel) {
        boolean success;
        Map<Object, Object> arrayModelMap = expectedModel.toMap();
        if (actualValue.getClass().isArray()) {
            SortedMap<Integer, Object> valueMap = DataSetArrayHelper.convertArrayToMap(actualValue);
            success = this.areExpectedValuesPresentAndCorrect(arrayModelMap, valueMap);
        } else if (actualValue instanceof Map) {
            Map valueMap = (Map)actualValue;
            success = this.areExpectedValuesPresentAndCorrect(arrayModelMap, valueMap);
        } else if (actualValue instanceof Set) {
            HashSet<Object> expectedValues = new HashSet<Object>(arrayModelMap.values());
            Set actualValues = (Set)actualValue;
            success = actualValues.equals(expectedValues);
        } else {
            throw new IncompatibleDataSetValueException("Cannot compare a single value against an array model.");
        }
        return success;
    }

    private <T, V> boolean areExpectedValuesPresentAndCorrect(Map<T, V> expectedMap, Map<T, V> actualMap) {
        V actualValue;
        Map.Entry<T, V> entry;
        V expectedValue;
        boolean allEqual = true;
        Iterator<Map.Entry<T, V>> iterator = expectedMap.entrySet().iterator();
        while (iterator.hasNext() && (allEqual = this.eq(expectedValue = (entry = iterator.next()).getValue(), actualValue = actualMap.get(entry.getKey())))) {
        }
        return allEqual;
    }

    private boolean eq(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    private static boolean classesAreCompatible(Object obj1, Object obj2) {
        if (obj1.getClass() == obj2.getClass()) {
            return true;
        }
        if (obj1 instanceof EREDate) {
            return obj2 instanceof EREDate || obj2 instanceof Date;
        }
        if (obj2 instanceof EREDate) {
            return obj1 instanceof EREDate || obj1 instanceof Date;
        }
        return false;
    }
}

