/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.input.db;

import com.ericsson.ere.gui.simulator.SimulationField;
import com.ericsson.ere.gui.simulator.input.db.DatabaseColumnNameLimitationException;
import com.ericsson.ere.gui.simulator.input.db.DatabaseConfig;
import com.ericsson.ere.gui.simulator.input.db.DatabaseUtil;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.Config;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class DatabaseAccess {
    static final String COLUMNS_TABLE = "_COLUMNS";
    private static final String TAG_DB_CONFIG = "DatabaseConfig";
    private static final String TAG_CONNECTION = "Connection";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_URL = "url";
    private static final String ATTR_USER = "user";
    private static final String ATTR_DRIVER = "driver";
    private static List<DatabaseConfig> myDatabaseConfig = new ArrayList<DatabaseConfig>();
    public static final String DB_MYSQL = "MySQL";
    public static final String DB_ORACLE = "Oracle";
    public static final String DB_JAVA = "Java";
    private static boolean reloadDatabaseConfig = true;

    public static List<DatabaseConfig> loadDatabaseConfig() {
        if (myDatabaseConfig == null) {
            myDatabaseConfig = new ArrayList<DatabaseConfig>();
        }
        if (!reloadDatabaseConfig) {
            return myDatabaseConfig;
        }
        myDatabaseConfig.clear();
        Vector<Node> config = Config.getInstance().getConfigFor(TAG_DB_CONFIG);
        if (config == null) {
            return new ArrayList<DatabaseConfig>();
        }
        for (int i = 0; i < config.size(); ++i) {
            Node node = config.get(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(TAG_CONNECTION)) continue;
            String myDbType = node.getAttributes().getNamedItem(ATTR_TYPE).getNodeValue();
            String myDbName = node.getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
            String myDbUrl = node.getAttributes().getNamedItem(ATTR_URL).getNodeValue();
            String myDbUser = node.getAttributes().getNamedItem(ATTR_USER).getNodeValue();
            String myDbDriver = node.getAttributes().getNamedItem(ATTR_DRIVER).getNodeValue();
            myDatabaseConfig.add(new DatabaseConfig(myDbName, myDbType, myDbUrl, myDbUser, myDbDriver));
        }
        reloadDatabaseConfig = false;
        return myDatabaseConfig;
    }

    public static List<DatabaseConfig> saveDatabaseConfig() throws Exception {
        StringBuilder xmlBuilder = new StringBuilder();
        xmlBuilder.append("\t<DatabaseConfig>");
        for (DatabaseConfig config : myDatabaseConfig) {
            xmlBuilder.append("\n\t\t<Connection");
            xmlBuilder.append(" type=\"" + config.get("Type") + "\"");
            xmlBuilder.append(" name=\"" + config.get("Name") + "\"");
            xmlBuilder.append(" url=\"" + config.get("URL") + "\"");
            xmlBuilder.append(" user=\"" + config.get("User") + "\"");
            xmlBuilder.append(" driver=\"" + config.get("Driver") + "\"");
            xmlBuilder.append("/>");
        }
        xmlBuilder.append("\n\t</DatabaseConfig>\n");
        Config.getInstance().saveConfig("DatabaseConfig.xml", xmlBuilder.toString());
        Config.getInstance().reloadDatabaseConfig();
        reloadDatabaseConfig = true;
        return DatabaseAccess.loadDatabaseConfig();
    }

    public static List<DatabaseConfig> getConfig() {
        return myDatabaseConfig;
    }

    private static void loadDriver(String driver) throws Exception {
        try {
            Class.forName(driver).newInstance();
        }
        catch (Exception e) {
            Logger.getLogger("rma").warning(e.getMessage());
            throw new Exception("The database driver '" + driver + "' can't be found");
        }
    }

    public static void connect(DatabaseConfig config) throws Exception {
        try {
            Connection sqlConnection = config.getConnection();
            if (sqlConnection == null || sqlConnection.isClosed()) {
                DatabaseAccess.loadDriver(config.get("Driver"));
                sqlConnection = DriverManager.getConnection(config.get("URL"), config.get("User"), config.get("Password"));
                config.setConnection(sqlConnection);
            }
        }
        catch (Exception e) {
            Logger.getLogger("rma").warning(e.getMessage());
            throw new Exception("Couldn't connect to database " + config.get("Name") + "\n" + e.getMessage());
        }
    }

    private static void checkConnection(DatabaseConfig config) throws Exception {
        if (!myDatabaseConfig.contains(config)) {
            throw new Exception("Invalid config!");
        }
        if (config.getConnection() == null) {
            throw new Exception("Not connected!");
        }
    }

    public static List<String> getTableNames(DatabaseConfig config) throws Exception {
        DatabaseAccess.checkConnection(config);
        ResultSet result = config.getConnection().getMetaData().getTables(config.getConnection().getCatalog(), null, "", null);
        ArrayList<String> tables = new ArrayList<String>();
        while (result.next()) {
            if (result.getString("TABLE_NAME").toUpperCase().endsWith(COLUMNS_TABLE.toUpperCase())) continue;
            tables.add(result.getString("TABLE_NAME"));
        }
        return tables;
    }

    public static int getFieldTableIndex(DatabaseConfig config, String tableName, String columnName) throws SQLException {
        ResultSet tableResult = config.getConnection().getMetaData().getColumns(config.getConnection().getCatalog(), null, tableName, "");
        int fieldIndex = -1;
        int column = 0;
        while (tableResult.next()) {
            if (tableResult.getString("COLUMN_NAME").equals(columnName)) {
                fieldIndex = column;
                break;
            }
            ++column;
        }
        return fieldIndex;
    }

    public static int getGroupedFieldTableIndex(DatabaseConfig config, String tableName) throws Exception {
        return DatabaseAccess.getFieldTableIndex(config, tableName, "GROUPED_DATABASE_SIMULATION_FIELDS");
    }

    public static List<String> getTableColumns(DatabaseConfig config, String tableName, boolean getRealNames) throws Exception {
        ArrayList<String> fields = new ArrayList<String>();
        ResultSet tableResult = config.getConnection().getMetaData().getColumns(config.getConnection().getCatalog(), null, tableName, "");
        ResultSet columnsTableResult = DatabaseAccess.executeQuery(config, "SELECT * FROM " + tableName + COLUMNS_TABLE);
        columnsTableResult.next();
        int column = 1;
        while (tableResult.next()) {
            String columnName = tableResult.getString("COLUMN_NAME");
            String realColumnName = columnsTableResult.getString(column);
            if (getRealNames) {
                if (columnName.equals("GROUPED_DATABASE_SIMULATION_FIELDS")) {
                    String[] groupedColumnNames;
                    for (String groupedColumn : groupedColumnNames = realColumnName.split("\u00a4")) {
                        fields.add(groupedColumn);
                    }
                } else {
                    fields.add(realColumnName);
                }
            } else {
                fields.add(columnName);
            }
            ++column;
        }
        return fields;
    }

    public static int getNumberOfContextFields(DatabaseConfig config, String tableName) throws Exception {
        int retVal = 0;
        ResultSet tableResult = config.getConnection().getMetaData().getColumns(null, null, tableName, "");
        ResultSet columnsTableResult = DatabaseAccess.executeQuery(config, "SELECT * FROM " + tableName + COLUMNS_TABLE);
        columnsTableResult.next();
        int column = 1;
        while (tableResult.next()) {
            String columnName = tableResult.getString("COLUMN_NAME");
            if (columnName.equals("GROUPED_DATABASE_SIMULATION_FIELDS")) {
                String groupedContextFieldNames = columnsTableResult.getString(column);
                String[] ungroupedContextFieldNames = groupedContextFieldNames.split("\u00a4");
                retVal = ungroupedContextFieldNames.length;
                break;
            }
            ++column;
        }
        return retVal;
    }

    public static int getTableColumnsCount(DatabaseConfig config, String tableName) throws Exception {
        ResultSet result = config.getConnection().getMetaData().getColumns(config.getConnection().getCatalog(), null, tableName, "");
        result.next();
        result.last();
        return result.getRow();
    }

    public static int getTableRowCount(DatabaseConfig config, String tableName) throws Exception {
        DatabaseAccess.checkConnection(config);
        ResultSet result = DatabaseAccess.executeQuery(config, "SELECT count(*) FROM " + tableName);
        result.next();
        return result.getInt(1);
    }

    public static synchronized void executeStatement(DatabaseConfig config, String sql) throws Exception {
        DatabaseAccess.checkConnection(config);
        Statement statement = null;
        try {
            statement = config.getConnection().createStatement();
            statement.execute(sql);
        }
        catch (Exception e) {
            Logger.getLogger("rma").warning(e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    public static synchronized ResultSet executeQuery(DatabaseConfig config, String sql) throws Exception {
        DatabaseAccess.checkConnection(config);
        Statement statement = null;
        try {
            statement = config.getConnection().createStatement();
            ResultSet rs = statement.executeQuery(sql);
            return rs;
        }
        catch (Exception e) {
            Logger.getLogger("rma").warning(e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    public static void removeTable(DatabaseConfig config, String tableName) throws Exception {
        try {
            DatabaseAccess.executeStatement(config, "DROP TABLE " + tableName);
            DatabaseAccess.executeStatement(config, "DROP TABLE " + tableName + COLUMNS_TABLE);
        }
        catch (Exception e) {
            throw new Exception("The database table " + tableName + " cannot be removed!\n" + e.getMessage());
        }
    }

    public static void addTable(DatabaseConfig config, String tableName, List<SimulationField> variables) throws Exception {
        try {
            String[] statements;
            int maxColumnNameLength = DatabaseAccess.fetchMaxLengthOfColumnNames(config);
            for (String sql : statements = DatabaseUtil.getCreateTableStatement(tableName, variables, config.get("Type"), maxColumnNameLength)) {
                DatabaseAccess.executeStatement(config, sql);
            }
        }
        catch (DatabaseColumnNameLimitationException dle) {
            throw dle;
        }
        catch (Exception e) {
            throw new Exception("The database table " + tableName + " cannot be added!\n" + e.getMessage());
        }
    }

    public static void selectTable(DatabaseConfig config, String tableName) throws Exception {
        config.set("Table", tableName);
    }

    public static void renameTable(DatabaseConfig config, String oldName, String newName) throws Exception {
        try {
            DatabaseAccess.executeStatement(config, "RENAME TABLE " + oldName + " TO " + newName);
            DatabaseAccess.executeStatement(config, "RENAME TABLE " + oldName + COLUMNS_TABLE + " TO " + newName + COLUMNS_TABLE);
        }
        catch (Exception e) {
            throw new Exception("The database table " + oldName + " couldn't be renamed!\n" + e.getMessage());
        }
    }

    public static String getTableName(DatabaseConfig config) {
        return config.get("Table");
    }

    public static ResultSet getDatabaseTable(DatabaseConfig config) throws Exception {
        return DatabaseAccess.executeQuery(config, "SELECT * FROM " + config.get("Table"));
    }

    private static int fetchMaxLengthOfColumnNames(DatabaseConfig config) throws Exception {
        int maxLength = 25;
        try {
            String versionQuery = DatabaseUtil.getDatabaseServerVersionQuery(config.get("Type"));
            ResultSet result = DatabaseAccess.executeQuery(config, versionQuery);
            result.next();
            String versionString = result.getString(1);
            maxLength = DatabaseUtil.getMaximumColumnNameLengthForDatabase(config.get("Type"), versionString);
        }
        catch (Exception e) {
            RmaDefs.loggerSimulator.warning("Not able to fetch database server version. An exception occured.");
        }
        return maxLength;
    }
}

