/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.input.db;

import com.ericsson.ere.gui.simulator.SimulationDataDiff;
import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import com.ericsson.ere.gui.simulator.SimulationField;
import com.ericsson.ere.gui.simulator.SimulationSet;
import com.ericsson.ere.gui.simulator.SimulatorPanel;
import com.ericsson.ere.gui.simulator.input.SimulationDataSource;
import com.ericsson.ere.gui.simulator.input.db.DatabaseAccess;
import com.ericsson.ere.gui.simulator.input.db.DatabaseColumnNameLimitationException;
import com.ericsson.ere.gui.simulator.input.db.DatabaseConfig;
import com.ericsson.ere.gui.simulator.input.db.DatabaseUtil;
import com.ericsson.ere.gui.simulator.input.db.JDBCConnectDialog;
import com.ericsson.ere.gui.simulator.search.SQLSimulationTool;
import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.RmaAction;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class DatabaseSimulationSource
extends SimulationDataSource {
    private DatabaseConfig myCurrentConnection;
    private String mySelectedTable;
    private RmaAction mySaveAction;
    private RmaAction mySaveAsAction;
    private RmaAction mySqlToolAction;

    public DatabaseSimulationSource(SimulatorPanel simulatorPanel, SimulationSet simulationSet) {
        super(simulatorPanel, simulationSet);
    }

    @Override
    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new RmaAction(this, "openAction", "Open...", "data_open24.png", "data_open16.png", "Opens a simulation set from a database.", KeyStroke.getKeyStroke(79, 2)));
        this.mySaveAction = new RmaAction(this, "saveAction", "Save", "data_disk24.png", "data_disk16.png", "Saves the current simulation set to the selected database table.", KeyStroke.getKeyStroke(83, 2));
        this.mySaveAsAction = new RmaAction(this, "saveAsAction", "Save as...", "data_save_as24.png", "data_save_as16.png", "Saves the current simulation set to another database table.", KeyStroke.getKeyStroke(83, 3));
        this.mySqlToolAction = new RmaAction(this, "sqlToolAction", "Search...", "data_find24.png", "data_find16.png", "Search for simulation cases in the selected database table.", KeyStroke.getKeyStroke(70, 3));
        actions.add(this.mySaveAction);
        actions.add(this.mySaveAsAction);
        actions.add(this.mySqlToolAction);
        return actions;
    }

    @Override
    public boolean save() {
        if (this.myCurrentConnection == null) {
            return this.doSaveAs();
        }
        return this.doSave(false);
    }

    @Override
    public boolean saveAs() {
        return this.doSaveAs();
    }

    public void saveAction(ActionEvent e) {
        this.mySimulatorPanel.updateSimulationSets(true);
        if (!super.checkValidity()) {
            return;
        }
        if (this.myCurrentConnection == null) {
            this.doSaveAs();
        } else {
            this.doSave(false);
        }
    }

    public void saveAsAction(ActionEvent e) {
        this.mySimulatorPanel.updateSimulationSets(true);
        if (!super.checkValidity()) {
            return;
        }
        this.doSaveAs();
    }

    private boolean doSaveAs() {
        DatabaseConfig selectedConfig;
        String currentTable = null;
        if (this.myCurrentConnection != null) {
            currentTable = this.myCurrentConnection.get("Table");
        }
        if ((selectedConfig = JDBCConnectDialog.showDialog(this.mySimulationSet.getSimulationModel(), this, GuiServiceCenter.getInstance().getMainWindow(), 1)) != null) {
            boolean overwrite = false;
            if (currentTable == null || !currentTable.equals(selectedConfig.get("Table"))) {
                overwrite = true;
                if (!this.askQuestion("RMA", "The simulation data in this table will be overwritten. Do you wan't to continue?")) {
                    return false;
                }
            }
            this.setSelectedTable(selectedConfig);
            return this.doSave(overwrite);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSave(boolean overwrite) {
        String sqlStatement = "";
        boolean shouldOverwrite = overwrite;
        try {
            this.mySimulatorPanel.setCursor(new Cursor(3));
            List<SimulationDataDiff> diffList = this.compareFields();
            String message = SimulationDataDiff.getDiffMessage(diffList, true, true, false);
            String tableName = this.myCurrentConnection.get("Table");
            if (!"".equals(message)) {
                List<SimulationField> fields = DatabaseUtil.arrangeFieldsForTable(this.mySimulationModel.getSimulationData(false, true));
                DatabaseAccess.removeTable(this.myCurrentConnection, tableName);
                DatabaseAccess.addTable(this.myCurrentConnection, tableName, fields);
                shouldOverwrite = true;
            }
            List<SimulationField> allFields = this.mySimulationModel.getSimulationData(true, false);
            HashMap<String, SimulationField> contextFields = this.mySimulationModel.getContextFields();
            int groupedFieldIndex = DatabaseAccess.getGroupedFieldTableIndex(this.myCurrentConnection, tableName);
            if (shouldOverwrite) {
                DatabaseAccess.executeStatement(this.myCurrentConnection, DatabaseUtil.getDeleteRowsStatement(tableName));
                Vector<Vector> dataVector = this.mySimulationModel.getDataVector();
                if (dataVector.size() > 0) {
                    ArrayList<Object[]> data = new ArrayList<Object[]>(dataVector.size());
                    for (int i = 0; i < dataVector.size(); ++i) {
                        Object[] row = dataVector.get(i).toArray();
                        if (groupedFieldIndex != -1) {
                            row = this.groupContextFields(row, allFields, contextFields, groupedFieldIndex);
                        }
                        row = this.convertFieldValues(row);
                        data.add(row);
                    }
                    sqlStatement = DatabaseUtil.getInsertRowStatement(tableName, data);
                    DatabaseAccess.executeStatement(this.myCurrentConnection, sqlStatement);
                }
            } else {
                HashMap<String, SimulationDataTableModel.ModifiedStatus> modifiedRows = this.mySimulationModel.getModifiedRows();
                ArrayList<Object[]> addedRows = new ArrayList<Object[]>();
                ArrayList<String> deletedRows = new ArrayList<String>();
                ArrayList<Object[]> editedRows = new ArrayList<Object[]>();
                for (Map.Entry currentEntry : modifiedRows.entrySet()) {
                    Object[] row;
                    String rowId = (String)currentEntry.getKey();
                    SimulationDataTableModel.ModifiedStatus modifiedStatus = (SimulationDataTableModel.ModifiedStatus)((Object)currentEntry.getValue());
                    if (modifiedStatus == SimulationDataTableModel.ModifiedStatus.ROW_REMOVED) {
                        deletedRows.add(rowId);
                        continue;
                    }
                    if (modifiedStatus == SimulationDataTableModel.ModifiedStatus.ROW_ADDED) {
                        row = this.createRow(groupedFieldIndex, rowId, allFields, contextFields);
                        addedRows.add(row);
                        continue;
                    }
                    if (modifiedStatus != SimulationDataTableModel.ModifiedStatus.ROW_EDITED) continue;
                    row = this.createRow(groupedFieldIndex, rowId, allFields, contextFields);
                    editedRows.add(row);
                }
                if (deletedRows.size() > 0) {
                    sqlStatement = DatabaseUtil.getDeleteRowsStatement(tableName, deletedRows);
                    DatabaseAccess.executeStatement(this.myCurrentConnection, sqlStatement);
                }
                if (addedRows.size() > 0) {
                    sqlStatement = DatabaseUtil.getInsertRowStatement(tableName, addedRows);
                    DatabaseAccess.executeStatement(this.myCurrentConnection, sqlStatement);
                }
                if (editedRows.size() > 0) {
                    List<String> columns = this.mySimulationModel.getColumnNames(true);
                    columns = DatabaseAccess.getTableColumns(this.myCurrentConnection, tableName, false);
                    Object[][] editedData = new Object[editedRows.size()][columns.size()];
                    for (int i = 0; i < editedRows.size(); ++i) {
                        editedData[i] = (Object[])editedRows.get(i);
                    }
                    sqlStatement = DatabaseUtil.getUpdateRowStatement(tableName, columns, editedData);
                    DatabaseAccess.executeStatement(this.myCurrentConnection, sqlStatement);
                }
            }
            this.showInformation("RMA", "The simulation case(s) was succesfully saved.");
            this.mySimulationSet.resetModified();
            boolean bl = true;
            return bl;
        }
        catch (DatabaseColumnNameLimitationException dle) {
            this.handleError(dle, "Unable to save simulation", new Object[]{dle.getMessage()});
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.handleError(e, "SimulatorDialog failed to save set to database", new Object[]{sqlStatement});
            boolean bl = false;
            return bl;
        }
        finally {
            this.mySimulatorPanel.setCursor(new Cursor(0));
        }
    }

    private Object[] createRow(int groupedFieldIndex, String rowId, List<SimulationField> allFields, Map<String, SimulationField> contextFields) {
        Object[] row = this.mySimulationModel.getRowData(rowId);
        if (groupedFieldIndex != -1) {
            row = this.groupContextFields(row, allFields, contextFields, groupedFieldIndex);
        }
        return this.convertFieldValues(row);
    }

    private Object[] convertFieldValues(Object[] row) {
        Object[] convertedData = row;
        for (int ii = 0; ii < convertedData.length; ++ii) {
            String valueString = DataType.valueToString(convertedData[ii]);
            convertedData[ii] = valueString;
        }
        return convertedData;
    }

    private Object[] groupContextFields(Object[] row, List<SimulationField> allFields, Map<String, SimulationField> contextFields, int indexOfGroupedFieldsInDatabase) {
        ArrayList<Object> newRow = new ArrayList<Object>();
        SimulationField groupedField = new SimulationField("GROUPED_DATABASE_SIMULATION_FIELDS", "", false);
        for (int i = 0; i < allFields.size(); ++i) {
            SimulationField contextField = contextFields.get(allFields.get(i).getName());
            if (contextField != null) {
                groupedField.setValueObject(groupedField.getValueObject().toString() + row[i]);
                if (i >= allFields.size() - 1) continue;
                groupedField.setValueObject(groupedField.getValueObject() + "\u00a4");
                continue;
            }
            newRow.add(row[i]);
        }
        newRow.add(indexOfGroupedFieldsInDatabase, groupedField.getValueObject());
        return newRow.toArray();
    }

    private Object[] ungroupContextField(Object[] row, HashMap<String, SimulationField> contextFields, int indexOfGroupedFieldsInDatabase, int indexOfContextSelectorField, int nrOfContextFields) {
        String[] groupedFields = ((String)row[indexOfGroupedFieldsInDatabase]).split("\u00a4", -1);
        Object[] newRow = new Object[row.length + contextFields.entrySet().size() - 1];
        System.arraycopy(row, 0, newRow, 0, indexOfContextSelectorField + 1);
        System.arraycopy(groupedFields, 0, newRow, indexOfContextSelectorField + 1, nrOfContextFields);
        System.arraycopy(row, indexOfContextSelectorField + 1, newRow, indexOfContextSelectorField + nrOfContextFields + 1, row.length - indexOfContextSelectorField - 2);
        return newRow;
    }

    private List<SimulationDataDiff> compareFields() throws Exception {
        List<String> columns = DatabaseAccess.getTableColumns(this.myCurrentConnection, this.myCurrentConnection.get("Table"), true);
        ArrayList<SimulationField> fields = new ArrayList<SimulationField>(columns.size());
        for (String column : columns) {
            fields.add(new SimulationField(column, null, false));
        }
        List<SimulationDataDiff> diffList = this.mySimulationSet.getSimulationModel().compareFields(fields);
        return diffList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAction(ActionEvent e) {
        if (this.mySimulationSet.isModified() && !this.askQuestion("RMA Simulation", "You have unsaved changes in this simulation set that will be lost if you don't save first!\nWould you like to go ahead without saving your changes?")) {
            return;
        }
        this.mySimulatorPanel.updateSimulationSets(true);
        DatabaseConfig selectedConfig = JDBCConnectDialog.showDialog(this.mySimulationSet.getSimulationModel(), this, GuiServiceCenter.getInstance().getMainWindow(), 2);
        if (selectedConfig != null) {
            try {
                this.mySimulatorPanel.setCursor(new Cursor(3));
                ResultSet resultSet = DatabaseAccess.getDatabaseTable(selectedConfig);
                this.loadResultSet(selectedConfig, resultSet);
                this.setSelectedTable(selectedConfig);
                List<SimulationDataDiff> diffList = this.compareFields();
                String message = SimulationDataDiff.getDiffMessage(diffList, true, true, true);
                if (!message.equals("")) {
                    this.showInformation("RMA", message);
                }
                if (this.mySimulationModel.getRowCount() > 0) {
                    this.mySimulationSet.getSimulationDataTable().setSelectedRow(0);
                }
            }
            catch (Exception x) {
                this.handleError(x, "Simulator failed to load simulation set from database table '" + selectedConfig.get("Name"), null);
            }
            finally {
                this.mySimulatorPanel.setCursor(new Cursor(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadResultSet(DatabaseConfig config, ResultSet data) throws Exception {
        ArrayList<Object[]> set = new ArrayList<Object[]>();
        try {
            HashMap<String, SimulationField> contextFields = this.mySimulationModel.getContextFields();
            int groupedFieldIndex = DatabaseAccess.getGroupedFieldTableIndex(config, config.get("Table"));
            int contextSelectorIndex = -1;
            int nrOfContextFields = -1;
            if (groupedFieldIndex != -1) {
                String contextFieldIdentifier = this.mySimulatorPanel.getService().getClassRepository().getContextFieldIdentifier();
                contextSelectorIndex = DatabaseAccess.getFieldTableIndex(config, config.get("Table"), contextFieldIdentifier);
                nrOfContextFields = DatabaseAccess.getNumberOfContextFields(config, config.get("Table"));
            }
            while (data.next()) {
                int colCount = data.getMetaData().getColumnCount();
                Object[] dataRow = new Object[colCount];
                for (int i = 0; i < colCount; ++i) {
                    dataRow[i] = data.getObject(i + 1);
                }
                if (groupedFieldIndex != -1) {
                    dataRow = this.ungroupContextField(dataRow, contextFields, groupedFieldIndex, contextSelectorIndex, nrOfContextFields);
                }
                set.add(dataRow);
            }
            this.mySimulationModel.init(set);
        }
        finally {
            data.close();
        }
    }

    public void sqlToolAction(ActionEvent e) {
        DatabaseConfig selectedConfig = JDBCConnectDialog.showDialog(this.mySimulationSet.getSimulationModel(), this, GuiServiceCenter.getInstance().getMainWindow(), 0);
        this.setSelectedTable(selectedConfig);
        if (this.myCurrentConnection != null) {
            SQLSimulationTool sqlTool = new SQLSimulationTool(this, this.mySimulationSet.getSimulationModel(), this.mySimulatorPanel);
            sqlTool.setVisible(true);
        }
    }

    public void disconnect() {
        this.mySaveAction.setEnabled(false);
        this.mySaveAsAction.setEnabled(false);
        this.myCurrentConnection = null;
        this.mySelectedTable = "";
        this.mySimulationSet.updateSessionName();
    }

    public void setSelectedTable(DatabaseConfig selectedConnection) {
        this.myCurrentConnection = selectedConnection;
        if (selectedConnection != null) {
            this.mySelectedTable = selectedConnection.get("Table");
        }
        this.mySimulationSet.updateSessionName();
    }

    @Override
    public String getSessionName() {
        if (this.myCurrentConnection != null) {
            return "(Database: " + this.myCurrentConnection.get("Name") + " - " + this.mySelectedTable + ")";
        }
        return "";
    }

    public DatabaseConfig getCurrentDatabaseConfig() {
        return this.myCurrentConnection;
    }

    @Override
    public void setDefaultLocation(String name) {
    }

    protected void handleError(Exception e, String errorMessage, Object[] additionalInfo) {
        ExceptionUtil.handleException(e, "simulation", 1, errorMessage, true, additionalInfo);
    }

    protected void showInformation(String title, String message) {
        DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), title, message);
    }

    protected boolean askQuestion(String title, String message) {
        return DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), title, message);
    }
}

