/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.input.db;

import com.ericsson.ere.gui.simulator.ContextSimulationField;
import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import com.ericsson.ere.gui.simulator.SimulationField;
import com.ericsson.ere.gui.simulator.input.db.DatabaseColumnNameLimitationException;
import ericsson.ere.datatype.DataType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatabaseUtil {
    private static final String[][] dataJavaToMySql = new String[][]{{"java.lang.String", "TEXT"}, {"java.lang.Double", "DOUBLE"}, {"java.lang.Short", "SMALLINT"}, {"ericsson.ere.datatype.UnsignedInt32", "INTEGER UNSIGNED"}, {"ericsson.ere.datatype.UnsignedInt16", "SMALLINT"}, {"ericsson.ere.datatype.UnsignedInt8", "TINYINT"}, {"java.lang.Integer", "INTEGER"}, {"java.lang.Boolean", "TEXT"}, {"java.lang.Long", "BIGINT"}, {"java.util.Date", "TEXT"}, {"ericsson.ere.datatype.Time", "TEXT"}, {"ericsson.vareditor.variable.array.ObjectArrayModel", "TEXT"}, {"ericsson.vareditor.variable.ArrayModel", "TEXT"}, {"ericsson.ere.datatype.OctetString", "TEXT"}, {"ericsson.ere.datatype.BcdString", "TEXT"}, {"ericsson.ere.datatype.Decimal", "TEXT"}, {"ericsson.ere.datatype.MonetaryUnits", "TEXT"}};
    private static final String SQL_VERSION_QUERY_MYSQL = "SELECT version();";
    public static final int DEFAULT_MAX_COLUMN_NAME_LENGTH = 25;
    private static final int MAX_COLUMN_NAME_LENGTH_PRIOR_4_1_MYSQL = 25;
    private static final int MAX_COLUMN_NAME_LENGTH_POST_4_1_MYSQL = 64;
    private static final String[] ILLEGAL_CHARS = new String[]{"\\(", "\\)", "\\.", "\\@", "\\%", " ", "\\-"};
    private static final String[] ESCAPED_CHARS = new String[]{"_lp_", "_rp_", "_pe_", "_at_", "_pc_", "_", "_hy_"};

    private static String escape(String src) {
        String escapedString = src;
        for (int i = 0; i < ILLEGAL_CHARS.length; ++i) {
            escapedString = src.replaceAll(ILLEGAL_CHARS[i], ESCAPED_CHARS[i] + "");
        }
        return escapedString;
    }

    private static String formatFieldName(String fieldName, int maxFieldNameLength) throws DatabaseColumnNameLimitationException {
        String escapedName = DatabaseUtil.escape(fieldName);
        if (escapedName.length() <= maxFieldNameLength) {
            return escapedName;
        }
        throw new DatabaseColumnNameLimitationException("The connected database limits the length of field names to maximum " + maxFieldNameLength + " characters.");
    }

    static Object formatData(Object data) {
        return data;
    }

    static String[] getCreateTableStatement(String tableName, List<SimulationField> fields, String databaseType, int maxFieldNameLength) throws DatabaseColumnNameLimitationException {
        String[] queries = new String[]{"", "", ""};
        queries[0] = queries[0] + "ROWID " + DatabaseUtil.getDBDataType("java.lang.String", databaseType) + ",\n";
        queries[0] = queries[0] + "SELECTED_FIELDS " + DatabaseUtil.getDBDataType("java.lang.String", databaseType) + ",\n";
        queries[1] = queries[1] + "ROWID " + DatabaseUtil.getDBDataType("java.lang.String", databaseType) + ",\n";
        queries[1] = queries[1] + "SELECTED_FIELDS " + DatabaseUtil.getDBDataType("java.lang.String", databaseType) + ",\n";
        queries[2] = queries[2] + "'ROWID',\n";
        queries[2] = queries[2] + "'SELECTED_FIELDS',\n";
        for (int i = 0; i < fields.size(); ++i) {
            SimulationField field = fields.get(i);
            String realFieldName = field.getName();
            String fieldType = DatabaseUtil.getDBDataType(field.getValueObject().getClass().getName(), databaseType);
            String fieldName = "";
            if (realFieldName.contains("\u00a4")) {
                fieldName = "GROUPED_DATABASE_SIMULATION_FIELDS";
                queries[2] = queries[2] + "'" + realFieldName + "'";
            } else {
                fieldName = DatabaseUtil.formatFieldName(realFieldName, maxFieldNameLength);
                queries[2] = queries[2] + "'" + realFieldName + "'";
            }
            queries[0] = queries[0] + "`" + fieldName + "` " + fieldType;
            queries[1] = queries[1] + "`" + fieldName + "` " + DatabaseUtil.getDBDataType("java.lang.String", databaseType);
            if (i >= fields.size() - 1) continue;
            queries[0] = queries[0] + ",\n";
            queries[1] = queries[1] + ",\n";
            queries[2] = queries[2] + ",\n";
        }
        queries[0] = "CREATE TABLE " + tableName + " (" + queries[0] + ")";
        queries[1] = "CREATE TABLE " + tableName + "_COLUMNS" + " (" + queries[1] + ")";
        queries[2] = "INSERT INTO " + tableName + "_COLUMNS" + " VALUES (" + queries[2] + ")";
        return queries;
    }

    static String getDeleteRowsStatement(String tableName, List<String> rowIDs) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM " + tableName + " WHERE " + "ROWID" + " IN\n(");
        for (int i = 0; i < rowIDs.size(); ++i) {
            sql.append("'" + rowIDs.get(i) + "'");
            if (i >= rowIDs.size() - 1) continue;
            sql.append(",\n");
        }
        sql.append(");");
        return sql.toString();
    }

    static String getDeleteRowsStatement(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM " + tableName);
        return sql.toString();
    }

    static String getInsertRowStatement(String tableName, List<Object[]> rows) {
        StringBuilder sql = new StringBuilder("INSERT INTO " + tableName + " VALUES\n");
        for (int row = 0; row < rows.size(); ++row) {
            sql.append("(");
            Object[] rowData = rows.get(row);
            for (int col = 0; col < rowData.length; ++col) {
                sql.append("'" + DatabaseUtil.formatData(rowData[col]) + "'");
                if (col >= rowData.length - 1) continue;
                sql.append(", ");
            }
            sql.append(")");
            if (row >= rows.size() - 1) continue;
            sql.append(",\n");
        }
        sql.append(";");
        return sql.toString();
    }

    static String getUpdateRowStatement(String tableName, List<String> columnNames, Object[][] data) {
        int row;
        StringBuilder sql = new StringBuilder("UPDATE " + tableName + " SET\n");
        for (int col = 0; col < columnNames.size(); ++col) {
            if (col == SimulationDataTableModel.INDEX_OF_ROW_ID) continue;
            sql.append("`" + columnNames.get(col) + "` = CASE\n");
            for (row = 0; row < data.length; ++row) {
                sql.append(" WHEN ROWID='" + data[row][SimulationDataTableModel.INDEX_OF_ROW_ID] + "'");
                sql.append(" THEN '" + DatabaseUtil.formatData(data[row][col]) + "'");
            }
            sql.append(" END");
            if (col >= columnNames.size() - 1) continue;
            sql.append(",\n");
        }
        StringBuilder ids = new StringBuilder();
        for (row = 0; row < data.length; ++row) {
            ids.append("'" + data[row][SimulationDataTableModel.INDEX_OF_ROW_ID] + "'");
            if (row >= data.length - 1) continue;
            ids.append(",");
        }
        sql.append(" \nWHERE ROWID IN (" + ids + ")");
        return sql.toString();
    }

    static String getDatabaseServerVersionQuery(String databaseType) {
        String versionQuery = "";
        if ("MySQL".equals(databaseType)) {
            versionQuery = SQL_VERSION_QUERY_MYSQL;
        }
        return versionQuery;
    }

    static int getMaximumColumnNameLengthForDatabase(String databaseType, String versionString) {
        int maximumColumnNameLength = 25;
        if ("MySQL".equals(databaseType)) {
            maximumColumnNameLength = DatabaseUtil.getMySQLMaximumAllowedColumnNameLengthForVersion(versionString);
        }
        return maximumColumnNameLength;
    }

    static SimulationField createSimulationField(String name, String dataType, String databaseType) {
        return new SimulationField(name, null, false);
    }

    private static String getEREDataType(String dataType, String databaseType) {
        String[][] stringToUse = null;
        if (databaseType.equals("MySQL")) {
            stringToUse = dataJavaToMySql;
        }
        for (String[] current : stringToUse) {
            if (!dataType.toUpperCase().equals(current[1])) continue;
            return current[0];
        }
        return null;
    }

    private static String getDBDataType(String dataType, String databaseType) {
        String dataTypeString = dataJavaToMySql[0][1];
        String[][] stringToUse = null;
        if ("MySQL".equals(databaseType)) {
            stringToUse = dataJavaToMySql;
        }
        if (stringToUse != null) {
            for (String[] current : stringToUse) {
                if (!dataType.equals(current[0])) continue;
                dataTypeString = current[1];
                break;
            }
        }
        return dataTypeString;
    }

    private static int getMySQLMaximumAllowedColumnNameLengthForVersion(String versionString) {
        String[] split = versionString.split("\\.");
        int calculatedMaxinumLength = 25;
        if (split.length >= 2 && DatabaseUtil.checkIfMySQLServerVersionIsPost41(split[0], split[1])) {
            calculatedMaxinumLength = 64;
        }
        return calculatedMaxinumLength;
    }

    private static boolean checkIfMySQLServerVersionIsPost41(String majorVersionString, String minorVersionString) {
        Pattern p = Pattern.compile("\\d{1,7}");
        Matcher majorMatcher = p.matcher(majorVersionString);
        Matcher minorMatcher = p.matcher(minorVersionString);
        if (majorMatcher.matches() && minorMatcher.matches()) {
            int majorVersionNumber = Integer.parseInt(majorVersionString);
            int minorVersionNumber = Integer.parseInt(minorVersionString);
            return majorVersionNumber > 4 || majorVersionNumber == 4 && minorVersionNumber >= 1;
        }
        return false;
    }

    static List<SimulationField> arrangeFieldsForTable(List<SimulationField> allFields) {
        ArrayList<SimulationField> commonFields = new ArrayList<SimulationField>();
        ArrayList<ContextSimulationField> contextFields = new ArrayList<ContextSimulationField>();
        for (int i = 0; i < allFields.size(); ++i) {
            SimulationField field = allFields.get(i);
            if (field instanceof ContextSimulationField) {
                contextFields.add((ContextSimulationField)field);
                continue;
            }
            commonFields.add(field);
        }
        if (contextFields.size() > 0) {
            commonFields.add(DatabaseUtil.groupContextFields(contextFields));
        }
        return commonFields;
    }

    private static SimulationField groupContextFields(List<ContextSimulationField> contextFields) {
        StringBuilder nameBuilder = new StringBuilder();
        StringBuilder valueBuilder = new StringBuilder();
        for (SimulationField simulationField : contextFields) {
            nameBuilder.append(simulationField.getName());
            DataType dt = DataType.fromObjectClass(simulationField.getValueObject());
            valueBuilder.append(dt.makeParseableString(simulationField.getValueObject()));
            if (simulationField.equals(contextFields.get(contextFields.size() - 1))) continue;
            nameBuilder.append("\u00a4");
            valueBuilder.append("\u00a4");
        }
        SimulationField contextField = new SimulationField("", "", false);
        contextField.setName(nameBuilder.toString());
        contextField.setValueObject(valueBuilder.toString());
        return contextField;
    }
}

