/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.input.db;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.ere.gui.simulator.input.db.DatabaseAccess;
import com.ericsson.ere.gui.simulator.input.db.DatabaseConfig;
import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.UtilMenuItem;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Node;

public class JDBCConfigDialog
extends JPanel
implements DataItem,
UtilMenuItem {
    private boolean isModified = false;
    private JComboBox boxDbNames = new JComboBox();
    private JButton btnDelete = new JButton();
    private JButton btnSave = new JButton();
    private JButton btnClose = new JButton("Close");
    private VarTable2 myDbInfo = new VarTable2();
    private VarTableModel myDbInfoModel = new VarTableModel();
    private int previouslySelectedIndex = 0;
    private JInternalFrame myInternalFrame;

    public JDBCConfigDialog(JInternalFrame frame, Node config) {
        this.myInternalFrame = frame;
        DatabaseAccess.loadDatabaseConfig();
        this.myDbInfoModel.setData(this.createDbConfigList("", "", "", "", ""));
        this.myDbInfo.setTableModel(this.myDbInfoModel);
        this.init();
    }

    private void init() {
        this.myInternalFrame.setFrameIcon(RmaDefs.getImageIcon("data_gear16.png"));
        this.fillBoxDbNames();
        this.boxDbNames.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int selected;
                if (e.getStateChange() == 2) {
                    JDBCConfigDialog.this.previouslySelectedIndex = DatabaseAccess.getConfig().indexOf(e.getItem()) + 1;
                    return;
                }
                if (JDBCConfigDialog.this.isModified) {
                    if (!DialogFactory.getQuestionDialog(JDBCConfigDialog.this.getMe(), "Simulation Database Configuration", "The selected database connection has unsaved changes.\nDo you really want to go ahead without saving these changes?")) {
                        ItemListener[] listeners = JDBCConfigDialog.this.boxDbNames.getItemListeners();
                        JDBCConfigDialog.this.boxDbNames.removeItemListener(listeners[0]);
                        JDBCConfigDialog.this.boxDbNames.setSelectedIndex(JDBCConfigDialog.this.previouslySelectedIndex);
                        JDBCConfigDialog.this.boxDbNames.addItemListener(listeners[0]);
                        return;
                    }
                    JDBCConfigDialog.this.reset();
                }
                if ((selected = JDBCConfigDialog.this.boxDbNames.getSelectedIndex()) > 0) {
                    DatabaseConfig cfg = (DatabaseConfig)JDBCConfigDialog.this.boxDbNames.getSelectedItem();
                    JDBCConfigDialog.this.myDbInfoModel.setData(JDBCConfigDialog.this.createDbConfigList(cfg.get("Name"), cfg.get("Type"), cfg.get("Driver"), cfg.get("URL"), cfg.get("User")));
                    JDBCConfigDialog.this.btnDelete.setEnabled(true);
                    JDBCConfigDialog.this.btnSave.setEnabled(false);
                } else {
                    JDBCConfigDialog.this.myDbInfoModel.setData(JDBCConfigDialog.this.createDbConfigList("", "", "", "", ""));
                    JDBCConfigDialog.this.btnDelete.setEnabled(false);
                    JDBCConfigDialog.this.btnSave.setEnabled(false);
                }
            }
        });
        this.boxDbNames.setSelectedIndex(0);
        this.btnDelete.setIcon(RmaDefs.getImageIcon("delete2_16.png"));
        this.btnSave.setIcon(RmaDefs.getImageIcon("disk_blue16.png"));
        this.btnClose.setIcon(RmaDefs.getImageIcon("door2_16.png"));
        this.btnDelete.setToolTipText("Delete");
        this.btnSave.setToolTipText("Save");
        this.btnDelete.setEnabled(false);
        this.btnSave.setEnabled(false);
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DialogFactory.getQuestionDialog(JDBCConfigDialog.this.getMe(), "Simulation Database Configuration", "Do you really want to delete the selected connection?")) {
                    return;
                }
                if (JDBCConfigDialog.this.boxDbNames.getSelectedIndex() > 0) {
                    JDBCConfigDialog.this.deleteItem(JDBCConfigDialog.this.boxDbNames.getSelectedIndex());
                }
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JDBCConfigDialog.this.checkInput()) {
                    DialogFactory.getInformationDialog(JDBCConfigDialog.this.getMe(), "Simulation Database Configuration", "Please enter information in all fields!");
                    return;
                }
                if (JDBCConfigDialog.this.boxDbNames.getSelectedIndex() == 0) {
                    JDBCConfigDialog.this.addItem();
                } else {
                    JDBCConfigDialog.this.saveItem(JDBCConfigDialog.this.boxDbNames.getSelectedIndex() - 1);
                }
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (JDBCConfigDialog.this.isModified) {
                        if (DialogFactory.getQuestionDialog(JDBCConfigDialog.this.getMe(), "Simulation Database Configuration", "The selected database connection has unsaved changes.\nDo you really want to go ahead without saving these changes?")) {
                            JDBCConfigDialog.this.myInternalFrame.setClosed(true);
                        }
                    } else {
                        JDBCConfigDialog.this.myInternalFrame.setClosed(true);
                    }
                }
                catch (Exception ex) {
                    ExceptionUtil.handleException(ex, "simulation", 1, "Failed to close Simulation ", false);
                }
            }
        });
        JPanel dbConfigPanel = new JPanel(new GridBagLayout());
        dbConfigPanel.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new GridBagLayout());
        dbConfigPanel.add((Component)this.boxDbNames, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 0, 0), 0, 0));
        dbConfigPanel.add((Component)this.btnDelete, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 5, 0, 0), 0, 0));
        dbConfigPanel.add((Component)this.btnSave, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 5, 0, 8), 0, 0));
        dbConfigPanel.add((Component)new JScrollPane(this.myDbInfo), new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 8, 8, 8), 0, 0));
        this.add((Component)dbConfigPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.btnClose, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
    }

    private List<Variable> createDbConfigList(String name, String type, String driver, String url, String user) {
        ArrayList<Variable> config = new ArrayList<Variable>();
        config.add(new StringVariable("Name", name));
        if (type == null || type.equals("")) {
            config.add(new DropDownVariable("Type", (Object)"MySQL", (Object[])new String[]{"MySQL"}));
            type = "MySQL";
        } else {
            config.add(new DropDownVariable("Type", (Object)type, (Object[])new String[]{"MySQL"}));
        }
        if (driver == null || driver.equals("")) {
            String defaultDriver = "";
            if (type.equals("MySQL")) {
                defaultDriver = "com.mysql.jdbc.Driver";
            }
            config.add(new StringVariable("Driver", defaultDriver));
        } else {
            config.add(new StringVariable("Driver", driver));
        }
        if (url == null || url.equals("")) {
            String defaultUrl = "";
            if (type.equals("MySQL")) {
                defaultUrl = "jdbc:mysql://SERVER_ADDRESS/DATABASE_NAME";
            }
            config.add(new StringVariable("URL", defaultUrl));
        } else {
            config.add(new StringVariable("URL", url));
        }
        config.add(new StringVariable("User", user));
        for (Variable var : config) {
            var.setDataItem(this);
        }
        return config;
    }

    private void fillBoxDbNames() {
        this.boxDbNames.removeAllItems();
        String value = "< New Database Connection >";
        this.boxDbNames.addItem(value);
        for (DatabaseConfig connection : DatabaseAccess.getConfig()) {
            this.boxDbNames.addItem(connection);
        }
    }

    private boolean checkInput() {
        for (Variable var : this.myDbInfoModel.getData()) {
            if (!var.getValueString().equals("")) continue;
            return false;
        }
        return true;
    }

    private void deleteItem(int selected) {
        DatabaseAccess.getConfig().remove(selected - 1);
        this.saveConfig();
        this.fillBoxDbNames();
        this.boxDbNames.setSelectedIndex(0);
    }

    private void addItem() {
        this.saveItem(this.boxDbNames.getItemCount() - 1);
    }

    private void saveItem(int index) {
        DatabaseConfig config;
        if (index == DatabaseAccess.getConfig().size()) {
            config = new DatabaseConfig(null, null, null, null, null);
            DatabaseAccess.getConfig().add(config);
        } else {
            config = DatabaseAccess.getConfig().get(index);
        }
        config.set("Name", VarListUtil.getStringValueForName(this.myDbInfoModel.getData(), "Name"));
        config.set("Type", VarListUtil.getStringValueForName(this.myDbInfoModel.getData(), "Type"));
        config.set("Driver", VarListUtil.getStringValueForName(this.myDbInfoModel.getData(), "Driver"));
        config.set("URL", VarListUtil.getStringValueForName(this.myDbInfoModel.getData(), "URL"));
        config.set("User", VarListUtil.getStringValueForName(this.myDbInfoModel.getData(), "User"));
        this.saveConfig();
        this.fillBoxDbNames();
        this.boxDbNames.setSelectedIndex(Math.min(index + 1, this.boxDbNames.getItemCount() - 1));
    }

    public void saveConfig() {
        try {
            DatabaseAccess.saveDatabaseConfig();
            this.reset();
        }
        catch (Exception e) {
            DialogFactory.getErrorDialog(this, "Simulation Database Configuration", "There was an error saving the Simulation Database Configuration!\n" + e.getMessage());
        }
    }

    private JDBCConfigDialog getMe() {
        return this;
    }

    @Override
    public Object getDataItem(Object reference) {
        return null;
    }

    @Override
    public Object getDataItem() {
        return null;
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    @Override
    public void reset() {
        this.isModified = false;
    }

    @Override
    public void setDataItem(Object reference, Object object) {
        VarListUtil.getVariableForName(this.myDbInfoModel.getData(), reference.toString()).getValueString();
        if (this.boxDbNames.getSelectedIndex() == 0) {
            if (!((Variable)object).getValueString().equals("")) {
                this.isModified = true;
                this.btnSave.setEnabled(true);
            }
        } else {
            DatabaseConfig connection = DatabaseAccess.getConfig().get(this.boxDbNames.getSelectedIndex() - 1);
            String oldValue = connection.get(reference.toString());
            if (!oldValue.equals(((Variable)object).getValueString())) {
                this.isModified = true;
                this.btnSave.setEnabled(true);
            }
        }
    }

    @Override
    public void setDataItem(Object object) {
        this.isModified = true;
        this.btnSave.setEnabled(true);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return "Simulation Database Configuration";
    }

    @Override
    public boolean isClosable() {
        return true;
    }

    @Override
    public boolean isIconifiable() {
        return true;
    }

    @Override
    public boolean isMaximizable() {
        return true;
    }

    @Override
    public boolean isResizable() {
        return true;
    }
}

